﻿// --------------------------------------------------------------------------------
// <copyright>
// Copyright (C)Nintendo. All rights reserved.
//
// These coded instructions, statements, and computer programs contain proprietary
// information of Nintendo and/or its licensed developers and are protected by
// national and international copyright laws. They may not be disclosed to third
// parties or copied or duplicated in any form, in whole or in part, without the
// prior written consent of Nintendo.
//
// The content herein is highly confidential and should be handled accordingly.
// </copyright>
// --------------------------------------------------------------------------------
namespace NintendoWare.Spy.Plugins
{
    /// <summary>
    /// フレーム同期情報のモデルプラグインです。
    /// </summary>
    public sealed class FrameSyncSpyModelPlugin : SpyModelPlugin
    {
        /// <summary>
        /// フレーム同期情報のデータ名です。
        /// </summary>
        public const string SpyDataName = "Time";

        //-----------------------------------------------------------------

        /// <summary>
        /// データ名を取得します。
        /// </summary>
        public override string DataName
        {
            get { return SpyDataName; }
        }

        //-----------------------------------------------------------------

        /// <summary>
        /// モデルを生成します。
        /// </summary>
        /// <returns>生成したモデルを返します。</returns>
        public override SpyModel CreateSpyModel()
        {
            return new FrameSyncSpyModel();
        }
    }
}
