﻿// --------------------------------------------------------------------------------
// <copyright>
// Copyright (C)Nintendo. All rights reserved.
//
// These coded instructions, statements, and computer programs contain proprietary
// information of Nintendo and/or its licensed developers and are protected by
// national and international copyright laws. They may not be disclosed to third
// parties or copied or duplicated in any form, in whole or in part, without the
// prior written consent of Nintendo.
//
// The content herein is highly confidential and should be handled accordingly.
// </copyright>
// --------------------------------------------------------------------------------
namespace NintendoWare.Spy.Foundation.Commands
{
    /// <summary>
    /// CommandStatus の拡張機能を提供します。
    /// </summary>
    public static class CommandStatusExtension
    {
        /// <summary>
        /// コマンドの状態が有効かどうか調べます。
        /// </summary>
        /// <param name="value">コマンドを指定します。</param>
        /// <returns>有効なら true、無効なら false を返します。</returns>
        public static bool IsSupported(this CommandStatus value)
        {
            return value != CommandStatus.Unsupported;
        }

        /// <summary>
        /// コマンドの状態が有効かどうか調べます。
        /// </summary>
        /// <param name="value">コマンドを指定します。</param>
        /// <returns>有効なら true、無効なら false を返します。</returns>
        public static bool IsEnabled(this CommandStatus value)
        {
            return value == CommandStatus.Enabled;
        }
    }
}
