﻿// --------------------------------------------------------------------------------
// <copyright>
// Copyright (C)Nintendo. All rights reserved.
//
// These coded instructions, statements, and computer programs contain proprietary
// information of Nintendo and/or its licensed developers and are protected by
// national and international copyright laws. They may not be disclosed to third
// parties or copied or duplicated in any form, in whole or in part, without the
// prior written consent of Nintendo.
//
// The content herein is highly confidential and should be handled accordingly.
// </copyright>
// --------------------------------------------------------------------------------
using Nintendo.ToolFoundation.Contracts;
using System;

namespace NintendoWare.Spy.Foundation.Commands
{
    /// <summary>
    /// コマンドイベントデータを保持するクラスです。
    /// </summary>
    public class CommandEventArgs : EventArgs
    {
        private readonly ICommandTarget _commandTarget;
        private readonly Command _command;
        private readonly CommandArgs _commandArgs;
        private readonly CommandResult _result;

        //-----------------------------------------------------------------

        /// <summary>
        /// コンストラクタです。
        /// </summary>
        /// <param name="commandTarget">コマンドの実行対象を指定します。</param>
        /// <param name="command">コマンドを指定します。</param>
        /// <param name="result">コマンドの処理結果を指定します。</param>
        public CommandEventArgs(ICommandTarget commandTarget, Command command, CommandResult result) :
            this(commandTarget, command, null, result)
        {
        }

        /// <summary>
        /// コンストラクタです。
        /// </summary>
        /// <param name="command">コマンドの実行対象を指定します。</param>
        /// <param name="command">コマンドを指定します。</param>
        /// <param name="commandArgs">コマンド引数を指定します。</param>
        /// <param name="result">コマンドの処理結果を指定します。</param>
        public CommandEventArgs(ICommandTarget commandTarget, Command command, CommandArgs commandArgs, CommandResult result)
        {
            Ensure.Argument.NotNull(commandTarget);
            Ensure.Argument.NotNull(command);
            Ensure.Argument.NotNull(result);

            _commandTarget = commandTarget;
            _command = command;
            _commandArgs = commandArgs;
            _result = result;
        }

        //-----------------------------------------------------------------

        /// <summary>
        /// コマンドの実行対象を取得します。
        /// </summary>
        public ICommandTarget CommandTarget
        {
            get { return _commandTarget; }
        }

        /// <summary>
        /// コマンドを取得します。
        /// </summary>
        public Command Command
        {
            get { return _command; }
        }

        /// <summary>
        /// コマンド引数を取得します。
        /// </summary>
        public CommandArgs CommandArgs
        {
            get { return _commandArgs; }
        }

        /// <summary>
        /// コマンドの処理結果を取得します。
        /// </summary>
        public CommandResult Result
        {
            get { return _result; }
        }
    }
}
