﻿// --------------------------------------------------------------------------------
// <copyright>
// Copyright (C)Nintendo. All rights reserved.
//
// These coded instructions, statements, and computer programs contain proprietary
// information of Nintendo and/or its licensed developers and are protected by
// national and international copyright laws. They may not be disclosed to third
// parties or copied or duplicated in any form, in whole or in part, without the
// prior written consent of Nintendo.
//
// The content herein is highly confidential and should be handled accordingly.
// </copyright>
// --------------------------------------------------------------------------------
using Nintendo.ToolFoundation.Contracts;
using System.Collections.Generic;
using System.IO;

namespace NintendoWare.Spy.Extensions
{
    /// <summary>
    /// <see cref="TextReader"/> の拡張メソッドを提供します。
    /// </summary>
    public static class TextReaderExtension
    {
        /// <summary>
        /// <see cref="TextReader.ReadLine"/> で一行ずつ読み込むシーケンスを返します。
        /// </summary>
        /// <param name="textReader">TextReader です。</param>
        /// <returns>１行ごとの文字列のシーケンスを返します。改行コードは含まれません。</returns>
        public static IEnumerable<string> ReadLines(this TextReader textReader)
        {
            Ensure.Argument.NotNull(textReader);

            return ReadLinesImpl(textReader);
        }

        private static IEnumerable<string> ReadLinesImpl(TextReader textReader)
        {
            for (var line = textReader.ReadLine(); line != null; line = textReader.ReadLine())
            {
                yield return line;
            }
        }
    }
}
