﻿// --------------------------------------------------------------------------------
// <copyright>
// Copyright (C)Nintendo. All rights reserved.
//
// These coded instructions, statements, and computer programs contain proprietary
// information of Nintendo and/or its licensed developers and are protected by
// national and international copyright laws. They may not be disclosed to third
// parties or copied or duplicated in any form, in whole or in part, without the
// prior written consent of Nintendo.
//
// The content herein is highly confidential and should be handled accordingly.
// </copyright>
// --------------------------------------------------------------------------------
using System;
using System.IO;

namespace NintendoWare.Spy.Extensions
{
    public static class BinaryWriterExtension
    {
        public static void Align(this BinaryWriter writer, int alignment)
        {
            if (writer == null) { throw new ArgumentNullException("writer"); }
            if (alignment <= 0) { throw new ArgumentOutOfRangeException("alignment"); }

            // 2のべき乗であるかどうかを判定します。
            if ((alignment & (alignment - 1)) != 0)
            {
                throw new ArgumentException();
            }

            long pos = writer.BaseStream.Position;
            long alignedPos = (pos + (alignment - 1)) & ~(alignment - 1);
            int fillSize = (int)(alignedPos - pos);

            for (int i = 0; i < fillSize; i++)
            {
                writer.BaseStream.WriteByte(0x0);
            }
        }
    }
}
