﻿// --------------------------------------------------------------------------------
// <copyright>
// Copyright (C)Nintendo. All rights reserved.
//
// These coded instructions, statements, and computer programs contain proprietary
// information of Nintendo and/or its licensed developers and are protected by
// national and international copyright laws. They may not be disclosed to third
// parties or copied or duplicated in any form, in whole or in part, without the
// prior written consent of Nintendo.
//
// The content herein is highly confidential and should be handled accordingly.
// </copyright>
// --------------------------------------------------------------------------------
using Nintendo.ToolFoundation;
using Nintendo.ToolFoundation.Contracts;
using System;
using System.Collections.Generic;
using System.Diagnostics.CodeAnalysis;
using System.Reflection;

namespace NintendoWare.Spy.Communication
{
    internal class SetOutputDirPacket : Packet<SetOutputDirPacket.Content>
    {
        /// <summary>
        /// 出力ディレクトリの文字列長の最大値(ヌル文字を含む)。
        /// </summary>
        public const int MaxOutputDirPathLength = 512;

        public SetOutputDirPacket() :
            base(SpySession._Signature, (uint)PacketID.SetOutputDir)
        { }

        //-----------------------------------------------------------------

        [SuppressMessage("StyleCop.CSharp.ReadabilityRules", "SA1121:UseBuiltInTypeAlias", Justification = "バイナリのサイズを明示するため")]
        public class Content : PacketBody
        {
            // 簡単のためにパケットは固定長とします。
            private readonly byte[] _path = new byte[MaxOutputDirPathLength];

            public override uint Size
            {
                get
                {
                    return (uint)(sizeof(Int32) + this.Length);
                }
            }

            public UInt32 Length { get { return (UInt32)_path.Length; } }

            public byte[] Path { get { return _path; } }

            public void SetPath(string path)
            {
                var i = System.Text.Encoding.Default.GetBytes(path, 0, path.Length, _path, 0);
                Ensure.Operation.True(i < _path.Length);
                for (; i < _path.Length; ++i)
                {
                    _path[i] = 0;
                }
            }

            protected override IEnumerable<PropertyInfo> GetProperties()
            {
                yield return this.GetProperty(target => target.Length);
                yield return this.GetProperty(target => target.Path);
            }
        }
    }

    internal class SetOutputDirReplyPacket : Packet<NullPacketBody>
    {
        public SetOutputDirReplyPacket() :
            base(SpySession._Signature, (uint)PacketID.SetOutputDirReply)
        { }
    }
}
