﻿// --------------------------------------------------------------------------------
// <copyright>
// Copyright (C)Nintendo. All rights reserved.
//
// These coded instructions, statements, and computer programs contain proprietary
// information of Nintendo and/or its licensed developers and are protected by
// national and international copyright laws. They may not be disclosed to third
// parties or copied or duplicated in any form, in whole or in part, without the
// prior written consent of Nintendo.
//
// The content herein is highly confidential and should be handled accordingly.
// </copyright>
// --------------------------------------------------------------------------------
using Nintendo.ToolFoundation;
using System;
using System.Collections.Generic;
using System.Diagnostics.CodeAnalysis;
using System.Linq;
using System.Reflection;

namespace NintendoWare.Spy.Communication
{
    internal class SelectDataIDPacket : Packet<SelectDataIDPacket.Content>
    {
        public SelectDataIDPacket() :
            base(SpySession._Signature, (uint)PacketID.SelectDataID)
        { }

        //-----------------------------------------------------------------

        [SuppressMessage("StyleCop.CSharp.ReadabilityRules", "SA1121:UseBuiltInTypeAlias", Justification = "バイナリのサイズを明示するため")]
        public class Content : PacketBody
        {
            private UInt32[] _selectionFlags;

            public override uint Size
            {
                get
                {
                    return (uint)(
                        sizeof(UInt32) // _SelectionFlagsLength
                        + sizeof(UInt32) * _SelectionFlagsLength); // _SelectionFlags
                }
            }

            public UInt32[] SelectionFlags
            {
                get
                {
                    return _selectionFlags;
                }

                set
                {
                    _selectionFlags = value;
                    this.OnSizeChanged();
                }
            }

            private int _SelectionFlagsLength
            {
                get { return (this.SelectionFlags != null) ? this.SelectionFlags.Length : 0; }
            }

            private IList<UInt32> _SelectionFlags
            {
                get { return this.SelectionFlags.ToList(); }
            }

            protected override IEnumerable<PropertyInfo> GetProperties()
            {
                yield return this.GetProperty(target => target._SelectionFlagsLength);
                yield return this.GetProperty(target => target._SelectionFlags);
            }
        }
    }

    internal class SelectDataIDReplyPacket : Packet<NullPacketBody>
    {
        public SelectDataIDReplyPacket() :
            base(SpySession._Signature, (uint)PacketID.SelectDataIDReply)
        { }
    }
}
