﻿// --------------------------------------------------------------------------------
// <copyright>
// Copyright (C)Nintendo. All rights reserved.
//
// These coded instructions, statements, and computer programs contain proprietary
// information of Nintendo and/or its licensed developers and are protected by
// national and international copyright laws. They may not be disclosed to third
// parties or copied or duplicated in any form, in whole or in part, without the
// prior written consent of Nintendo.
//
// The content herein is highly confidential and should be handled accordingly.
// </copyright>
// --------------------------------------------------------------------------------
using Microsoft.Win32;
using Nintendo.ToolFoundation.Contracts;

namespace NintendoWare.Spy.Commands
{
    public static class SaveFileDialogCommandHandler
    {
        public static string[] Execute(SaveFileDialogCommandArgs commandArgs)
        {
            Ensure.Argument.NotNull(commandArgs);

            var dialog = new SaveFileDialog()
            {
                Title = commandArgs.Title,
                FileName = commandArgs.FileName,
                Filter = commandArgs.Filter,
                FilterIndex = commandArgs.FilterIndex,
                DefaultExt = commandArgs.DefaultExtension,
                InitialDirectory = commandArgs.InitialDirectory,
                CheckFileExists = commandArgs.CheckFileExists,
                CheckPathExists = commandArgs.CheckPathExists,
            };

            var result = dialog.ShowDialog(commandArgs.OwnerWindow);

            if (!result.HasValue || !result.Value)
            {
                return null;
            }

            return dialog.FileNames;
        }
    }
}
