﻿// --------------------------------------------------------------------------------
// <copyright>
// Copyright (C)Nintendo. All rights reserved.
//
// These coded instructions, statements, and computer programs contain proprietary
// information of Nintendo and/or its licensed developers and are protected by
// national and international copyright laws. They may not be disclosed to third
// parties or copied or duplicated in any form, in whole or in part, without the
// prior written consent of Nintendo.
//
// The content herein is highly confidential and should be handled accordingly.
// </copyright>
// --------------------------------------------------------------------------------
using Nintendo.ToolFoundation.ComponentModel;
using Nintendo.ToolFoundation.Contracts;
using System.IO;

namespace NintendoWare.Spy.Binary
{
    internal class SpyDataListWriter : ObservableObject
    {
        private StreamWriter _writer;

        //-----------------------------------------------------------------

        public SpyDataListWriter(Stream stream)
        {
            Ensure.Argument.NotNull(stream);
            Ensure.Operation.Null(_writer);

            _writer = new StreamWriter(stream);
        }

        //-----------------------------------------------------------------

        public void Close()
        {
            this.Dispose();
        }

        public void WriteItem(string path)
        {
            Ensure.Argument.StringIsNotNullOrEmpty(path);

            _writer.WriteLine(path);
        }

        protected override void Dispose(bool disposing)
        {
            if (_writer != null)
            {
                _writer.Dispose();
                _writer = null;
            }

            base.Dispose(disposing);
        }
    }
}
