﻿// --------------------------------------------------------------------------------
// <copyright>
// Copyright (C)Nintendo. All rights reserved.
//
// These coded instructions, statements, and computer programs contain proprietary
// information of Nintendo and/or its licensed developers and are protected by
// national and international copyright laws. They may not be disclosed to third
// parties or copied or duplicated in any form, in whole or in part, without the
// prior written consent of Nintendo.
//
// The content herein is highly confidential and should be handled accordingly.
// </copyright>
// --------------------------------------------------------------------------------
using NintendoWare.Spy;
using NintendoWare.Spy.Plugins;
using NintendoWare.Spy.Windows;
using System.Windows.Controls;

namespace NintendoWare.SpySample.Windows
{
    internal class SampleAPanelPresenter : SpyPanelPresenter
    {
        private SampleAPanel view;
        private SampleAPanelViewModel viewModel;

        protected override void OnUninitialize()
        {
            Disposer.SafeDispose(ref this.viewModel);

            base.OnUninitialize();
        }

        protected override Control CreateContent()
        {
            this.viewModel = new SampleAPanelViewModel(this.GetPlaybackService());

            this.view = new SampleAPanel()
            {
                DataContext = this.viewModel,
            };

            return this.view;
        }

        protected override void UpdateSpyModel(string dataName, SpyModel model)
        {
            switch (dataName)
            {
                case PlotSpyModelPlugin.SpyDataName:
                    this.viewModel.SetPlotModel((PlotSpyModel)model);
                    break;
            }
        }
    }
}
