﻿// --------------------------------------------------------------------------------
// <copyright>
// Copyright (C)Nintendo. All rights reserved.
//
// These coded instructions, statements, and computer programs contain proprietary
// information of Nintendo and/or its licensed developers and are protected by
// national and international copyright laws. They may not be disclosed to third
// parties or copied or duplicated in any form, in whole or in part, without the
// prior written consent of Nintendo.
//
// The content herein is highly confidential and should be handled accordingly.
// </copyright>
// --------------------------------------------------------------------------------
using Nintendo.ToolFoundation.ComponentModel;
using Nintendo.ToolFoundation.Contracts;
using NintendoWare.NwSoundSpyPlugin.Models;
using NintendoWare.Spy;
using NintendoWare.Spy.Windows;
using System;
using System.Windows.Forms;

namespace NintendoWare.NwSoundSpyPlugin.Windows
{
    public sealed class ChannelMeterPanelPresenter : FormsSpyPanelPresenter
    {
        private readonly object _observerOwner = new object();
        private ChannelMeterControl _view;
        private VoiceInfoSpyModel _model;

        //-----------------------------------------------------------------

        protected override Control CreateControl()
        {
            Assertion.Operation.Null(_view);

            _view = new ChannelMeterControl();
            _view.PauseFlag = !this.GetPlaybackService().ShouldAutoScroll;

            return _view;
        }

        protected override void OnInitialize()
        {
            base.OnInitialize();

            PropertyChangedObservation.GetObserver(_observerOwner, this.GetPlaybackService())
                .AddHandler(
                    target => target.Current,
                    (target, args) => this.UpdateCurrentFrame());

            PropertyChangedObservation.GetObserver(_observerOwner, this.GetPlaybackService())
                .AddHandler(
                    target => target.ShouldAutoScroll,
                    (target, args) => this.UpdatePauseFlag());

            this.UpdateCurrentFrame();
            this.UpdatePauseFlag();
        }

        protected override void OnUninitialize()
        {
            PropertyChangedObservation.RemoveObservers(_observerOwner);

            _view = null;

            base.OnUninitialize();
        }

        protected override void UpdateSpyModel(string dataName, SpyModel model)
        {
            if (object.ReferenceEquals(_model, model))
            {
                return;
            }

            if (_model != null)
            {
                _model.UpdateEvent -= this.UpdateEventHandler;
            }

            _model = model as VoiceInfoSpyModel;

            if (_model == null)
            {
                _view.Reset();
                return;
            }

            _model.UpdateEvent += this.UpdateEventHandler;

            _view.VoiceArrayList = _model.VoiceArrayList;

            this.UpdateCurrentFrame();
        }

        private void UpdateCurrentFrame()
        {
            if (_model == null)
            {
                return;
            }

            int index = _model.FindIndexFromTime(this.GetPlaybackService().Current.AudioFrame);
            if (index >= 0)
            {
                _view.SetCurrentIndex(index);
            }
        }

        private void UpdatePauseFlag()
        {
            _view.PauseFlag = !this.GetPlaybackService().ShouldAutoScroll;
        }

        private void UpdateEventHandler(object sender, EventArgs e)
        {
            _view.VoiceArrayList = _model.VoiceArrayList;

            if (!_view.PauseFlag)
            {
                //   _view.Invalidate();
            }
        }
    }
}
