﻿// --------------------------------------------------------------------------------
// <copyright>
// Copyright (C)Nintendo. All rights reserved.
//
// These coded instructions, statements, and computer programs contain proprietary
// information of Nintendo and/or its licensed developers and are protected by
// national and international copyright laws. They may not be disclosed to third
// parties or copied or duplicated in any form, in whole or in part, without the
// prior written consent of Nintendo.
//
// The content herein is highly confidential and should be handled accordingly.
// </copyright>
// --------------------------------------------------------------------------------
using Nintendo.ToolFoundation.ComponentModel;
using NintendoWare.Spy;
using System.Windows.Media;

namespace NintendoWare.NnAtkSpyPlugin.Windows
{
    /// <summary>
    /// カレントタイムの表示をアイテムのどこに描画するか指定する種類です。
    /// </summary>
    public enum DrawBorderType
    {
        /// <summary>
        /// 何もしません。
        /// </summary>
        None,

        /// <summary>
        /// アイテムの上に線を描画します。
        /// </summary>
        Top,

        /// <summary>
        /// アイテムの下に線を描画します。
        /// </summary>
        Bottom,

        /// <summary>
        /// アイテム自身に色を付けます。
        /// </summary>
        Full,
    }

    public class StartSoundHistoryItemViewModel : ObservableObject
    {
        private SpyTime _time;
        private string _soundName;
        private string _playerName;
        private string _archiveName;
        private float _volume;
        private float _priority;
        private string _soundType;
        private bool _isVisible;
        private DrawBorderType _drawBorder;

        /// <summary>
        /// SoundDataInfoSpyModelが更新された時にプロパティを再取得するために使用します。
        /// ビュー向けの情報では無いので変更は通知しません。
        /// </summary>
        public uint SoundId { get; set; }

        public SpyTime Time
        {
            get
            {
                return _time;
            }

            set
            {
                this.SetPropertyValue(ref _time, value);
            }
        }

        public string SoundName
        {
            get
            {
                return _soundName;
            }

            set
            {
                this.SetPropertyValue(ref _soundName, value);
            }
        }

        public string PlayerName
        {
            get
            {
                return _playerName;
            }

            set
            {
                this.SetPropertyValue(ref _playerName, value);
            }
        }

        public string ArchiveName
        {
            get
            {
                return _archiveName;
            }

            set
            {
                this.SetPropertyValue(ref _archiveName, value);
            }
        }

        public float Volume
        {
            get
            {
                return _volume;
            }

            set
            {
                if (this.SetPropertyValue(ref _volume, value))
                {
                    this.NotifyPropertyChanged(() => VolumeBrush);
                }
            }
        }

        public Brush VolumeBrush
        {
            get
            {
                return Brushes.DarkGray;
            }
        }

        public float Priority
        {
            get
            {
                return _priority;
            }

            set
            {
                if (this.SetPropertyValue(ref _priority, value))
                {
                    this.NotifyPropertyChanged(() => PriorityBrush);
                }
            }
        }

        public Brush PriorityBrush
        {
            get
            {
                return Brushes.DarkGray;
            }
        }

        public string SoundType
        {
            get
            {
                return _soundType;
            }

            set
            {
                this.SetPropertyValue(ref _soundType, value);
            }
        }

        /// <summary>
        /// カレントタイムの表示をアイテムのどこに描画するか指定します。
        /// </summary>
        public DrawBorderType DrawBorder
        {
            get
            {
                return _drawBorder;
            }

            set
            {
                this.SetPropertyValue(ref _drawBorder, value);
            }
        }

        public bool IsVisible
        {
            get
            {
                return _isVisible;
            }

            set
            {
                this.SetPropertyValue(ref _isVisible, value);
            }
        }
    }
}
