﻿// --------------------------------------------------------------------------------
// <copyright>
// Copyright (C)Nintendo. All rights reserved.
//
// These coded instructions, statements, and computer programs contain proprietary
// information of Nintendo and/or its licensed developers and are protected by
// national and international copyright laws. They may not be disclosed to third
// parties or copied or duplicated in any form, in whole or in part, without the
// prior written consent of Nintendo.
//
// The content herein is highly confidential and should be handled accordingly.
// </copyright>
// --------------------------------------------------------------------------------
using NintendoWare.NnAtkSpyPlugin.Windows;
using NintendoWare.Spy.Plugins;
using NintendoWare.Spy.Windows;
using System.Collections.Generic;

namespace NintendoWare.NnAtkSpyPlugin.Plugins
{
    /// <summary>
    /// Atk パフォーマンスパネルプラグインです。
    /// Atk パフォーマンスのプロットステートからパネルを作成するプレゼンターをフレームワークに注入します。
    /// </summary>
    internal class AtkPerformancePanelPlugin : SpyPanelPlugin
    {
        public const string ID = "atk/performance";

        //-----------------------------------------------------------------

        /// <summary>
        /// パネル ID を取得します。
        /// </summary>
        public override string PanelID
        {
            get { return ID; }
        }

        /// <summary>
        /// ローカライズされたタイトルを取得します。
        /// </summary>
        public override string PanelTitle
        {
            get { return Resources.SpyPanelNames.AtkPerformance; }
        }

        /// <summary>
        /// 必要な Spy データ名の列挙子を取得します。
        /// </summary>
        public override IEnumerable<string> RequiredSpyDataNames
        {
            get
            {
                yield return FrameSyncSpyModelPlugin.SpyDataName;
                yield return PlotSpyModelPlugin.SpyDataName;
            }
        }

        //-----------------------------------------------------------------

        /// <summary>
        /// パネルを作成する Spy パネルプレゼンターを生成します。
        /// </summary>
        /// <returns>生成した Spy パネルプレゼンターを返します。</returns>
        protected override SpyPanelPresenter CreatePresenterInstance()
        {
            return new AtkPerformancePanelPresenter();
        }
    }
}
