﻿// --------------------------------------------------------------------------------
// <copyright>
// Copyright (C)Nintendo. All rights reserved.
//
// These coded instructions, statements, and computer programs contain proprietary
// information of Nintendo and/or its licensed developers and are protected by
// national and international copyright laws. They may not be disclosed to third
// parties or copied or duplicated in any form, in whole or in part, without the
// prior written consent of Nintendo.
//
// The content herein is highly confidential and should be handled accordingly.
// </copyright>
// --------------------------------------------------------------------------------
using NintendoWare.Spy;
using NintendoWare.Spy.Plugins;
using System;

namespace NintendoWare.NnAtkSpyPlugin.Plugins
{
    /// <summary>
    /// Atk のモデルプラグインです。
    /// </summary>
    public sealed class AtkSpyModelPlugin : SpyModelPlugin
    {
        public const string SpyDataName = "NnSpyAtk";

        //-----------------------------------------------------------------

        public override string DataName
        {
            get { return SpyDataName; }
        }

        //-----------------------------------------------------------------

        /// <summary>
        /// モジュールを生成します。
        /// </summary>
        /// <returns>生成したモジュールを返します。</returns>
        public override SpyModel CreateSpyModel()
        {
            return new AtkSpyModel();
        }
    }
}
