﻿// --------------------------------------------------------------------------------
// <copyright>
// Copyright (C)Nintendo. All rights reserved.
//
// These coded instructions, statements, and computer programs contain proprietary
// information of Nintendo and/or its licensed developers and are protected by
// national and international copyright laws. They may not be disclosed to third
// parties or copied or duplicated in any form, in whole or in part, without the
// prior written consent of Nintendo.
//
// The content herein is highly confidential and should be handled accordingly.
// </copyright>
// --------------------------------------------------------------------------------
using System;
using System.Collections.Generic;
using System.Collections.ObjectModel;
using System.Collections.Specialized;
using System.ComponentModel;
using System.Dynamic;
using System.Globalization;
using System.IO;
using System.Linq;
using System.Reflection;
using System.Text;
using System.Threading.Tasks;
using System.Windows;
using System.Windows.Controls;
using System.Windows.Data;
using System.Windows.Documents;
using System.Windows.Input;
using System.Windows.Media;
using System.Windows.Media.Imaging;
using System.Windows.Navigation;
using System.Windows.Shapes;
using System.Xml;
using Xceed.Wpf.AvalonDock;
using Xceed.Wpf.AvalonDock.Layout.Serialization;
using Xceed.Wpf.Toolkit;
using Microsoft.Win32;

namespace WaveSoundEditor
{
    /// <summary>
    /// MainWindow.xaml の相互作用ロジック
    /// </summary>
    public partial class MainWindow : Window
    {
        private LayoutManager layoutManager = new LayoutManager();

        public MainWindow()
        {
            InitializeComponent();
        }

        /// <summary>
        ///
        /// </summary>
        /// <param name="sender"></param>
        /// <param name="e"></param>
        private void OnClosed(object sender, EventArgs e)
        {
            this.layoutManager.SaveLayout(this.dockingManager);
        }

        /// <summary>
        ///
        /// </summary>
        /// <param name="sender"></param>
        /// <param name="e"></param>
        private void OnLoaded(object sender, RoutedEventArgs e)
        {
            this.layoutManager.LoadLayout(this.dockingManager);
        }
    }

    /// <summary>
    ///
    /// </summary>
    public class LayoutManager
    {
        String LayoutFile
        {
            get
            {
                Assembly assembly = Assembly.GetExecutingAssembly();
                return System.IO.Path.ChangeExtension(assembly.Location, ".AvalonDock.config");
            }
        }

        public void LoadLayout(DockingManager dockManager)
        {
            try
            {
                Byte[] bytes = System.IO.File.ReadAllBytes(LayoutFile);
                if (!LoadLayout(dockManager, bytes))
                {
                    return;
                }
            }
            catch (FileNotFoundException)
            {
                return;
            }
        }

        bool LoadLayout(DockingManager dockManager, Byte[] bytes)
        {
            try
            {
                var serializer = new XmlLayoutSerializer(dockManager);
                using (var stream = new MemoryStream(bytes))
                {
                    serializer.Deserialize(stream);
                }
                return true;
            }
            catch (Exception)
            {
                return false;
            }
        }

        public void SaveLayout(DockingManager dockManager)
        {
            var serializer = new XmlLayoutSerializer(dockManager);
            var doc = new XmlDocument();
            using (var stream = new MemoryStream())
            {
                serializer.Serialize(stream);
                stream.Position = 0;
                doc.Load(stream);
            }
            using (var stream = new FileStream(LayoutFile, FileMode.Create))
            {
                doc.Save(stream);
            }
        }
    }
}
