﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#include "../precompiled.h"

#include <panels/SoundArchivePlayerPanel.h>
#include <models/PreviewSoundArchive.h>

namespace nw {
namespace snd {

SoundArchivePlayerPanel::SoundArchivePlayerPanel() :
m_pPreviewSoundArchive(NULL),
m_SoundHandleListSelectionChangedObserver(this, &SoundArchivePlayerPanel::OnSoundHandleListSelectionChanged)
{
    SetMargin(nw::internal::dw::Thickness(0.f));

    m_Contents.AddItem(&m_Container);
    SetContents(m_Contents);

    for(u32 i=0; i<PreviewSoundArchive::PREVIEW_SOUND_COUNT; ++i)
    {
        m_Container.AddItem(&m_SoundHandle[i]);
    }

    m_Container.GetSelectionChangedEvent() += m_SoundHandleListSelectionChangedObserver;
}

void SoundArchivePlayerPanel::Initialize(nw::snd::PreviewSoundArchive& previewSoundArchive)
{
    for(s32 i=0; i<previewSoundArchive.GetPreviewSoundCount(); ++i)
    {
        m_SoundHandle[i].Initialize(previewSoundArchive.GetPreviewSound(i));
    }

    // 最初のサウンドハンドルを選択します。
    if(previewSoundArchive.GetPreviewSoundCount() > 0)
    {
        m_Container.GetItemPlaceHolder(0).SetIsSelected(true);
    }

    m_pPreviewSoundArchive = &previewSoundArchive;
}

PreviewSoundListItem* SoundArchivePlayerPanel::GetPreviewSoundListItem(s32 index)
{
    NW_ASSERTMSG(m_pPreviewSoundArchive != NULL, "SoundArchivePlayerPanel is not initialized.");

    if( index >= m_pPreviewSoundArchive->GetPreviewSoundCount())
    {
        return NULL;
    }

    return &m_SoundHandle[index];
}

nw::snd::PreviewSound* SoundArchivePlayerPanel::GetSelectedPreviewSoundFirst() const
{
    NW_ASSERTMSG(m_pPreviewSoundArchive != NULL, "SoundArchivePlayerPanel is not initialized.");

    for(s32 i=0; i<m_pPreviewSoundArchive->GetPreviewSoundCount(); ++i)
    {
        const nw::internal::dw::ListBox::ListBoxItemPlaceHolder& placeHolder = m_Container.GetItemPlaceHolder(i);

        if(placeHolder.GetIsSelected())
        {
            PreviewSoundListItem* pListItem = static_cast<PreviewSoundListItem*>(placeHolder.GetContent());
            NW_ASSERT(pListItem != NULL);

            return &pListItem->GetPreviewSound();
        }
    }

    return NULL;
}

IPreviewSoundSelector::SelectionChangedEvent& SoundArchivePlayerPanel::GetSelectionChangedEvent()
{
    return m_SelectionChangedEvent;
}

void SoundArchivePlayerPanel::OnSoundHandleListSelectionChanged()
{
    m_SelectionChangedEvent.Invoke();
}

} // snd
} // nw
