﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#include "../../precompiled.h"

#ifdef NW_ENABLE_SNDCTRL
#include <nw/snd/ctrl/sndctrl_SequenceVariable.h>
using namespace nw::snd::ctrl::internal;
#else
#include <models/SequenceVariable.h>
#endif
#include <mcs/ItemContainer.h>
#include <mcs/handler/SetSequenceVariablesHandler.h>

namespace nw {
namespace snd {

//----------------------------------------------------------
void
SetSequenceVariablesHandler::Initialize(PreviewSoundArchive& previewSoundArchive)
{
    m_PreviewSoundArchive = &previewSoundArchive;
}

//----------------------------------------------------------
void
SetSequenceVariablesHandler::OnInvoke(
    const HioMessageHeader& header,
    const void* data,
    nw::ut::IoStream& writeStream)
{
#if defined(NW_DEBUG)
    NW_LOG("SetSequenceVariablesHandler\n");
#endif
    NW_NULL_ASSERT(m_PreviewSoundArchive);

    ItemContainerReader<const ToolSoundSequenceVariableContainer> inputItems( reinterpret_cast<const ToolSoundItemContainer*>( data ) );

    // コンテナの内容をパラメータに展開する
    while( 1 )
    {
        const ToolSoundSequenceVariableContainer* pInputItem = inputItems.Next();
        if( NULL == pInputItem ) break;

        // PreviewSound インデックスチェック
        if( pInputItem->header.previewSoundIndex >= (u32)m_PreviewSoundArchive->GetPreviewSoundCount() )
        {
            NW_WARNING( false, "Invalid PreviewSound Index : %d\n", pInputItem->header.previewSoundIndex );
            continue;
        }

        PreviewSound& previewSound = m_PreviewSoundArchive->GetPreviewSound( pInputItem->header.previewSoundIndex );
        previewSound.SetVariables( pInputItem );
    }
}

} // snd
} // nw
