﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#include "../../precompiled.h"

#include <mcs/handler/CloseSoundArchiveHandler.h>

namespace nw {
namespace snd {

//----------------------------------------------------------
CloseSoundArchiveHandler::CloseSoundArchiveHandler() :
m_PreviewSoundArchive(NULL)
{
}

//----------------------------------------------------------
void
CloseSoundArchiveHandler::Initialize(PreviewSoundArchive& previewSoundArchive)
{
    m_PreviewSoundArchive = &previewSoundArchive;
}

//----------------------------------------------------------
void
CloseSoundArchiveHandler::OnInvoke(
    const HioMessageHeader& header,
    const void* data,
    nw::ut::IoStream& writeStream)
{
#if defined(NW_DEBUG)
    NW_LOG("CloseSoundArchiveHandler\n");
#endif

    if(m_PreviewSoundArchive == NULL)
    {
        NW_WARNING(false, "CloseSoundArchiveHandler not initialized.");
        return;
    }

    m_PreviewSoundArchive->Close();

    Reply(writeStream, HIO_RESULT_SUCCESS);
}

//----------------------------------------------------------
void
CloseSoundArchiveHandler::Reply(nw::ut::IoStream& writeStream, HioResult result)
{
    HioReplyMessageHeader replyHeader(
        HIO_MESSAGE_CLOSE_SOUNDARCHIVE,
        sizeof(u32));
    replyHeader.result = result;

    writeStream.Write(&replyHeader, sizeof(HioReplyMessageHeader));
}


} // namespace nw::snd
} // namespace nw
