﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#include "../precompiled.h"
#include <io/ASyncWaveReader.h>

#include <nw/ut.h>
#include <nw/snd/fnd/io/sndfnd_WaveformStream.h>

namespace nw {
namespace snd {

ASyncWaveReader::ASyncWaveReader()
{
}

ASyncWaveReader::~ASyncWaveReader()
{
}

//---------------------------------------------------------------------------

bool ASyncWaveReader::Open(internal::fnd::WaveformStreamReader* reader, IStreamWriter* writer)
{
    NW_ASSERT_NOT_NULL(reader);
    NW_ASSERT_NOT_NULL(writer);

    m_Task.Reset();
    m_Task.Update(reader, writer, m_Buffer, BUFFER_SIZE);

    m_TaskThread.Start(1);

    // １タスク１回ですべてのデータを読み込むため、
    // RegisterTask はここでしか行いません。
    m_TaskThread.RegisterTask(m_Task);

    return true;
}

void ASyncWaveReader::Close()
{
    m_Task.Reset();

    if(m_TaskThread.IsStopping())
    {
        m_TaskThread.WaitStop();
    }
    else
    {
        m_TaskThread.StopImmediately();
    }
}

bool ASyncWaveReader::IsOpened()
{
    return m_TaskThread.IsRunning();
}

bool ASyncWaveReader::IsFinished()
{
    return m_Task.IsFinished();
}

} // snd
} // nw
