﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#include "../precompiled.h"

#include <controls/ReverbStdParameterListView.h>

namespace {

static const nw::snd::FxReverbEarlyReflectionMode s_EarlyReflectionModeValues[] =
{
    nw::snd::FX_REVERB_EARLY_REFLECTION_5MS,
    nw::snd::FX_REVERB_EARLY_REFLECTION_10MS,
    nw::snd::FX_REVERB_EARLY_REFLECTION_15MS,
    nw::snd::FX_REVERB_EARLY_REFLECTION_20MS,
    nw::snd::FX_REVERB_EARLY_REFLECTION_25MS,
    nw::snd::FX_REVERB_EARLY_REFLECTION_30MS,
    nw::snd::FX_REVERB_EARLY_REFLECTION_35MS,
    nw::snd::FX_REVERB_EARLY_REFLECTION_40MS,
};

static const nw::snd::FxReverbFusedMode s_FusedModeValues[] =
{
    nw::snd::FX_REVERB_FUSED_OLD_AXFX,
    nw::snd::FX_REVERB_FUSED_METAL_TANK,
    nw::snd::FX_REVERB_FUSED_SMALL_ROOM,
    nw::snd::FX_REVERB_FUSED_LARGE_ROOM,
    nw::snd::FX_REVERB_FUSED_HALL,
    nw::snd::FX_REVERB_FUSED_CAVERNOUS,
};

static nw::snd::FxReverbEarlyReflectionMode GetEarlyReflectionMode(nw::snd::PreviewEffectReverbStd* pParameter)
{
    NW_ASSERT(pParameter != NULL);
    return pParameter->GetEarlyReflectionMode();
}

static f32 GetPreDelayTimeMax(nw::snd::PreviewEffectReverbStd* pParameter)
{
    NW_ASSERT(pParameter != NULL);
    return pParameter->GetPreDelayTimeMax();
}

static f32 GetPreDelayTime(nw::snd::PreviewEffectReverbStd* pParameter)
{
    NW_ASSERT(pParameter != NULL);
    return pParameter->GetPreDelayTime();
}

static nw::snd::FxReverbFusedMode GetFusedMode(nw::snd::PreviewEffectReverbStd* pParameter)
{
    NW_ASSERT(pParameter != NULL);
    return pParameter->GetFusedMode();
}

static f32 GetFusedTime(nw::snd::PreviewEffectReverbStd* pParameter)
{
    NW_ASSERT(pParameter != NULL);
    return pParameter->GetFusedTime();
}

static f32 GetColoration(nw::snd::PreviewEffectReverbStd* pParameter)
{
    NW_ASSERT(pParameter != NULL);
    return pParameter->GetColoration();
}

static f32 GetDamping(nw::snd::PreviewEffectReverbStd* pParameter)
{
    NW_ASSERT(pParameter != NULL);
    return pParameter->GetDamping();
}

static f32 GetEarlyGain(nw::snd::PreviewEffectReverbStd* pParameter)
{
    NW_ASSERT(pParameter != NULL);
    return pParameter->GetEarlyGain();
}

static f32 GetFusedGain(nw::snd::PreviewEffectReverbStd* pParameter)
{
    NW_ASSERT(pParameter != NULL);
    return pParameter->GetFusedGain();
}

static f32 GetOutGain(nw::snd::PreviewEffectReverbStd* pParameter)
{
    NW_ASSERT(pParameter != NULL);
    return pParameter->GetOutGain();
}

static void SetEarlyReflectionMode(nw::snd::PreviewEffectReverbStd* pParameter, nw::snd::FxReverbEarlyReflectionMode value)
{
    NW_ASSERT(pParameter != NULL);
    pParameter->SetEarlyReflectionMode(value);
}

static void SetPreDelayTime(nw::snd::PreviewEffectReverbStd* pParameter, f32 value)
{
    NW_ASSERT(pParameter != NULL);
    pParameter->SetPreDelayTime(value);
}

static void SetPreDelayTimeMax(nw::snd::PreviewEffectReverbStd* pParameter, f32 value)
{
    NW_ASSERT(pParameter != NULL);

    if(value < GetPreDelayTime(pParameter))
    {
        SetPreDelayTime(pParameter, value);
    }

    pParameter->SetPreDelayTimeMax(value);
}

static void SetFusedMode(nw::snd::PreviewEffectReverbStd* pParameter, nw::snd::FxReverbFusedMode value)
{
    NW_ASSERT(pParameter != NULL);
    pParameter->SetFusedMode(value);
}

static void SetFusedTime(nw::snd::PreviewEffectReverbStd* pParameter, f32 value)
{
    NW_ASSERT(pParameter != NULL);
    pParameter->SetFusedTime(value);
}

static void SetColoration(nw::snd::PreviewEffectReverbStd* pParameter, f32 value)
{
    NW_ASSERT(pParameter != NULL);
    pParameter->SetColoration(value);
}

static void SetDamping(nw::snd::PreviewEffectReverbStd* pParameter, f32 value)
{
    NW_ASSERT(pParameter != NULL);
    pParameter->SetDamping(value);
}

static void SetEarlyGain(nw::snd::PreviewEffectReverbStd* pParameter, f32 value)
{
    NW_ASSERT(pParameter != NULL);
    pParameter->SetEarlyGain(value);
}

static void SetFusedGain(nw::snd::PreviewEffectReverbStd* pParameter, f32 value)
{
    NW_ASSERT(pParameter != NULL);
    pParameter->SetFusedGain(value);
}

static void SetOutGain(nw::snd::PreviewEffectReverbStd* pParameter, f32 value)
{
    NW_ASSERT(pParameter != NULL);
    pParameter->SetOutGain(value);
}

static void PrintF32Value(char* pText, u32 bufferLength, f32 value)
{
    nw::ut::snprintf(pText, bufferLength, bufferLength - 1, "%7.2f", value);
}

static void PrintEarlyReflectionMode(char* pText, u32 bufferLength, nw::snd::FxReverbEarlyReflectionMode value)
{
    const char* pValueText = "";

    switch(value)
    {
    case nw::snd::FX_REVERB_EARLY_REFLECTION_5MS:
        pValueText = "5ms";
        break;

    case nw::snd::FX_REVERB_EARLY_REFLECTION_10MS:
        pValueText = "10ms";
        break;

    case nw::snd::FX_REVERB_EARLY_REFLECTION_15MS:
        pValueText = "15ms";
        break;

    case nw::snd::FX_REVERB_EARLY_REFLECTION_20MS:
        pValueText = "20ms";
        break;

    case nw::snd::FX_REVERB_EARLY_REFLECTION_25MS:
        pValueText = "25ms";
        break;

    case nw::snd::FX_REVERB_EARLY_REFLECTION_30MS:
        pValueText = "30ms";
        break;

    case nw::snd::FX_REVERB_EARLY_REFLECTION_35MS:
        pValueText = "35ms";
        break;

    case nw::snd::FX_REVERB_EARLY_REFLECTION_40MS:
        pValueText = "40ms";
        break;
    }

    nw::ut::snprintf(pText, bufferLength, bufferLength - 1, "%s", pValueText);
}

static void PrintFusedMode(char* pText, u32 bufferLength, nw::snd::FxReverbFusedMode value)
{
    const char* pValueText = "";

    switch(value)
    {
    case nw::snd::FX_REVERB_FUSED_OLD_AXFX:
        pValueText = "Old Axfx";
        break;

    case nw::snd::FX_REVERB_FUSED_METAL_TANK:
        pValueText = "Metal Tank";
        break;

    case nw::snd::FX_REVERB_FUSED_SMALL_ROOM:
        pValueText = "Small Room";
        break;

    case nw::snd::FX_REVERB_FUSED_LARGE_ROOM:
        pValueText = "Large Room";
        break;

    case nw::snd::FX_REVERB_FUSED_HALL:
        pValueText = "Hall";
        break;

    case nw::snd::FX_REVERB_FUSED_CAVERNOUS:
        pValueText = "Cavernous";
        break;
    }

    nw::ut::snprintf(pText, bufferLength, bufferLength - 1, "%s", pValueText);
}

}

namespace nw {
namespace snd {

ReverbStdParameterListView::ReverbStdParameterListView() :
m_EaryReflectionModeControl(FX_REVERB_EARLY_REFLECTION_30MS),
m_FusedModeControl(FX_REVERB_FUSED_OLD_AXFX)
{
    m_EaryReflectionModeControl.Initialize(
        s_EarlyReflectionModeValues,
        sizeof(s_EarlyReflectionModeValues) / sizeof(FxReverbEarlyReflectionMode),
        GetEarlyReflectionMode,
        SetEarlyReflectionMode,
        PrintEarlyReflectionMode);
    m_EaryReflectionModeControl.SetLabelText("EarlyMode:");

    m_PreDelayTimeMaxControl.Initialize(GetPreDelayTimeMax, SetPreDelayTimeMax, PrintF32Value);
    m_PreDelayTimeMaxControl.SetLabelText("PreDelayTimeMax:");
    m_PreDelayTimeMaxControl.SetMinimumValue(0.f);
    m_PreDelayTimeMaxControl.SetMaximumValue(1.f);
    m_PreDelayTimeMaxControl.SetDefaultValue(0.15f);
    m_PreDelayTimeMaxControl.SetValueChange(0.01f);
    m_PreDelayTimeMaxControl.SetValueLargeChange(0.1f);

    m_PreDelayTimeControl.Initialize(GetPreDelayTime, SetPreDelayTime, PrintF32Value);
    m_PreDelayTimeControl.SetLabelText("PreDelayTime:");
    m_PreDelayTimeControl.SetMinimumValue(0.f);
    m_PreDelayTimeControl.SetMaximumValue(0.f);
    m_PreDelayTimeControl.SetDefaultValue(0.02f);
    m_PreDelayTimeControl.SetValueChange(0.01f);
    m_PreDelayTimeMaxControl.SetValueLargeChange(0.1f);

    m_FusedModeControl.Initialize(
        s_FusedModeValues,
        sizeof(s_FusedModeValues) / sizeof(FxReverbFusedMode),
        GetFusedMode,
        SetFusedMode,
        PrintFusedMode);
    m_FusedModeControl.SetLabelText("FusedMode:");

    m_FusedTimeControl.Initialize(GetFusedTime, SetFusedTime, PrintF32Value);
    m_FusedTimeControl.SetLabelText("FusedTime:");
    m_FusedTimeControl.SetMinimumValue(0.f);
    m_FusedTimeControl.SetMaximumValue(10.f);
    m_FusedTimeControl.SetDefaultValue(3.f);
    m_FusedTimeControl.SetValueChange(0.1f);
    m_FusedTimeControl.SetValueLargeChange(1.f);

    m_ColorationControl.Initialize(GetColoration, SetColoration, PrintF32Value);
    m_ColorationControl.SetLabelText("Coloration:");
    m_ColorationControl.SetMinimumValue(0.f);
    m_ColorationControl.SetMaximumValue(1.f);
    m_ColorationControl.SetDefaultValue(0.6f);
    m_ColorationControl.SetValueChange(0.01f);
    m_ColorationControl.SetValueLargeChange(0.1f);

    m_DampingControl.Initialize(GetDamping, SetDamping, PrintF32Value);
    m_DampingControl.SetLabelText("Damping:");
    m_DampingControl.SetMinimumValue(0.f);
    m_DampingControl.SetMaximumValue(1.f);
    m_DampingControl.SetDefaultValue(0.4f);
    m_DampingControl.SetValueChange(0.01f);
    m_DampingControl.SetValueLargeChange(0.1f);

    m_EarlyGainControl.Initialize(GetEarlyGain, SetEarlyGain, PrintF32Value);
    m_EarlyGainControl.SetLabelText("EarlyGain:");
    m_EarlyGainControl.SetMinimumValue(0.f);
    m_EarlyGainControl.SetMaximumValue(1.f);
    m_EarlyGainControl.SetDefaultValue(0.f);
    m_EarlyGainControl.SetValueChange(0.01f);
    m_EarlyGainControl.SetValueLargeChange(0.1f);

    m_FusedGainControl.Initialize(GetFusedGain, SetFusedGain, PrintF32Value);
    m_FusedGainControl.SetLabelText("FusedGain:");
    m_FusedGainControl.SetMinimumValue(0.f);
    m_FusedGainControl.SetMaximumValue(1.f);
    m_FusedGainControl.SetDefaultValue(1.f);
    m_FusedGainControl.SetValueChange(0.01f);
    m_FusedGainControl.SetValueLargeChange(0.1f);

    m_OutGainControl.Initialize(GetOutGain, SetOutGain, PrintF32Value);
    m_OutGainControl.SetLabelText("OutGain:");
    m_OutGainControl.SetMinimumValue(0.f);
    m_OutGainControl.SetMaximumValue(1.f);
    m_OutGainControl.SetDefaultValue(1.f);
    m_OutGainControl.SetValueChange(0.01f);
    m_OutGainControl.SetValueLargeChange(0.1f);

    AddItem(m_EaryReflectionModeControl);
    AddItem(m_PreDelayTimeMaxControl);
    AddItem(m_PreDelayTimeControl);
    AddItem(m_FusedModeControl);
    AddItem(m_FusedTimeControl);
    AddItem(m_ColorationControl);
    AddItem(m_DampingControl);
    AddItem(m_EarlyGainControl);
    AddItem(m_FusedGainControl);
    AddItem(m_OutGainControl);
}

void ReverbStdParameterListView::OnPrepareMeasure()
{
    if(m_PreDelayTimeMaxControl.GetModel() != NULL)
    {
        m_PreDelayTimeControl.SetMaximumValue(m_PreDelayTimeMaxControl.GetValue());
    }
}

} // snd
} // nw
