﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#pragma once

#include <nw/dw/control/dw_UIElement.h>
#include <nw/dw/control/dw_FixedUIElementList.h>
#include <nw/dw/control/dw_FixedStackPanel.h>
#include <nw/dw/control/dw_FixedDockPanel.h>
#include <nw/dw/control/dw_Separator.h>
#include <controls/PeakMeter.h>
#include <controls/FixedLabelVoiceCountPeakMeter.h>
#include <nw/snd.h>

namespace nw {
namespace snd {

class VoicePanel : public nw::internal::dw::UIElement
{
private:
    static const u32 MAX_VOICE_COUNT = nw::snd::SoundSystem::MAX_VOICE_COUNT;

public:
    VoicePanel();

protected:
    /*override*/ void OnUpdate(const nw::internal::dw::UIElementTreeContext& context);

private:
    nw::internal::dw::FixedUIElementList<1> m_Contents;
    nw::internal::dw::FixedDockPanel<3> m_Container;
    nw::internal::dw::FixedStackPanel<MAX_VOICE_COUNT> m_PeakMeterContainer;

    PeakMeter m_VoiceMeters[MAX_VOICE_COUNT];
    FixedLabelVoiceCountPeakMeter m_VoiceCountMeter;
    nw::internal::dw::Separator m_Separator;

#if defined(NW_DEBUG)
public:
    /*override*/ const char* ToString() const
    {
        return "VoicePanel";
    }
#endif
};

} // snd
} // nw
