﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#pragma once

#include <nw/ut.h>
#include <nw/dw/control/dw_UIElement.h>
#include <nw/dw/control/dw_FixedUIElementList.h>
#include <nw/dw/control/dw_FixedListBox.h>
#include <controls/U32ParameterListItem.h>
#include <controls/F32ParameterListItem.h>
#include <controls/SelectableParameterListItem.h>
#include <models/IPreviewSoundSelector.h>

namespace nw {
namespace snd {

class SoundParameterPanel : public nw::internal::dw::UIElement
{
private:
    static const u32 MAX_ITEM_COUNT = 32;

public:
    SoundParameterPanel();

public:
    void Initialize(IPreviewSoundSelector* pPreviewSoundSelector);

protected:
    void AddItem(ModelParameterListItem<PreviewSound>& item);

private:
    void UpdatePreviewSounds();

    void OnSoundHandleSelectionChanged();

private:
    nw::internal::dw::FixedUIElementList<1> m_Contents;
    nw::internal::dw::FixedListBox<MAX_ITEM_COUNT> m_Container;

    ModelParameterListItem<PreviewSound>* m_pListItems[MAX_ITEM_COUNT];
    F32ParameterListItem<PreviewSound> m_VolumeControl;
    F32ParameterListItem<PreviewSound> m_PitchControl;
    U32ParameterListItem<PreviewSound> m_StartOffsetControl;
    F32ParameterListItem<PreviewSound> m_PanControl;
    F32ParameterListItem<PreviewSound> m_SurroundPanControl;

    IPreviewSoundSelector* m_pPreviewSoundSelector;
    IPreviewSoundSelector::SelectionChangedEventHandler m_SoundHandleSelectionChangedObserver;

#if defined(NW_DEBUG)
public:
    /*override*/ const char* ToString() const
    {
        return "SoundParameterPanel";
    }
#endif
};

} // snd
} // nw
