﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#include <panels/PanelFrame.h>

#include <nw/dw/system/dw_NwTypeUtility.h>

namespace nw {
namespace snd {

template<class TContent>
PanelFrame<TContent>::PanelFrame()
{
    m_Contents.AddItem(&m_Container);
    SetContents(m_Contents);

    m_Container.SetMeasurement(nw::internal::dw::MEASUREMENT_MANUAL);

    m_TitleBarContainer.GetContents().AddItem(&m_Lamp);
    m_TitleBarContainer.GetContents().AddItem(&m_Label);

    m_Container.GetContents().AddItem(&m_TitleBarContainer);
    m_Container.GetContents().AddItem(&m_Content);

    m_ActiveBackgroundColor   = nw::internal::dw::NwTypeUtility::SRGBToLinear(nw::ut::Color4f(0.13f, 0.16f, 0.20f, 0.94f));
    m_ActiveFrameColor        = nw::internal::dw::NwTypeUtility::SRGBToLinear(nw::ut::Color4f(0.35f, 0.42f, 0.52f, 1.f));
    m_InactiveFrameColor      = nw::internal::dw::NwTypeUtility::SRGBToLinear(nw::ut::Color4f(0.22f, 0.24f, 0.28f, 1.f));
    m_ActiveTitleColor        = nw::internal::dw::NwTypeUtility::SRGBToLinear(nw::ut::Color4f::X_WHITE_SMOKE());
    m_InactiveTitleColor      = nw::internal::dw::NwTypeUtility::SRGBToLinear(nw::ut::Color4f(0.7f,  0.7f,  0.7f,  1.f));
    m_ActiveTitleBarBackgroundColor0  = nw::internal::dw::NwTypeUtility::SRGBToLinear(nw::ut::Color4f(0.35f, 0.42f, 0.52f, 0.97f));
    m_ActiveTitleBarBackgroundColor1  = nw::internal::dw::NwTypeUtility::SRGBToLinear(nw::ut::Color4f(0.22f, 0.25f, 0.35f, 0.97f));
    m_InactiveTitleBarBackgroundColor = nw::internal::dw::NwTypeUtility::SRGBToLinear(nw::ut::Color4f(0.22f, 0.24f, 0.28f, 0.97f));

    // PanelFrame Styles
    SetPadding(nw::internal::dw::Thickness(0.f));
    SetIsBordered(true);
    SetBackgroundColor(m_ActiveBackgroundColor);
    SetBorderColor(m_InactiveFrameColor);

    // DockPanel Styles
    m_Container.SetMargin(nw::internal::dw::Thickness(0.f));
    m_Container.SetPadding(nw::internal::dw::Thickness(0.f));

    // TitleBar DockPanel Styles
    m_TitleBarContainer.SetDock(nw::internal::dw::DOCK_TOP);
    m_TitleBarContainer.SetMargin(nw::internal::dw::Thickness(0.f));
    m_TitleBarContainer.SetPadding(nw::internal::dw::Thickness(0.f));
    m_TitleBarContainer.SetBackgroundColor(m_InactiveTitleBarBackgroundColor);

    // Lamp Styles
    m_Lamp.SetDock(nw::internal::dw::DOCK_RIGHT);
    m_Lamp.SetMargin(nw::internal::dw::Thickness(4.f, 2.f));
    m_Lamp.SetPadding(nw::internal::dw::Thickness(0.f));

    // Label Styles
    m_Label.SetMargin(nw::internal::dw::Thickness(0.f));
    m_Label.SetPadding(nw::internal::dw::Thickness(4.f, 1.f));
    m_Label.SetVerticalAlignment(nw::internal::dw::VERTICAL_CENTER);
    m_Label.SetTextColor(m_InactiveTitleColor);
}

template<class TContent>
const char* PanelFrame<TContent>::GetLabel() const
{
    return m_Label.GetText();
}

template<class TContent>
void PanelFrame<TContent>::SetLabel(const char* value)
{
    m_Label.SetText(value);
}

template<class TContent>
TContent& PanelFrame<TContent>::GetContent()
{
    return m_Content;
}

template<class TContent>
nw::internal::dw::UIElementRenderArgs& PanelFrame<TContent>::OnPrepareRender(const nw::internal::dw::UIElementTreeContext& context)
{
    nw::internal::dw::UIElementRenderArgs& result = Base::OnPrepareRender(context);

    if(GetIsContainsFocus())
    {
        result.SetBorderColor(m_ActiveFrameColor);
        m_TitleBarContainer.SetBackgroundColor(
            m_ActiveTitleBarBackgroundColor0,
            m_ActiveTitleBarBackgroundColor1);
        m_Label.SetTextColor(m_ActiveTitleColor);
    }
    else
    {
        result.SetBorderColor(m_InactiveFrameColor);
        m_TitleBarContainer.SetBackgroundColor(m_InactiveTitleBarBackgroundColor);
        m_Label.SetTextColor(m_InactiveTitleColor);
    }

    return result;
}

#if defined(NW_DEBUG)

template<class TContent>
const char* PanelFrame<TContent>::ToString() const
{
    nw::internal::dw::UIElementList& contents = GetContents();

    if(contents.GetCount() == 0)
    {
        return "PanelFrame<>";
    }

    ut::snprintf(const_cast<char*>(m_DebugText), sizeof(m_DebugText), sizeof(m_DebugText) - 1, "PanelFrame<%s>", contents[0]->ToString());
    return m_DebugText;
}

#endif

} // snd
} // nw
