﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#pragma once

#include <nw/snd/fnd/binary/sndfnd_PrimitiveTypes.h>

namespace nw {
namespace snd {

//-----------------------------------------------------------------------
/* シーケンス変数の種類 */
enum ToolSoundSequenceVariableType {
    /* グローバル変数 */
    SequenceVariableType_Global  =   1,
    /* ローカル変数 */
    SequenceVariableType_Local   =   2,
    /* トラック変数 */
    SequenceVariableType_Track   =   3,
    /* enumを4Byte型にするための定義 */
    ToolSoundSequenceVariableType_4BYTE_ENUM =   0xFFFFFFFF
};

//-----------------------------------------------------------------------
/* シーケンス変数コンテナヘッダ */
typedef struct {
    /*  4B: シーケンス変数の種類 */
    nw::snd::internal::fnd::BinU32                  variableType;
    /*  4B: プレビューサウンドのインデックス */
    nw::snd::internal::fnd::BinU32                  previewSoundIndex;
    /*  4B: トラック番号 */
    nw::snd::internal::fnd::BinU32                  trackNo;
} ToolSoundSequenceVariableContainerHeader;

//-----------------------------------------------------------------------
/* シーケンス変数コンテナ */
typedef struct {
    /* 12B: コンテナヘッダ */
    ToolSoundSequenceVariableContainerHeader header;
    /* 64B: 変数の値（ShortMax+1 の場合、無効値） */
    nw::snd::internal::fnd::BinS32                          variables[16];
} ToolSoundSequenceVariableContainer;

class SequenceVariableTraits
{
public:
    // 定数
    static const u32 TrackCount    = 16;            // トラック数
    static const u32 VariableCount = 16;            // シーケンス変数の数
    static const s32 InvalidValue  = SHRT_MAX + 1;  // シーケンス変数の無効値
    static const s32 MaxValue      = SHRT_MAX;      // 変数値の最大値
    static const s32 MinValue      = SHRT_MIN;      // 変数値の最小値

public:
    // 値の評価
    static bool ValidateTrackNo(u32 nTrackNo);
    static bool ValidateValue(s32 lValue);
};


class SequenceVariable
{
public:
    SequenceVariable(void);
    ~SequenceVariable(void);

    // 値の操作
    s32 GetValue();
    void SetValue(s32 value);

private:
    // パラメータ
    s32 m_lValue;        // 変数の値
};


class SequenceVariableContainer
{
public:
    SequenceVariableContainer();

    // シーケンス変数の操作
    bool   Parse(const ToolSoundSequenceVariableContainer* pContainer);
    void   InvalidateAll();
    u32    GetCount();

    // パラメータの操作
    ToolSoundSequenceVariableType   GetType();
    u32                             GetPreviewPlayerIndex();
    u32                             GetTrackNo();

    // オペレータ
    SequenceVariable operator [](s32 index);

private:
    // パラメータ
    ToolSoundSequenceVariableType       m_nType;
    nw::snd::internal::fnd::BinU32      m_nPreviewSoundIndex;
    nw::snd::internal::fnd::BinU32      m_nTrackNo;

    // パラメータ / シーケンス変数
    SequenceVariable m_variables[ SequenceVariableTraits::VariableCount ];    // コンテナ
};


} // namespace snd
} // namespace nw
