﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#pragma once

#include <nw/snd.h>
#include <nw/sndedit.h>
#include <nw/sndctrl.h>
#include <models/PreviewSound.h>
#include <models/PreviewBank.h>
#ifndef NW_ENABLE_SNDCTRL
#include <models/SequenceVariable.h>
#endif

namespace nw {
namespace snd {

namespace ctrl
{
class SoundObjectController;
}

typedef void(*SoundArchiveOpenedCallback)();

//---------------------------------------------------------------------------
//! @brief PreviewSoundArchive
//---------------------------------------------------------------------------
class PreviewSoundArchive
{
public:
    static const s32 PREVIEW_SOUND_COUNT = 4;
    static const s32 PREVIEW_BANK_COUNT  = nw::snd::SoundArchive::SEQ_BANK_MAX;

public:
    PreviewSoundArchive();

public:
    void Initialize(
#if defined(NW_PLATFORM_CAFE)
        FSClient* client,
#endif
        const char* pSoundArchiveFilePath,
        u32 heapSize
#if defined(NW_ENABLE_SNDCTRL)
        , ctrl::SoundObjectController* soundObjectController
#endif
        );
    void Finalize();

    void Update();

    s32 GetPreviewSoundCount();
    PreviewSound& GetPreviewSound(s32 index);

    s32 GetPreviewBankCount();
    PreviewBank& GetPreviewBank(s32 index);

#ifndef NW_ENABLE_SNDCTRL
    // シーケンス変数の操作
    SequenceVariableContainer& GetGlobalVariables();
#endif

    void Open(const char* pSoundArchiveFilePath);
    void Close();
    bool IsOpened() const { return m_IsOpened; }
    bool IsExistSeqSound() const { return m_IsExistSeqSound; }

    nw::snd::SoundArchive& GetSoundArchive() { return m_Archive; }
    nw::snd::SoundArchivePlayer& GetSoundArchivePlayer() { return m_ArchivePlayer; }
    nw::snd::SoundHeap& GetSoundHeap() { return m_Heap; }

    const nw::snd::SoundArchive& GetSoundArchive() const { return m_Archive; }
    const nw::snd::SoundArchivePlayer& GetSoundArchivePlayer() const { return m_ArchivePlayer; }
    const nw::snd::SoundDataManager& GetSoundDataManager() const { return m_DataManager; }

    void RegisterSoundArchiveOpenedCallback(SoundArchiveOpenedCallback callback) { m_SoundArchiveOpenedCallback = callback; }
#if defined(NW_ENABLE_SNDEDIT)
    void RegisterSoundArchiveEditor(nw::snd::edit::SoundArchiveEditor* soundArchiveEdotor) { m_pSoundArchiveEditor = soundArchiveEdotor; }
    bool IsEditedItem(nw::snd::SoundArchive::ItemId id) const;
#endif

#if defined(NW_ENABLE_SNDCTRL)
    nw::snd::ctrl::SoundObjectController* GetSoundObjectController() { return m_SoundObjectController; }
#endif

    // AnimSoundに渡すために、publicにしてあります。
    // nw::snd::SoundArchivePlayer& player() { return m_ArchivePlayer; }
    bool LoadData(nw::snd::SoundArchive::ItemId id);

private:
    bool StartSound(PreviewSound& sound, nw::snd::SoundArchive::ItemId id);

    const char* GetItemLabel(nw::snd::SoundArchive::ItemId itemID) const;
    s32 GetSoundCount() const;
    nw::snd::SoundArchive::ItemId GetSoundID(u32 index) const;
    nw::snd::SoundArchive::ItemId GetSoundID(const char* label) const;

    s32 GetBankCount() const;
    nw::snd::SoundArchive::ItemId GetBankID(u32 index) const;
    nw::snd::SoundArchive::ItemId GetBankID(const char* label) const;

private:
    //bool LoadData(nw::snd::SoundArchive::ItemId id);
    bool LoadDataWithEmbeddedGroup(nw::snd::SoundArchive::FileId id);

private:
#if defined(NW_PLATFORM_CAFE)
    FSClient* m_pFsClient;
    void* m_pMemoryForFsSoundArchive;
#endif

#if defined(NW_ENABLE_SNDCTRL)
    ctrl::SoundObjectController* m_SoundObjectController;
#endif

    nw::snd::FsSoundArchive     m_Archive;
    nw::snd::SoundArchivePlayer m_ArchivePlayer;
    nw::snd::SoundDataManager   m_DataManager;
    nw::snd::SoundHeap          m_Heap;

    void* m_pMemoryForInfoBlock;
    void* m_pMemoryForSoundDataManager;
    void* m_pMemoryForSoundArchivePlayer;
    void* m_pMemoryForSoundHeap;
    void* m_pMemoryForStreamBuffer;
    void* m_pMemoryForStreamCacheBuffer;
    void* m_pMemoryForLabelData;
    void* m_pMemoryForAacDec;

    PreviewSound m_PreviewSounds[PREVIEW_SOUND_COUNT];
    PreviewBank  m_PreviewBanks[PREVIEW_BANK_COUNT];
    bool m_IsOpened;
    bool m_IsExistSeqSound;

#ifndef NW_ENABLE_SNDCTRL
    SequenceVariableContainer  m_GlobalVariables;   // 再生開始時にシーケンス変数を設定するためのコンテナ
#endif

#if defined(NW_ENABLE_SNDEDIT)
    nw::snd::edit::SoundArchiveEditor* m_pSoundArchiveEditor;
#endif
    SoundArchiveOpenedCallback m_SoundArchiveOpenedCallback;

    //---------------------------------------------------------------------------

    friend class PreviewSound;
    friend class PreviewBank;
};

} // nw::snd
} // nw
