﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#pragma once

#include <nw/snd.h>
#include <Constants.h>

namespace nw {
namespace snd {

class PreviewSoundArchive;

//---------------------------------------------------------------------------
//! @brief PreviewBank
//---------------------------------------------------------------------------
class PreviewBank
{
public:
    PreviewBank();

    void Initialize(PreviewSoundArchive& previewSoundArchive);
    void Finalize();

    nw::snd::SoundArchive::ItemId GetBankID() const;
    void SetBankID(nw::snd::SoundArchive::ItemId bankID);

    u32 GetBankIndex() const;
    void SetBankIndex(u32 index);
    void SetLabel(const char* label);

    const char* GetLabel() const;

    bool GetIsLoaded() const;
    void SetIsLoaded(bool isLoaded);

    void Update();

    void Next(s32 offset);

private:
    bool ValidateBankID();

private:
    PreviewSoundArchive* m_pPreviewSoundArchive;

    nw::snd::SoundArchive::ItemId m_BankID;

    bool m_IsParameterDirty;
    bool m_IsLoaded;
};

} // nw::snd
} // nw
