﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#pragma once

#include <nw/ut.h>
#include <core/TaskThread.h>

namespace nw {
namespace snd {

class IStreamReader;
class IStreamWriter;

class StreamReadTask : public TaskThread::Task
{
public:
    enum State
    {
        STATE_NOT_READY = 0,
        STATE_READY,
        STATE_RUNNING,
        STATE_CANCELING,
        STATE_CANCELED,
        STATE_DONE,
        STATE_ERROR,
    };

public:
    /* ctor */ StreamReadTask();
    /* dtor */ ~StreamReadTask();

public:
    State GetState() const;
    bool IsFinished() const;

    void Update(IStreamReader& reader, IStreamWriter& writer, void* pBuffer, u32 size);

    /*override*/ void Invoke();

    void Reset();

private:
    State m_State;

    IStreamReader* m_pReader;
    IStreamWriter* m_pWriter;

    void* m_pBuffer;
    u32 m_BufferSize;

    nw::ut::CriticalSection m_StateLock;
};

} // snd
} // nw
