﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#include <controls/ParameterListItem.h>

namespace nw {
namespace snd {

template<class TModel>
ModelParameterListItem<TModel>::ModelParameterListItem() :
m_pModel(NULL),
m_pGetIsCheckedHandler(NULL),
m_pSetIsCheckedHandler(NULL)
{
}

template<class TModel>
void ModelParameterListItem<TModel>::Initialize(
    GetIsCheckedHandler pGetIsCheckedHandler,
    SetIsCheckedHandler pSetIsCheckedHandler)
{
    NW_ASSERTMSG(m_pGetIsCheckedHandler == NULL, "ModelParameterListItem is already initialized.");
    NW_ASSERTMSG(m_pSetIsCheckedHandler == NULL, "ModelParameterListItem is already initialized.");

    m_pGetIsCheckedHandler = pGetIsCheckedHandler;
    m_pSetIsCheckedHandler = pSetIsCheckedHandler;
}

template<class TModel>
TModel* ModelParameterListItem<TModel>::GetModel() const
{
    return m_pModel;
}

template<class TModel>
void ModelParameterListItem<TModel>::SetModel(TModel* value)
{
    m_pModel = value;
}

template<class TModel>
bool ModelParameterListItem<TModel>::GetIsChecked() const
{
    if(!IsCheckable())
    {
        return false;
    }

    NW_NULL_ASSERT(m_pModel);
    return m_pGetIsCheckedHandler(m_pModel);
}

template<class TModel>
void ModelParameterListItem<TModel>::SetIsChecked(bool value)
{
    if(!IsCheckable())
    {
        return;
    }

    NW_NULL_ASSERT(m_pModel);
    m_pSetIsCheckedHandler(m_pModel, value);
}

template<class TModel>
bool ModelParameterListItem<TModel>::IsAvailable() const
{
    return m_pModel != NULL;
}

template<class TModel>
bool ModelParameterListItem<TModel>::IsCheckable() const
{
    return m_pGetIsCheckedHandler != NULL && m_pSetIsCheckedHandler != NULL;
}

} // snd
} // nw
