﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#pragma once

#include <nw/dw/system/dw_Types.h>
#include <nw/dw/control/dw_UIElement.h>
#include <nw/dw/control/dw_FixedDockPanel.h>
#include <nw/dw/control/dw_FixedLabel.h>
#include <controls/PeakMeter.h>

namespace nw {
namespace snd {

template<int TTextLength>
class FixedLabelPeakMeter : public nw::internal::dw::UIElement
{
private:
    typedef nw::internal::dw::UIElement Base;

    static const char* VALUE_FORMAT;

public:
    FixedLabelPeakMeter();

public:
    nw::internal::dw::Orientation GetOrientation() const;
    void SetOrientation(nw::internal::dw::Orientation value);

    const char* GetLabelText() const;
    void SetLabelText(const char* value);

    float GetValue() const;
    void SetValue(float value);

    float GetPeakValue() const;

    const char* GetValueFormat() const;
    void SetValueFormat(const char* value);

    float GetMinimumValue() const;
    void SetMinimumValue(float value);

    float GetMaximumValue() const;
    void SetMaximumValue(float value);

    float GetPeakHoldChange() const;
    void SetPeakHoldChange(float value);

    float GetPeakHoldFrames() const;
    void SetPeakHoldFrames(float value);

    const nw::ut::Color4f GetBarColor() const;
    void SetBarColor(const nw::ut::Color4f& value);

protected:
    /*override*/ void OnUpdate(const nw::internal::dw::UIElementTreeContext& context);

private:
    nw::internal::dw::FixedUIElementList<1> m_Contents;
    nw::internal::dw::FixedDockPanel<7> m_Container;
    nw::internal::dw::FixedLabel<TTextLength> m_Label;
    nw::internal::dw::FixedLabel<TTextLength> m_Label2;
    nw::internal::dw::FixedLabel<TTextLength> m_ValueLabel;
    nw::internal::dw::FixedLabel<TTextLength> m_Label3;
    nw::internal::dw::FixedLabel<TTextLength> m_PeakValueLabel;
    nw::internal::dw::FixedLabel<TTextLength> m_Label4;
    PeakMeter m_PeakMeter;

    const char* m_pValueFormat;

#if defined(NW_DEBUG)
private:
    static const u32 DEBUG_TEXT_LENGTH = 32;

public:
    /*override*/ const char* ToString() const;

private:
    char m_DebugText[DEBUG_TEXT_LENGTH];
#endif
};

} // snd
} // nw

#include "FixedLabelPeakMeter.hpp"
