﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#pragma once

#include <controls/ParameterListView.h>
#include <controls/F32ParameterListItem.h>
#include <controls/SelectableParameterListItem.h>
#include <models/PreviewEffect.h>

namespace nw {
namespace snd {

class DelayParameterListView : public ParameterListView<PreviewEffectDelay, 16>
{
public:
    DelayParameterListView();

protected:
    //! @brief UI要素サイズ計算の準備を行います。
    /* override */ void OnPrepareMeasure();

private:
    F32ParameterListItem<PreviewEffectDelay> m_MaxDelayTimeControl;
    F32ParameterListItem<PreviewEffectDelay> m_DelayTimeControl;
    F32ParameterListItem<PreviewEffectDelay> m_FeedbackControl;
    F32ParameterListItem<PreviewEffectDelay> m_OutGainControl;
    F32ParameterListItem<PreviewEffectDelay> m_LpfControl;

#if defined(NW_DEBUG)
public:
    /*override*/ const char* ToString() const
    {
        return "DelayParameterListView";
    }
#endif
};

} // snd
} // nw
