﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#pragma once

#include <binary/IffFormat.h>

namespace nw {
namespace snd {

#pragma pack(push, 1)

//---------------------------------------------------------------------------
//! @brief  RIFF チャンク
//---------------------------------------------------------------------------
typedef struct RiffChunk
{
    static const u32 ValidID = 'RIFF';

    /* ctor */ RiffChunk() :
        header(ValidID),
        formatType(0)
    { }

    //---------------------------------------------------------------------------

    bool IsValid()
    {
        return header.id == ValidID;
    }

    //---------------------------------------------------------------------------

    ChunkHeader header;
    u32 formatType;
} RiffChunk;

//---------------------------------------------------------------------------
//! @brief  fmt チャンク
//---------------------------------------------------------------------------
typedef struct FmtChunk
{
    static const u32 ValidID = 'fmt ';
    static const u16 FORMAT_PCM = 1;

    //---------------------------------------------------------------------------

    /* ctor */ FmtChunk() :
        header(ValidID, GetValidBodySize()),
        formatTag(0),
        channels(0),
        samplesPerSec(0),
        avgBytesPerSec(0),
        blockAlign(0),
        bitsPerSample(0)
    { }

    //---------------------------------------------------------------------------

    static u32 GetValidBodySize()
    {
        return sizeof(FmtChunk) - sizeof(ChunkHeader);
    }

    bool IsValid()
    {
        return header.id == ValidID;
    }

    //---------------------------------------------------------------------------

    ChunkHeader header;
    internal::fnd::PcBinU16 formatTag;
    internal::fnd::PcBinU16 channels;
    internal::fnd::PcBinU32 samplesPerSec;
    internal::fnd::PcBinU32 avgBytesPerSec;
    internal::fnd::PcBinU16 blockAlign;
    internal::fnd::PcBinU16 bitsPerSample;
} FmtChunk;

//---------------------------------------------------------------------------
//! @brief  data チャンク
//---------------------------------------------------------------------------
typedef struct DataChunk
{
    static const u32 ValidID = 'data';

    /* ctor */ DataChunk() : header(ValidID) { }

    //---------------------------------------------------------------------------

    bool IsValid()
    {
        return header.id == ValidID;
    }

    ChunkHeader header;
} DataChunk;

//---------------------------------------------------------------------------
//! @brief  WAV バイナリヘッダ
//---------------------------------------------------------------------------
typedef struct WaveBinaryHeader
{
    WaveBinaryHeader()
    {
        riffChunk.formatType = 'WAVE';
    }

    //---------------------------------------------------------------------------

    RiffChunk riffChunk;
    FmtChunk fmtChunk;
    DataChunk dataChunk;
} WaveBinaryHeader;

#pragma pack(pop)

} // snd
} // nw
