﻿// --------------------------------------------------------------------------------
// <copyright>
// Copyright (C)Nintendo. All rights reserved.
//
// These coded instructions, statements, and computer programs contain proprietary
// information of Nintendo and/or its licensed developers and are protected by
// national and international copyright laws. They may not be disclosed to third
// parties or copied or duplicated in any form, in whole or in part, without the
// prior written consent of Nintendo.
//
// The content herein is highly confidential and should be handled accordingly.
// </copyright>
// --------------------------------------------------------------------------------

namespace NintendoWare.SoundMaker.Preview
{
    using System;
    using NintendoWare.SoundFoundation.FileFormats.Wave;
    using NintendoWare.SoundMaker.FileFormats;
    using Runtime = NintendoWare.SoundRuntime;

    public static class WaveFileInfoEx
    {
        private const int ByteBits = 8;             // １バイトあたりのビット数
        private const int MaxChannelCount = 2;

        public static Runtime.WaveInfo ToWaveInfo(
            this WaveFileInfo value,
            int channelIndexStart,
            int channelCount)
        {
            if (channelCount > MaxChannelCount)
            {
                throw new ArgumentException("channelCount");
            }

            WaveFile waveFile = value.WaveFile;

            bool loop = (value.IsLoop == true &&
                         value.LoopStartFrame != value.LoopEndFrame);
            Runtime.WaveInfo waveData = new Runtime.WaveInfo();
            waveData.format = Runtime.SampleFormat.SAMPLE_FORMAT_PCM_S16;
            waveData.loopFlag = loop;
            waveData.numChannels = waveFile.ChannelCount;
            waveData.sampleRate = waveFile.SampleRate;
            waveData.loopStart = (uint)(loop ? value.LoopStartFrame : 0);
            waveData.loopEnd = (uint)(loop ? value.LoopEndFrame : waveFile.FrameCount);
            waveData.originalLoopStartFrame = (uint)(loop ? value.LoopStartFrame : 0);

            // HACK : 本来はファイルヘッダを除いたファイルサイズを格納すべきところらしいが、使われてなさそうなので、良しとする
            //        info->dataSize = m_pHeader->header.fileSize - sizeof(nn::atk::detail::Util::SoundFileHeader);
            waveData.dataSize = (uint)(waveFile.FrameCount * waveFile.SampleBit / ByteBits);

            waveData.channelParam = new Runtime.ChannelParam[MaxChannelCount];
            for (int chNo = 0; chNo < channelCount; chNo++)
            {
                waveData.channelParam[chNo].dataAddr = (IntPtr)value.GetWaveDataAddr(channelIndexStart + chNo);
                waveData.channelParam[chNo].dataSize = (int)waveData.dataSize;
            }

            return waveData;
        }

    }
}
