﻿// --------------------------------------------------------------------------------
// <copyright>
// Copyright (C)Nintendo. All rights reserved.
//
// These coded instructions, statements, and computer programs contain proprietary
// information of Nintendo and/or its licensed developers and are protected by
// national and international copyright laws. They may not be disclosed to third
// parties or copied or duplicated in any form, in whole or in part, without the
// prior written consent of Nintendo.
//
// The content herein is highly confidential and should be handled accordingly.
// </copyright>
// --------------------------------------------------------------------------------

namespace NintendoWare.SoundMaker.Preview
{
    using System;
    using System.Runtime.InteropServices;
    using NintendoWare.ToolDevelopmentKit;
    using Runtime = NintendoWare.SoundRuntime;

    /// <summary>
    /// SeqFileReaderCafe の拡張メソッドを定義します。
    /// </summary>
    internal static class SeqFileReaderCafeExtension
    {
        private const Byte Command_MmlAllockTrack = 0xfe;

        /// <summary>
        /// トラックアロケートフラグを取得します。
        /// </summary>
        /// <param name="reader">SeqFileReaderCafe を指定します。</param>
        /// <param name="commandOffset">
        /// コマンド開始位置（シーケンスデータ先頭からのオフセット）を指定します。
        /// </param>
        /// <returns>トラックアロケートフラグを返します。</returns>
        public static uint GetAllocateTrackFlags(this Runtime.SeqFileReaderCafe reader, long commandOffset)
        {
            Ensure.Argument.NotNull(reader);
            Ensure.Argument.True(commandOffset >= 0);

            long baseAddress = reader.GetBaseAddress().ToInt32();

            Byte command0 = Marshal.ReadByte((IntPtr)(baseAddress + commandOffset));
            Byte command1 = Marshal.ReadByte((IntPtr)(baseAddress + commandOffset + 1));
            Byte command2 = Marshal.ReadByte((IntPtr)(baseAddress + commandOffset + 2));

            // 使用するトラックのビットが立ったフラグを返します。
            // AllocTrack コマンドでない場合は、0番トラックのみとして返します。
            // AllocTrack コマンドの場合は、0番トラック + ビット演算
            // （2バイトにわかれたフラグを連結した）結果を返します。
            if (Command_MmlAllockTrack != command0) { return 1; }
            return (uint)(1 | command2 << 8 | command1);
        }
    }
}
