<?xml version="1.0" ?>
<xsl:stylesheet
  version="1.0"
  xmlns:xsl="http://www.w3.org/1999/XSL/Transform"
  xmlns:nw="NintendoWare.SoundFoundation.FileFormats.NintendoWareBinary">

  <xsl:output method="html" indent="yes" />

  <!--
  =============================================================================
  メイン
  =============================================================================
  -->
  <xsl:template match="/">
    <html>
      <head>
        <title>
          <xsl:value-of select="nw:SoundArchiveBinary/@Name" />
          <xsl:text disable-output-escaping="yes">&amp;nbsp;</xsl:text>
          SoundArchive BinaryMap
        </title>
        <style type="text/css">
          <xsl:call-template name="CommonStyle" />
        </style>
      </head>
      <body>
        <h1>
          <xsl:value-of select="nw:SoundArchiveBinary/@Name" />
          <xsl:text disable-output-escaping="yes">&amp;nbsp;</xsl:text>
          SoundArchive BinaryMap
        </h1>
        <xsl:apply-templates select="nw:SoundArchiveBinary/nw:Groups"/>
        <xsl:apply-templates select="nw:SoundArchiveBinary/nw:Files"/>
        <xsl:apply-templates select="nw:SoundArchiveBinary/nw:ElementMap"/>
      </body>
    </html>
  </xsl:template>

  <!--
  =============================================================================
  グループテーブル
  =============================================================================
  -->
  <xsl:template match="nw:Groups">
    <h3>Group List</h3>
    <div>
      <table width="100%">
        <thead>
          <tr>
            <th>ID</th>
            <th>Name</th>
            <th>OutputType</th>
            <th>Size</th>
            <th>TotalSize</th>
          </tr>
        </thead>
        <tbody>
          <xsl:apply-templates select="nw:Group" />
        </tbody>
      </table>
    </div>
  </xsl:template>

  <xsl:template match="nw:Group">
    <tr>
      <td>
        <xsl:value-of select="@ID" />
      </td>
      <td>
        <xsl:value-of select="@Name" />
      </td>
      <td>
        <xsl:value-of select="@OutputType" />
      </td>
      <td>
        <xsl:value-of select="@Size" />
      </td>
      <td>
        <xsl:value-of select="@TotalSize" />
      </td>
    </tr>
    <xsl:apply-templates select="nw:Items/nw:GroupItem" />
  </xsl:template>

  <xsl:template match="nw:GroupItem">
    <xsl:variable name="fileID" select="@FileID" />
    <tr>
      <td></td>
      <td>
        File:<xsl:value-of select="$fileID" />
      </td>
      <td></td>
      <td>
        <xsl:value-of select="/nw:SoundArchiveBinary/nw:Files/*[@ID=$fileID]/@Size" />
      </td>
      <td></td>
    </tr>
  </xsl:template>

  <!--
  =============================================================================
  ファイルテーブル
  =============================================================================
  -->
  <xsl:template match="nw:Files">
    <h3>File List</h3>
    <div>
      <table width="100%">
        <thead>
          <tr>
            <th>ID</th>
            <th>Name</th>
            <th>IsExternal</th>
            <th>Size</th>
          </tr>
        </thead>
        <tbody>
          <xsl:apply-templates select="nw:InternalFile|nw:ExternalFile" />
        </tbody>
      </table>
    </div>
  </xsl:template>

  <xsl:template match="nw:Files/nw:InternalFile">
    <tr>
      <td>
        <xsl:value-of select="@ID" />
      </td>
      <td>
        <xsl:value-of select="@Name" />
      </td>
      <td>
        false
      </td>
      <td>
        <xsl:value-of select="@Size" />
      </td>
    </tr>
  </xsl:template>

  <xsl:template match="nw:Files/nw:ExternalFile">
    <tr>
      <td>
        <xsl:value-of select="@ID" />
      </td>
      <td>
        <xsl:value-of select="@Name" />
      </td>
      <td>
        true
      </td>
      <td>
        <xsl:value-of select="@Size" />
      </td>
    </tr>
  </xsl:template>

  <!--
  =============================================================================
  バイナリマップ
  =============================================================================
  -->
  <xsl:template match="nw:ElementMap">
    <h3>Binary Map</h3>
    <div>
      <table width="100%">
        <thead>
          <tr>
            <th>Address</th>
            <th>Size</th>
            <th>Name</th>
            <th>FileID</th>
          </tr>
        </thead>
        <tbody>
          <xsl:apply-templates select="nw:Root" />
        </tbody>
      </table>
    </div>
  </xsl:template>

  <xsl:template match="nw:ElementMap/nw:Root | nw:ElementMapItem | nw:FileElementMapItem">
    <xsl:param name="level">0</xsl:param>
    <tr>
      <td>
        <xsl:value-of select="@Address" />
      </td>
      <td>
        <xsl:value-of select="@Size" />
      </td>
      <td>
        <xsl:call-template name="Indent">
          <xsl:with-param name="level">
            <xsl:value-of select="$level" />
          </xsl:with-param>
        </xsl:call-template>
        <xsl:text>- </xsl:text>
        <xsl:value-of select="@Name" />
      </td>
      <td>
        <xsl:value-of select="@FileID" />
      </td>
    </tr>
    <xsl:apply-templates select="nw:Items/nw:ElementMapItem | nw:Items/nw:FileElementMapItem">
      <xsl:with-param name="level">
        <xsl:value-of select="$level + 1" />
      </xsl:with-param>
    </xsl:apply-templates>
  </xsl:template>

  <!--
  =============================================================================
  共通スタイル
  =============================================================================
  -->
  <xsl:template name="CommonStyle">
    <xsl:comment>
      body {
      margin: 12px;
      }

      h1 {
      font-size: 16pt;
      text-indent: 1em;
      border-left: solid #7886B6 20px;
      border-bottom: solid #7886B6 2px;
      }

      h2 {
      font-size: 14pt;
      text-indent: 1em;
      border-left: solid #7886B6 10px;
      border-bottom: solid #7886B6 1px;
      }

      h3 {
      font-size: 14pt;
      }

      div {
      margin-bottom: 20px;
      }

      div.tableset {
      margin: 0em 1em 1em 1em;
      }

      table {
      border-collapse: collapse;
      border-top: #a1a5a9 1px solid;
      border-bottom: #a1a5a9 1px solid;
      }

      th {
      padding-left: 0.5em;
      padding-right: 0.5em;
      text-align: left;
      background: #efefef;
      }

      th.SortKey {
      background: #e4e4ff;
      }

      tr.Disabled {
      color: #a7a6aa;
      }

      tr.ColorType1 {
      background-color: #ffaaaa;
      }

      tr.ColorType2 {
      background-color: #ffe080;
      }

      tr.ColorType3 {
      background-color: #ffffaa;
      }

      tr.ColorType4 {
      background-color: #d0ffc0;
      }

      tr.ColorType5 {
      background-color: #c0ecff;
      }

      tr.ColorType6 {
      background-color: #b4ddff;
      }

      tr.ColorType7 {
      background-color: #d8d8ff;
      }

      tr.ColorType8 {
      background-color: #ffddff;
      }

      td {
      padding-left: 0.5em;
      padding-right: 0.5em;
      border-top: #a1a5a9 1px dotted;
      }

      dl {
      font-size: 9pt;
      }
    </xsl:comment>
  </xsl:template>

  <!--
  =============================================================================
  ユーティリティ
  =============================================================================
  -->

  <!-- $level だけインデントを挿入します。 -->
  <xsl:template name="Indent">
    <xsl:param name="level">0</xsl:param>
    <xsl:text disable-output-escaping="yes">&amp;nbsp;&amp;nbsp;</xsl:text>

    <!-- 再起呼び出しによるループ -->
    <xsl:if test="$level &gt; 0">
      <xsl:call-template name="Indent">
        <xsl:with-param name="level" select="$level - 1"/>
      </xsl:call-template>
    </xsl:if>
  </xsl:template>

</xsl:stylesheet>
