﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#include "StdAfx.h"
#include "MidiPlayer.h"
#include "MidiManager.h"

MidiPlayer::MidiPlayer()
: mStartFlag( false )
{
}

bool MidiPlayer::Start( nn::atk::detail::driver::NoteOnCallback* noteOnCallback )
{
    nn::atk::detail::driver::SoundThread::GetInstance().Lock();

    mSequenceTrackAllocator.Create( mSequenceTrack, sizeof( mSequenceTrack ) );
    auto* pReceiver = NintendoWare::SoundRuntime::ChannelCafe::GetOutputReceiver();
    mSequenceSoundPlayer.Initialize( pReceiver );
    pReceiver->AddReferenceCount( 1 );

    nn::atk::detail::driver::SequenceSoundPlayer::SetupArg arg;
    arg.trackAllocator = &mSequenceTrackAllocator;
    arg.allocTracks = 0xffff;
    arg.callback = noteOnCallback;
    mSequenceSoundPlayer.Setup(arg);

    nn::atk::detail::SequenceSound::Resource res;
    res.Initialize();
    mSequenceSoundPlayer.Prepare(res.banks, res.warcs, res.warcIsIndividuals);

    mSequenceSoundPlayer.Start();

    mStartFlag = true;

    nn::atk::detail::driver::SoundThread::GetInstance().Unlock();
    return true;
}

void MidiPlayer::Stop()
{
    nn::atk::detail::driver::SoundThread::GetInstance().Lock();

    if ( mStartFlag ) {
        mSequenceSoundPlayer.Stop();
        mSequenceSoundPlayer.Finalize();
        mSequenceTrackAllocator.Destroy();

        mStartFlag = false;
    }
    nn::atk::detail::driver::SoundThread::GetInstance().Unlock();
}

void MidiPlayer::Reset()
{
    nn::atk::detail::driver::SoundThread::GetInstance().Lock();

    mSequenceSoundPlayer.Reset();
    nn::atk::detail::driver::SoundThread::GetInstance().Unlock();
}

void MidiPlayer::SendMidiMessage( BYTE status, BYTE data1, BYTE data2 )
{
    nn::atk::detail::driver::SoundThread::GetInstance().Lock();

    mSequenceSoundPlayer.SendMessage( status, data1, data2 );

    nn::atk::detail::driver::SoundThread::GetInstance().Unlock();
}

void MidiPlayer::ProgramChange( int channelIndex, int prgNo )
{
    nn::atk::detail::driver::SoundThread::GetInstance().Lock();

    mSequenceSoundPlayer.SetProgramNumber( channelIndex, prgNo );

    nn::atk::detail::driver::SoundThread::GetInstance().Unlock();
}


