﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

// これは メイン DLL ファイルです。

#include "stdafx.h"

#include "Audio.h"
#include <nn/audio/audio_AudioOutApi.h>
#include <nn/audio/audio_Device.h>

namespace Nintendo { namespace AudioTool {

void Audio::InitializeAudioDevice( String^ deviceName )
{
    if( String::IsNullOrEmpty( deviceName ) )
    {
        return;
    }

    static const int MAX_AUDIO_OUT_COUNT = 32;
    nn::audio::AudioOutInfo outInfos[MAX_AUDIO_OUT_COUNT];

    array<Byte>^ utf8DeviceNameBytes = System::Text::Encoding::UTF8->GetBytes(deviceName);
    pin_ptr<Byte> pinnedDeviceNameBytes = &utf8DeviceNameBytes[0];
    auto deviceNamePtr = reinterpret_cast<const char*>(pinnedDeviceNameBytes);

    int index = 0;
    auto count = nn::audio::ListAudioOuts( outInfos, MAX_AUDIO_OUT_COUNT );

    for (; index < count; index++ )
    {
        if(strncmp(deviceNamePtr, outInfos[index].name, nn::audio::AudioOutCountMax) == 0)
        {
            break;
        }
    }

    if( index < count )
    {
        auto result = nn::audio::SetAudioDeviceMapping("MainAudioOut", deviceNamePtr);

        if(result.IsFailure())
        {
            throw gcnew System::InvalidOperationException(
                String::Format("Failed in nn::audio::SetAudioDeviceMapping() : result = {0}", result.GetInnerValueForDebug()));
        }
    }
}

array<String^>^ Audio::EnumerateAudioDevices()
{
    System::Collections::Generic::List<String^>^ result = gcnew System::Collections::Generic::List<String^>();

    static const int MAX_AUDIO_OUT_COUNT = 32;
    nn::audio::AudioOutInfo outInfos[MAX_AUDIO_OUT_COUNT];

    int index = 0;
    auto count = nn::audio::ListAudioOuts( outInfos, MAX_AUDIO_OUT_COUNT );

    for (; index < count; index++ )
    {
        auto nameLength = strlen(outInfos[index].name);
        auto nameBytes = gcnew array<Byte>(nameLength);

        Marshal::Copy( (IntPtr)outInfos[index].name, nameBytes, 0, nameLength );

        result->Add(System::Text::Encoding::UTF8->GetString(nameBytes));
    }

    return result->ToArray();
}

}}
