﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#pragma once

class MidiPlayer
{
  public:
    MidiPlayer::MidiPlayer();

    bool Start( nn::atk::detail::driver::NoteOnCallback* noteOnCallback );
    void Stop();

    void Reset();

    void SendMidiMessage( BYTE status, BYTE data1, BYTE data2 );
    void ProgramChange( int channelIndex, int prgNo );

    const nn::atk::detail::driver::MidiSequencePlayer& GetSequenceSoundPlayer() const { return  mSequenceSoundPlayer; }

  private:
    nn::atk::detail::driver::MidiSequencePlayer mSequenceSoundPlayer;
    nn::atk::detail::driver::MidiSequenceTrack mSequenceTrack[ 16 ];
    nn::atk::detail::driver::MidiSequenceTrackAllocator mSequenceTrackAllocator;
    bool mStartFlag;
};
