﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#include "parser.h"
#include <nw/snd/snd_MmlCommand.h>
#include <sndlib/smart_ptr.h>

#define VMIDI_MAX 0xfffffff
#define VAR_NUM_MAX 47

using namespace sndlib;
using namespace nw::snd::internal;
using namespace nw::snd::internal::driver;

void DefineCommand( Parser& parser )
{
    typedef Command::ArgNumber<Command::u8> u8;
    typedef Command::ArgNumber<Command::s8> s8;
    typedef Command::ArgNumber<Command::u16> u16;
    typedef Command::ArgNumber<Command::s16> s16;
    typedef Command::ArgNumber<Command::u32> u32;
    typedef Command::ArgNumber<Command::u24> u24;
    typedef Command::ArgNumber<Command::vmidi> vmidi;

    //-----------------------------------------------------------------------------
    // note command
    parser.mNoteCommand
        .AddArg( SmartPtr<u8>( new u8( "velocity", 0, 127) ) )
        .AddArg( SmartPtr<vmidi>( new vmidi( "note length", 0, VMIDI_MAX) ) )
        ;

    parser.mNoteRandCommand
        .AddArg( SmartPtr<u8>( new u8( "velocity", 0, 127) ) )
        .AddArg( SmartPtr<s16>( new s16( "note length min", 0, 32767) ) )
        .AddArg( SmartPtr<s16>( new s16( "note length max", 0, 32767) ) )
        ;

    parser.mNoteVarCommand
        .AddArg( SmartPtr<u8>( new u8( "velocity", 0, 127) ) )
        .AddArg( SmartPtr<u8>( new u8( "variable number", 0, VAR_NUM_MAX) ) )
        ;

    //-----------------------------------------------------------------------------
    //
    parser.mCommandTable[ "prg" ]
        .AddCode( MmlCommand::MML_PRG )
        .AddArg( SmartPtr<vmidi>( new vmidi( "program number", 0, 32767) ) )
        ;

    parser.mCommandTable[ "prg_r" ]
        .AddCode( MmlCommand::MML_RANDOM )
        .AddCode( MmlCommand::MML_PRG )
        .AddArg( SmartPtr<s16>( new s16( "program number max", 0, 32767) ) )
        .AddArg( SmartPtr<s16>( new s16( "program number min", 0, 32767) ) )
        ;

    parser.mCommandTable[ "prg_v" ]
        .AddCode( MmlCommand::MML_VARIABLE )
        .AddCode( MmlCommand::MML_PRG )
        .AddArg( SmartPtr<u8>( new u8( "variable number", 0, VAR_NUM_MAX) ) )
        ;


    //-----------------------------------------------------------------------------
    //
    parser.mCommandTable[ "wait" ]
        .AddCode( MmlCommand::MML_WAIT )
        .AddArg( SmartPtr<vmidi>( new vmidi( "wait length", 0, VMIDI_MAX) ) )
        ;
    parser.mCommandTable[ "wait_r" ]
        .AddCode( MmlCommand::MML_RANDOM )
        .AddCode( MmlCommand::MML_WAIT )
        .AddArg( SmartPtr<s16>( new s16( "wait length min", 0, 32767) ) )
        .AddArg( SmartPtr<s16>( new s16( "wait length max", 0, 32767) ) )
        ;
    parser.mCommandTable[ "wait_v" ]
        .AddCode( MmlCommand::MML_VARIABLE )
        .AddCode( MmlCommand::MML_WAIT )
        .AddArg( SmartPtr<u8>( new u8( "variable number", 0, VAR_NUM_MAX) ) )
        ;
    //-----------------------------------------------------------------------------
    //

    parser.mCommandTable[ "pan" ]
        .AddCode( MmlCommand::MML_PAN )
        .AddArg( SmartPtr<u8>( new u8( "pan", 0, 127) ) )
        ;

    parser.mCommandTable[ "pan_r" ]
        .AddCode( MmlCommand::MML_RANDOM )
        .AddCode( MmlCommand::MML_PAN )
        .AddArg( SmartPtr<s16>( new s16( "pan min", 0, 127) ) )
        .AddArg( SmartPtr<s16>( new s16( "pan max", 0, 127) ) )
        ;
    parser.mCommandTable[ "pan_v" ]
        .AddCode( MmlCommand::MML_VARIABLE )
        .AddCode( MmlCommand::MML_PAN )
        .AddArg( SmartPtr<u8>( new u8( "variable number", 0, VAR_NUM_MAX) ) )
        ;

    parser.mCommandTable[ "pan_t" ]
        .AddCode( MmlCommand::MML_TIME )
        .AddCode( MmlCommand::MML_PAN )
        .AddArg( SmartPtr<u8>( new u8( "pan", 0, 127) ) )
        .AddArg( SmartPtr<s16>( new s16( "time", 0, 32767) ) )
        ;

    parser.mCommandTable[ "pan_tr" ]
        .AddCode( MmlCommand::MML_TIME_RANDOM )
        .AddCode( MmlCommand::MML_PAN )
        .AddArg( SmartPtr<u8>( new u8( "pan", 0, 127) ) )
        .AddArg( SmartPtr<s16>( new s16( "time min", 0, 32767) ) )
        .AddArg( SmartPtr<s16>( new s16( "time max", 0, 32767) ) )
        ;

    parser.mCommandTable[ "pan_tv" ]
        .AddCode( MmlCommand::MML_TIME_VARIABLE )
        .AddCode( MmlCommand::MML_PAN )
        .AddArg( SmartPtr<u8>( new u8( "pan", 0, 127) ) )
        .AddArg( SmartPtr<u8>( new u8( "time variable number", 0, VAR_NUM_MAX) ) )
        ;

    parser.mCommandTable[ "pan_r_t" ]
        .AddCode( MmlCommand::MML_TIME )
        .AddCode( MmlCommand::MML_RANDOM )
        .AddCode( MmlCommand::MML_PAN )
        .AddArg( SmartPtr<s16>( new s16( "pan min", 0, 127) ) )
        .AddArg( SmartPtr<s16>( new s16( "pan max", 0, 127) ) )
        .AddArg( SmartPtr<s16>( new s16( "time", 0, 32767) ) )
        ;

    parser.mCommandTable[ "pan_r_tr" ]
        .AddCode( MmlCommand::MML_TIME_RANDOM )
        .AddCode( MmlCommand::MML_RANDOM )
        .AddCode( MmlCommand::MML_PAN )
        .AddArg( SmartPtr<s16>( new s16( "pan min", 0, 127) ) )
        .AddArg( SmartPtr<s16>( new s16( "pan max", 0, 127) ) )
        .AddArg( SmartPtr<s16>( new s16( "time min", 0, 32767) ) )
        .AddArg( SmartPtr<s16>( new s16( "time max", 0, 32767) ) )
        ;

    parser.mCommandTable[ "pan_r_tv" ]
        .AddCode( MmlCommand::MML_TIME_VARIABLE )
        .AddCode( MmlCommand::MML_RANDOM )
        .AddCode( MmlCommand::MML_PAN )
        .AddArg( SmartPtr<s16>( new s16( "pan min", 0, 127) ) )
        .AddArg( SmartPtr<s16>( new s16( "pan max", 0, 127) ) )
        .AddArg( SmartPtr<u8>( new u8( "time variable number", 0, VAR_NUM_MAX) ) )
        ;

    parser.mCommandTable[ "pan_v_t" ]
        .AddCode( MmlCommand::MML_TIME )
        .AddCode( MmlCommand::MML_VARIABLE )
        .AddCode( MmlCommand::MML_PAN )
        .AddArg( SmartPtr<u8>( new u8( "variable number", 0, VAR_NUM_MAX) ) )
        .AddArg( SmartPtr<s16>( new s16( "time", 0, 32767) ) )
        ;

    parser.mCommandTable[ "pan_v_tr" ]
        .AddCode( MmlCommand::MML_TIME_RANDOM )
        .AddCode( MmlCommand::MML_VARIABLE )
        .AddCode( MmlCommand::MML_PAN )
        .AddArg( SmartPtr<u8>( new u8( "variable number", 0, VAR_NUM_MAX) ) )
        .AddArg( SmartPtr<s16>( new s16( "time min", 0, 32767) ) )
        .AddArg( SmartPtr<s16>( new s16( "time max", 0, 32767) ) )
        ;

    parser.mCommandTable[ "pan_v_tv" ]
        .AddCode( MmlCommand::MML_TIME_VARIABLE )
        .AddCode( MmlCommand::MML_VARIABLE )
        .AddCode( MmlCommand::MML_PAN )
        .AddArg( SmartPtr<u8>( new u8( "variable number", 0, VAR_NUM_MAX) ) )
        .AddArg( SmartPtr<u8>( new u8( "time variable number", 0, VAR_NUM_MAX) ) )
        ;

    //-----------------------------------------------------------------------------
    //

    parser.mCommandTable[ "init_pan" ]
        .AddCode( MmlCommand::MML_INIT_PAN )
        .AddArg( SmartPtr<u8>( new u8( "init pan", 0, 127) ) )
        ;

    parser.mCommandTable[ "init_pan_r" ]
        .AddCode( MmlCommand::MML_RANDOM )
        .AddCode( MmlCommand::MML_INIT_PAN )
        .AddArg( SmartPtr<s16>( new s16( "init pan min", 0, 127) ) )
        .AddArg( SmartPtr<s16>( new s16( "init pan max", 0, 127) ) )
        ;
    parser.mCommandTable[ "init_pan_v" ]
        .AddCode( MmlCommand::MML_VARIABLE )
        .AddCode( MmlCommand::MML_INIT_PAN )
        .AddArg( SmartPtr<u8>( new u8( "variable number", 0, VAR_NUM_MAX) ) )
        ;

    //-----------------------------------------------------------------------------
    //

    parser.mCommandTable[ "span" ]
        .AddCode( MmlCommand::MML_SURROUND_PAN )
        .AddArg( SmartPtr<u8>( new u8( "span", 0, 127) ) )
        ;

    parser.mCommandTable[ "span_r" ]
        .AddCode( MmlCommand::MML_RANDOM )
        .AddCode( MmlCommand::MML_SURROUND_PAN )
        .AddArg( SmartPtr<s16>( new s16( "span min", 0, 127) ) )
        .AddArg( SmartPtr<s16>( new s16( "span max", 0, 127) ) )
        ;
    parser.mCommandTable[ "span_v" ]
        .AddCode( MmlCommand::MML_VARIABLE )
        .AddCode( MmlCommand::MML_SURROUND_PAN )
        .AddArg( SmartPtr<u8>( new u8( "variable number", 0, VAR_NUM_MAX) ) )
        ;

    parser.mCommandTable[ "span_t" ]
        .AddCode( MmlCommand::MML_TIME )
        .AddCode( MmlCommand::MML_SURROUND_PAN )
        .AddArg( SmartPtr<u8>( new u8( "span", 0, 127) ) )
        .AddArg( SmartPtr<s16>( new s16( "time", 0, 32767) ) )
        ;

    parser.mCommandTable[ "span_tr" ]
        .AddCode( MmlCommand::MML_TIME_RANDOM )
        .AddCode( MmlCommand::MML_SURROUND_PAN )
        .AddArg( SmartPtr<u8>( new u8( "span", 0, 127) ) )
        .AddArg( SmartPtr<s16>( new s16( "time min", 0, 32767) ) )
        .AddArg( SmartPtr<s16>( new s16( "time max", 0, 32767) ) )
        ;

    parser.mCommandTable[ "span_tv" ]
        .AddCode( MmlCommand::MML_TIME_VARIABLE )
        .AddCode( MmlCommand::MML_SURROUND_PAN )
        .AddArg( SmartPtr<u8>( new u8( "span", 0, 127) ) )
        .AddArg( SmartPtr<u8>( new u8( "time variable number", 0, VAR_NUM_MAX) ) )
        ;

    parser.mCommandTable[ "span_r_t" ]
        .AddCode( MmlCommand::MML_TIME )
        .AddCode( MmlCommand::MML_RANDOM )
        .AddCode( MmlCommand::MML_SURROUND_PAN )
        .AddArg( SmartPtr<s16>( new s16( "span min", 0, 127) ) )
        .AddArg( SmartPtr<s16>( new s16( "span max", 0, 127) ) )
        .AddArg( SmartPtr<s16>( new s16( "time", 0, 32767) ) )
        ;

    parser.mCommandTable[ "span_r_tr" ]
        .AddCode( MmlCommand::MML_TIME_RANDOM )
        .AddCode( MmlCommand::MML_RANDOM )
        .AddCode( MmlCommand::MML_SURROUND_PAN )
        .AddArg( SmartPtr<s16>( new s16( "span min", 0, 127) ) )
        .AddArg( SmartPtr<s16>( new s16( "span max", 0, 127) ) )
        .AddArg( SmartPtr<s16>( new s16( "time min", 0, 32767) ) )
        .AddArg( SmartPtr<s16>( new s16( "time max", 0, 32767) ) )
        ;

    parser.mCommandTable[ "span_r_tv" ]
        .AddCode( MmlCommand::MML_TIME_VARIABLE )
        .AddCode( MmlCommand::MML_RANDOM )
        .AddCode( MmlCommand::MML_SURROUND_PAN )
        .AddArg( SmartPtr<s16>( new s16( "span min", 0, 127) ) )
        .AddArg( SmartPtr<s16>( new s16( "span max", 0, 127) ) )
        .AddArg( SmartPtr<u8>( new u8( "time variable number", 0, VAR_NUM_MAX) ) )
        ;

    parser.mCommandTable[ "span_v_t" ]
        .AddCode( MmlCommand::MML_TIME )
        .AddCode( MmlCommand::MML_VARIABLE )
        .AddCode( MmlCommand::MML_SURROUND_PAN )
        .AddArg( SmartPtr<u8>( new u8( "variable number", 0, VAR_NUM_MAX) ) )
        .AddArg( SmartPtr<s16>( new s16( "time", 0, 32767) ) )
        ;

    parser.mCommandTable[ "span_v_tr" ]
        .AddCode( MmlCommand::MML_TIME_RANDOM )
        .AddCode( MmlCommand::MML_VARIABLE )
        .AddCode( MmlCommand::MML_SURROUND_PAN )
        .AddArg( SmartPtr<u8>( new u8( "variable number", 0, VAR_NUM_MAX) ) )
        .AddArg( SmartPtr<s16>( new s16( "time min", 0, 32767) ) )
        .AddArg( SmartPtr<s16>( new s16( "time max", 0, 32767) ) )
        ;

    parser.mCommandTable[ "span_v_tv" ]
        .AddCode( MmlCommand::MML_TIME_VARIABLE )
        .AddCode( MmlCommand::MML_VARIABLE )
        .AddCode( MmlCommand::MML_SURROUND_PAN )
        .AddArg( SmartPtr<u8>( new u8( "variable number", 0, VAR_NUM_MAX) ) )
        .AddArg( SmartPtr<u8>( new u8( "time variable number", 0, VAR_NUM_MAX) ) )
        ;

    //-----------------------------------------------------------------------------
    //
    parser.mCommandTable[ "mute" ]
        .AddCode( MmlCommand::MML_MUTE )
        .AddArg( SmartPtr<u8>( new u8( "mute", 0, 127) ) )
        ;

    parser.mCommandTable[ "mute_v" ]
        .AddCode( MmlCommand::MML_VARIABLE )
        .AddCode( MmlCommand::MML_MUTE )
        .AddArg( SmartPtr<u8>( new u8( "variable number", 0, VAR_NUM_MAX) ) )
        ;

    //-----------------------------------------------------------------------------
    //
    parser.mCommandTable[ "volume" ]
        .AddCode( MmlCommand::MML_VOLUME )
        .AddArg( SmartPtr<u8>( new u8( "volume", 0, 127) ) )
        ;

    parser.mCommandTable[ "volume_r" ]
        .AddCode( MmlCommand::MML_RANDOM )
        .AddCode( MmlCommand::MML_VOLUME )
        .AddArg( SmartPtr<s16>( new s16( "volume min", 0, 127) ) )
        .AddArg( SmartPtr<s16>( new s16( "volume max", 0, 127) ) )
        ;
    parser.mCommandTable[ "volume_v" ]
        .AddCode( MmlCommand::MML_VARIABLE )
        .AddCode( MmlCommand::MML_VOLUME )
        .AddArg( SmartPtr<u8>( new u8( "variable number", 0, VAR_NUM_MAX) ) )
        ;

    parser.mCommandTable[ "volume_t" ]
        .AddCode( MmlCommand::MML_TIME )
        .AddCode( MmlCommand::MML_VOLUME )
        .AddArg( SmartPtr<u8>( new u8( "volume", 0, 127) ) )
        .AddArg( SmartPtr<s16>( new s16( "time", 0, 32767) ) )
        ;

    parser.mCommandTable[ "volume_tr" ]
        .AddCode( MmlCommand::MML_TIME_RANDOM )
        .AddCode( MmlCommand::MML_VOLUME )
        .AddArg( SmartPtr<u8>( new u8( "volume", 0, 127) ) )
        .AddArg( SmartPtr<s16>( new s16( "time min", 0, 32767) ) )
        .AddArg( SmartPtr<s16>( new s16( "time max", 0, 32767) ) )
        ;

    parser.mCommandTable[ "volume_tv" ]
        .AddCode( MmlCommand::MML_TIME_VARIABLE )
        .AddCode( MmlCommand::MML_VOLUME )
        .AddArg( SmartPtr<u8>( new u8( "volume", 0, 127) ) )
        .AddArg( SmartPtr<u8>( new u8( "time variable number", 0, VAR_NUM_MAX) ) )
        ;

    parser.mCommandTable[ "volume_r_t" ]
        .AddCode( MmlCommand::MML_TIME )
        .AddCode( MmlCommand::MML_RANDOM )
        .AddCode( MmlCommand::MML_VOLUME )
        .AddArg( SmartPtr<s16>( new s16( "volume min", 0, 127) ) )
        .AddArg( SmartPtr<s16>( new s16( "volume max", 0, 127) ) )
        .AddArg( SmartPtr<s16>( new s16( "time", 0, 32767) ) )
        ;

    parser.mCommandTable[ "volume_r_tr" ]
        .AddCode( MmlCommand::MML_TIME_RANDOM )
        .AddCode( MmlCommand::MML_RANDOM )
        .AddCode( MmlCommand::MML_VOLUME )
        .AddArg( SmartPtr<s16>( new s16( "volume min", 0, 127) ) )
        .AddArg( SmartPtr<s16>( new s16( "volume max", 0, 127) ) )
        .AddArg( SmartPtr<s16>( new s16( "time min", 0, 32767) ) )
        .AddArg( SmartPtr<s16>( new s16( "time max", 0, 32767) ) )
        ;

    parser.mCommandTable[ "volume_r_tv" ]
        .AddCode( MmlCommand::MML_TIME_VARIABLE )
        .AddCode( MmlCommand::MML_RANDOM )
        .AddCode( MmlCommand::MML_VOLUME )
        .AddArg( SmartPtr<s16>( new s16( "volume min", 0, 127) ) )
        .AddArg( SmartPtr<s16>( new s16( "volume max", 0, 127) ) )
        .AddArg( SmartPtr<u8>( new u8( "time variable number", 0, VAR_NUM_MAX) ) )
        ;

    parser.mCommandTable[ "volume_v_t" ]
        .AddCode( MmlCommand::MML_TIME )
        .AddCode( MmlCommand::MML_VARIABLE )
        .AddCode( MmlCommand::MML_VOLUME )
        .AddArg( SmartPtr<u8>( new u8( "variable number", 0, VAR_NUM_MAX) ) )
        .AddArg( SmartPtr<s16>( new s16( "time", 0, 32767) ) )
        ;

    parser.mCommandTable[ "volume_v_tr" ]
        .AddCode( MmlCommand::MML_TIME_RANDOM )
        .AddCode( MmlCommand::MML_VARIABLE )
        .AddCode( MmlCommand::MML_VOLUME )
        .AddArg( SmartPtr<u8>( new u8( "variable number", 0, VAR_NUM_MAX) ) )
        .AddArg( SmartPtr<s16>( new s16( "time min", 0, 32767) ) )
        .AddArg( SmartPtr<s16>( new s16( "time max", 0, 32767) ) )
        ;

    parser.mCommandTable[ "volume_v_tv" ]
        .AddCode( MmlCommand::MML_TIME_VARIABLE )
        .AddCode( MmlCommand::MML_VARIABLE )
        .AddCode( MmlCommand::MML_VOLUME )
        .AddArg( SmartPtr<u8>( new u8( "variable number", 0, VAR_NUM_MAX) ) )
        .AddArg( SmartPtr<u8>( new u8( "time variable number", 0, VAR_NUM_MAX) ) )
        ;

    //-----------------------------------------------------------------------------
    //
    parser.mCommandTable[ "volume2" ]
        .AddCode( MmlCommand::MML_VOLUME2 )
        .AddArg( SmartPtr<u8>( new u8( "volume", 0, 127) ) )
        ;

    parser.mCommandTable[ "volume2_r" ]
        .AddCode( MmlCommand::MML_RANDOM )
        .AddCode( MmlCommand::MML_VOLUME2 )
        .AddArg( SmartPtr<s16>( new s16( "volume min", 0, 127) ) )
        .AddArg( SmartPtr<s16>( new s16( "volume max", 0, 127) ) )
        ;
    parser.mCommandTable[ "volume2_v" ]
        .AddCode( MmlCommand::MML_VARIABLE )
        .AddCode( MmlCommand::MML_VOLUME2 )
        .AddArg( SmartPtr<u8>( new u8( "variable number", 0, VAR_NUM_MAX) ) )
        ;

    parser.mCommandTable[ "volume2_t" ]
        .AddCode( MmlCommand::MML_TIME )
        .AddCode( MmlCommand::MML_VOLUME2 )
        .AddArg( SmartPtr<u8>( new u8( "volume", 0, 127) ) )
        .AddArg( SmartPtr<s16>( new s16( "time", 0, 32767) ) )
        ;

    parser.mCommandTable[ "volume2_tr" ]
        .AddCode( MmlCommand::MML_TIME_RANDOM )
        .AddCode( MmlCommand::MML_VOLUME2 )
        .AddArg( SmartPtr<u8>( new u8( "volume", 0, 127) ) )
        .AddArg( SmartPtr<s16>( new s16( "time min", 0, 32767) ) )
        .AddArg( SmartPtr<s16>( new s16( "time max", 0, 32767) ) )
        ;

    parser.mCommandTable[ "volume2_tv" ]
        .AddCode( MmlCommand::MML_TIME_VARIABLE )
        .AddCode( MmlCommand::MML_VOLUME2 )
        .AddArg( SmartPtr<u8>( new u8( "volume", 0, 127) ) )
        .AddArg( SmartPtr<u8>( new u8( "time variable number", 0, VAR_NUM_MAX) ) )
        ;

    parser.mCommandTable[ "volume2_r_t" ]
        .AddCode( MmlCommand::MML_TIME )
        .AddCode( MmlCommand::MML_RANDOM )
        .AddCode( MmlCommand::MML_VOLUME2 )
        .AddArg( SmartPtr<s16>( new s16( "volume min", 0, 127) ) )
        .AddArg( SmartPtr<s16>( new s16( "volume max", 0, 127) ) )
        .AddArg( SmartPtr<s16>( new s16( "time", 0, 32767) ) )
        ;

    parser.mCommandTable[ "volume2_r_tr" ]
        .AddCode( MmlCommand::MML_TIME_RANDOM )
        .AddCode( MmlCommand::MML_RANDOM )
        .AddCode( MmlCommand::MML_VOLUME2 )
        .AddArg( SmartPtr<s16>( new s16( "volume min", 0, 127) ) )
        .AddArg( SmartPtr<s16>( new s16( "volume max", 0, 127) ) )
        .AddArg( SmartPtr<s16>( new s16( "time min", 0, 32767) ) )
        .AddArg( SmartPtr<s16>( new s16( "time max", 0, 32767) ) )
        ;

    parser.mCommandTable[ "volume2_r_tv" ]
        .AddCode( MmlCommand::MML_TIME_VARIABLE )
        .AddCode( MmlCommand::MML_RANDOM )
        .AddCode( MmlCommand::MML_VOLUME2 )
        .AddArg( SmartPtr<s16>( new s16( "volume min", 0, 127) ) )
        .AddArg( SmartPtr<s16>( new s16( "volume max", 0, 127) ) )
        .AddArg( SmartPtr<u8>( new u8( "time variable number", 0, VAR_NUM_MAX) ) )
        ;

    parser.mCommandTable[ "volume2_v_t" ]
        .AddCode( MmlCommand::MML_TIME )
        .AddCode( MmlCommand::MML_VARIABLE )
        .AddCode( MmlCommand::MML_VOLUME2 )
        .AddArg( SmartPtr<u8>( new u8( "variable number", 0, VAR_NUM_MAX) ) )
        .AddArg( SmartPtr<s16>( new s16( "time", 0, 32767) ) )
        ;

    parser.mCommandTable[ "volume2_v_tr" ]
        .AddCode( MmlCommand::MML_TIME_RANDOM )
        .AddCode( MmlCommand::MML_VARIABLE )
        .AddCode( MmlCommand::MML_VOLUME2 )
        .AddArg( SmartPtr<u8>( new u8( "variable number", 0, VAR_NUM_MAX) ) )
        .AddArg( SmartPtr<s16>( new s16( "time min", 0, 32767) ) )
        .AddArg( SmartPtr<s16>( new s16( "time max", 0, 32767) ) )
        ;

    parser.mCommandTable[ "volume2_v_tv" ]
        .AddCode( MmlCommand::MML_TIME_VARIABLE )
        .AddCode( MmlCommand::MML_VARIABLE )
        .AddCode( MmlCommand::MML_VOLUME2 )
        .AddArg( SmartPtr<u8>( new u8( "variable number", 0, VAR_NUM_MAX) ) )
        .AddArg( SmartPtr<u8>( new u8( "time variable number", 0, VAR_NUM_MAX) ) )
        ;


    //-----------------------------------------------------------------------------
    //
    parser.mCommandTable[ "velocity_range" ]
        .AddCode( MmlCommand::MML_VELOCITY_RANGE )
        .AddArg( SmartPtr<u8>( new u8( "velocity range", 0, 127) ) )
        ;

    parser.mCommandTable[ "velocity_range_r" ]
        .AddCode( MmlCommand::MML_RANDOM )
        .AddCode( MmlCommand::MML_VELOCITY_RANGE )
        .AddArg( SmartPtr<s16>( new s16( "velocity range min", 0, 127) ) )
        .AddArg( SmartPtr<s16>( new s16( "velocity range max", 0, 127) ) )
        ;
    parser.mCommandTable[ "velocity_range_v" ]
        .AddCode( MmlCommand::MML_VARIABLE )
        .AddCode( MmlCommand::MML_VELOCITY_RANGE )
        .AddArg( SmartPtr<u8>( new u8( "variable number", 0, VAR_NUM_MAX) ) )
        ;

    //-----------------------------------------------------------------------------
    //
    parser.mCommandTable[ "main_volume" ]
        .AddCode( MmlCommand::MML_MAIN_VOLUME )
        .AddArg( SmartPtr<u8>( new u8( "main volume", 0, 127) ) )
        ;

    parser.mCommandTable[ "main_volume_r" ]
        .AddCode( MmlCommand::MML_RANDOM )
        .AddCode( MmlCommand::MML_MAIN_VOLUME )
        .AddArg( SmartPtr<s16>( new s16( "main volume min", 0, 127) ) )
        .AddArg( SmartPtr<s16>( new s16( "main volume max", 0, 127) ) )
        ;
    parser.mCommandTable[ "main_volume_v" ]
        .AddCode( MmlCommand::MML_VARIABLE )
        .AddCode( MmlCommand::MML_MAIN_VOLUME )
        .AddArg( SmartPtr<u8>( new u8( "variable number", 0, VAR_NUM_MAX) ) )
        ;

    parser.mCommandTable[ "main_volume_t" ]
        .AddCode( MmlCommand::MML_TIME )
        .AddCode( MmlCommand::MML_MAIN_VOLUME )
        .AddArg( SmartPtr<u8>( new u8( "main volume", 0, 127) ) )
        .AddArg( SmartPtr<s16>( new s16( "time", 0, 32767) ) )
        ;

    parser.mCommandTable[ "main_volume_tr" ]
        .AddCode( MmlCommand::MML_TIME_RANDOM )
        .AddCode( MmlCommand::MML_MAIN_VOLUME )
        .AddArg( SmartPtr<u8>( new u8( "main volume", 0, 127) ) )
        .AddArg( SmartPtr<s16>( new s16( "time min", 0, 32767) ) )
        .AddArg( SmartPtr<s16>( new s16( "time max", 0, 32767) ) )
        ;

    parser.mCommandTable[ "main_volume_tv" ]
        .AddCode( MmlCommand::MML_TIME_VARIABLE )
        .AddCode( MmlCommand::MML_MAIN_VOLUME )
        .AddArg( SmartPtr<u8>( new u8( "main volume", 0, 127) ) )
        .AddArg( SmartPtr<u8>( new u8( "time variable number", 0, VAR_NUM_MAX) ) )
        ;

    parser.mCommandTable[ "main_volume_r_t" ]
        .AddCode( MmlCommand::MML_TIME )
        .AddCode( MmlCommand::MML_RANDOM )
        .AddCode( MmlCommand::MML_MAIN_VOLUME )
        .AddArg( SmartPtr<s16>( new s16( "main volume min", 0, 127) ) )
        .AddArg( SmartPtr<s16>( new s16( "main volume max", 0, 127) ) )
        .AddArg( SmartPtr<s16>( new s16( "time", 0, 32767) ) )
        ;

    parser.mCommandTable[ "main_volume_r_tr" ]
        .AddCode( MmlCommand::MML_TIME_RANDOM )
        .AddCode( MmlCommand::MML_RANDOM )
        .AddCode( MmlCommand::MML_MAIN_VOLUME )
        .AddArg( SmartPtr<s16>( new s16( "main volume min", 0, 127) ) )
        .AddArg( SmartPtr<s16>( new s16( "main volume max", 0, 127) ) )
        .AddArg( SmartPtr<s16>( new s16( "time min", 0, 32767) ) )
        .AddArg( SmartPtr<s16>( new s16( "time max", 0, 32767) ) )
        ;

    parser.mCommandTable[ "main_volume_r_tv" ]
        .AddCode( MmlCommand::MML_TIME_VARIABLE )
        .AddCode( MmlCommand::MML_RANDOM )
        .AddCode( MmlCommand::MML_MAIN_VOLUME )
        .AddArg( SmartPtr<s16>( new s16( "main volume min", 0, 127) ) )
        .AddArg( SmartPtr<s16>( new s16( "main volume max", 0, 127) ) )
        .AddArg( SmartPtr<u8>( new u8( "time variable number", 0, VAR_NUM_MAX) ) )
        ;

    parser.mCommandTable[ "main_volume_v_t" ]
        .AddCode( MmlCommand::MML_TIME )
        .AddCode( MmlCommand::MML_VARIABLE )
        .AddCode( MmlCommand::MML_MAIN_VOLUME )
        .AddArg( SmartPtr<u8>( new u8( "variable number", 0, VAR_NUM_MAX) ) )
        .AddArg( SmartPtr<s16>( new s16( "time", 0, 32767) ) )
        ;

    parser.mCommandTable[ "main_volume_v_tr" ]
        .AddCode( MmlCommand::MML_TIME_RANDOM )
        .AddCode( MmlCommand::MML_VARIABLE )
        .AddCode( MmlCommand::MML_MAIN_VOLUME )
        .AddArg( SmartPtr<u8>( new u8( "variable number", 0, VAR_NUM_MAX) ) )
        .AddArg( SmartPtr<s16>( new s16( "time min", 0, 32767) ) )
        .AddArg( SmartPtr<s16>( new s16( "time max", 0, 32767) ) )
        ;

    parser.mCommandTable[ "main_volume_v_tv" ]
        .AddCode( MmlCommand::MML_TIME_VARIABLE )
        .AddCode( MmlCommand::MML_VARIABLE )
        .AddCode( MmlCommand::MML_MAIN_VOLUME )
        .AddArg( SmartPtr<u8>( new u8( "variable number", 0, VAR_NUM_MAX) ) )
        .AddArg( SmartPtr<u8>( new u8( "time variable number", 0, VAR_NUM_MAX) ) )
        ;



    //-----------------------------------------------------------------------------
    //
    parser.mCommandTable[ "transpose" ]
        .AddCode( MmlCommand::MML_TRANSPOSE )
        .AddArg( SmartPtr<s8>( new s8( "transpose", -64, 63) ) )
        ;

    parser.mCommandTable[ "transpose_r" ]
        .AddCode( MmlCommand::MML_RANDOM )
        .AddCode( MmlCommand::MML_TRANSPOSE )
        .AddArg( SmartPtr<s16>( new s16( "transpose min", -64, 63) ) )
        .AddArg( SmartPtr<s16>( new s16( "transpose max", -64, 63) ) )
        ;
    parser.mCommandTable[ "transpose_v" ]
        .AddCode( MmlCommand::MML_VARIABLE )
        .AddCode( MmlCommand::MML_TRANSPOSE )
        .AddArg( SmartPtr<u8>( new u8( "variable number", 0, VAR_NUM_MAX) ) )
        ;

    //-----------------------------------------------------------------------------
    //
    parser.mCommandTable[ "pitchbend" ]
        .AddCode( MmlCommand::MML_PITCH_BEND )
        .AddArg( SmartPtr<s8>( new s8( "pitch bend", -128, 127) ) )
        ;

    parser.mCommandTable[ "pitchbend_r" ]
        .AddCode( MmlCommand::MML_RANDOM )
        .AddCode( MmlCommand::MML_PITCH_BEND )
        .AddArg( SmartPtr<s16>( new s16( "pitch bend min", -128, 127) ) )
        .AddArg( SmartPtr<s16>( new s16( "pitch bend max", -128, 127) ) )
        ;
    parser.mCommandTable[ "pitchbend_v" ]
        .AddCode( MmlCommand::MML_VARIABLE )
        .AddCode( MmlCommand::MML_PITCH_BEND )
        .AddArg( SmartPtr<u8>( new u8( "variable number", 0, VAR_NUM_MAX) ) )
        ;

    parser.mCommandTable[ "pitchbend_t" ]
        .AddCode( MmlCommand::MML_TIME )
        .AddCode( MmlCommand::MML_PITCH_BEND )
        .AddArg( SmartPtr<s8>( new s8( "pitch bend", -127, 127) ) )
        .AddArg( SmartPtr<s16>( new s16( "time", 0, 32767) ) )
        ;

    parser.mCommandTable[ "pitchbend_tr" ]
        .AddCode( MmlCommand::MML_TIME_RANDOM )
        .AddCode( MmlCommand::MML_PITCH_BEND )
        .AddArg( SmartPtr<s8>( new s8( "pitch bend", -127, 127) ) )
        .AddArg( SmartPtr<s16>( new s16( "time min", 0, 32767) ) )
        .AddArg( SmartPtr<s16>( new s16( "time max", 0, 32767) ) )
        ;

    parser.mCommandTable[ "pitchbend_tv" ]
        .AddCode( MmlCommand::MML_TIME_VARIABLE )
        .AddCode( MmlCommand::MML_PITCH_BEND )
        .AddArg( SmartPtr<s8>( new s8( "pitch bend", -127, 127) ) )
        .AddArg( SmartPtr<u8>( new u8( "time variable number", 0, VAR_NUM_MAX) ) )
        ;

    parser.mCommandTable[ "pitchbend_r_t" ]
        .AddCode( MmlCommand::MML_TIME )
        .AddCode( MmlCommand::MML_RANDOM )
        .AddCode( MmlCommand::MML_PITCH_BEND )
        .AddArg( SmartPtr<s16>( new s16( "pitch bend min", -127, 127) ) )
        .AddArg( SmartPtr<s16>( new s16( "pitch bend max", -127, 127) ) )
        .AddArg( SmartPtr<s16>( new s16( "time", 0, 32767) ) )
        ;

    parser.mCommandTable[ "pitchbend_r_tr" ]
        .AddCode( MmlCommand::MML_TIME_RANDOM )
        .AddCode( MmlCommand::MML_RANDOM )
        .AddCode( MmlCommand::MML_PITCH_BEND )
        .AddArg( SmartPtr<s16>( new s16( "pitch bend min", -127, 127) ) )
        .AddArg( SmartPtr<s16>( new s16( "pitch bend max", -127, 127) ) )
        .AddArg( SmartPtr<s16>( new s16( "time min", 0, 32767) ) )
        .AddArg( SmartPtr<s16>( new s16( "time max", 0, 32767) ) )
        ;

    parser.mCommandTable[ "pitchbend_r_tv" ]
        .AddCode( MmlCommand::MML_TIME_VARIABLE )
        .AddCode( MmlCommand::MML_RANDOM )
        .AddCode( MmlCommand::MML_PITCH_BEND )
        .AddArg( SmartPtr<s16>( new s16( "pitch bend min", -127, 127) ) )
        .AddArg( SmartPtr<s16>( new s16( "pitch bend max", -127, 127) ) )
        .AddArg( SmartPtr<u8>( new u8( "time variable number", 0, VAR_NUM_MAX) ) )
        ;

    parser.mCommandTable[ "pitchbend_v_t" ]
        .AddCode( MmlCommand::MML_TIME )
        .AddCode( MmlCommand::MML_VARIABLE )
        .AddCode( MmlCommand::MML_PITCH_BEND )
        .AddArg( SmartPtr<u8>( new u8( "variable number", 0, VAR_NUM_MAX) ) )
        .AddArg( SmartPtr<s16>( new s16( "time", 0, 32767) ) )
        ;

    parser.mCommandTable[ "pitchbend_v_tr" ]
        .AddCode( MmlCommand::MML_TIME_RANDOM )
        .AddCode( MmlCommand::MML_VARIABLE )
        .AddCode( MmlCommand::MML_PITCH_BEND )
        .AddArg( SmartPtr<u8>( new u8( "variable number", 0, VAR_NUM_MAX) ) )
        .AddArg( SmartPtr<s16>( new s16( "time min", 0, 32767) ) )
        .AddArg( SmartPtr<s16>( new s16( "time max", 0, 32767) ) )
        ;

    parser.mCommandTable[ "pitchbend_v_tv" ]
        .AddCode( MmlCommand::MML_TIME_VARIABLE )
        .AddCode( MmlCommand::MML_VARIABLE )
        .AddCode( MmlCommand::MML_PITCH_BEND )
        .AddArg( SmartPtr<u8>( new u8( "variable number", 0, VAR_NUM_MAX) ) )
        .AddArg( SmartPtr<u8>( new u8( "time variable number", 0, VAR_NUM_MAX) ) )
        ;

    //-----------------------------------------------------------------------------
    //
    parser.mCommandTable[ "bendrange" ]
        .AddCode( MmlCommand::MML_BEND_RANGE )
        .AddArg( SmartPtr<u8>( new u8( "pitch bend", 0, 127) ) )
        ;

    //-----------------------------------------------------------------------------
    //
    parser.mCommandTable[ "prio" ]
        .AddCode( MmlCommand::MML_PRIO )
        .AddArg( SmartPtr<u8>( new u8( "priority", 0, 127) ) )
        ;

    //-----------------------------------------------------------------------------
    //
    parser.mCommandTable[ "notewait_on" ]
        .AddCode( MmlCommand::MML_NOTE_WAIT )
        .AddCode( 1 )
        ;

    //-----------------------------------------------------------------------------
    //
    parser.mCommandTable[ "notewait_off" ]
        .AddCode( MmlCommand::MML_NOTE_WAIT )
        .AddCode( 0 )
        ;

    //-----------------------------------------------------------------------------
    //
    parser.mCommandTable[ "frontbypass_on" ]
        .AddCode( MmlCommand::MML_FRONT_BYPASS )
        .AddCode( 1 )
        ;

    //-----------------------------------------------------------------------------
    //
    parser.mCommandTable[ "frontbypass_off" ]
        .AddCode( MmlCommand::MML_FRONT_BYPASS )
        .AddCode( 0 )
        ;

    //-----------------------------------------------------------------------------
    //
    parser.mCommandTable[ "porta" ]
        .AddCode( MmlCommand::MML_PORTA )
        .AddArg( SmartPtr<u8>( new u8( "portament key", 0, 127) ) )
        ;

    //-----------------------------------------------------------------------------
    //
    parser.mCommandTable[ "porta_time" ]
        .AddCode( MmlCommand::MML_PORTA_TIME )
        .AddArg( SmartPtr<u8>( new u8( "portament time", 0, 255) ) )
        ;

    parser.mCommandTable[ "porta_time_r" ]
        .AddCode( MmlCommand::MML_RANDOM )
        .AddCode( MmlCommand::MML_PORTA_TIME )
        .AddArg( SmartPtr<s16>( new s16( "portament time min", 0, 255) ) )
        .AddArg( SmartPtr<s16>( new s16( "portament time max", 0, 255) ) )
        ;
    parser.mCommandTable[ "porta_time_v" ]
        .AddCode( MmlCommand::MML_VARIABLE )
        .AddCode( MmlCommand::MML_PORTA_TIME )
        .AddArg( SmartPtr<u8>( new u8( "variable number", 0, VAR_NUM_MAX) ) )
        ;


    //-----------------------------------------------------------------------------
    //
    parser.mCommandTable[ "sweep_pitch" ]
        .AddCode( MmlCommand::MML_SWEEP_PITCH )
        .AddArg( SmartPtr<s16>( new s16( "sweep pitch", -32768, 32767) ) )
        ;

    parser.mCommandTable[ "sweep_pitch_r" ]
        .AddCode( MmlCommand::MML_RANDOM )
        .AddCode( MmlCommand::MML_SWEEP_PITCH )
        .AddArg( SmartPtr<s16>( new s16( "sweep pitch min", -32768, 32767) ) )
        .AddArg( SmartPtr<s16>( new s16( "sweep pitch max", -32768, 32767) ) )
        ;
    parser.mCommandTable[ "sweep_pitch_v" ]
        .AddCode( MmlCommand::MML_VARIABLE )
        .AddCode( MmlCommand::MML_SWEEP_PITCH )
        .AddArg( SmartPtr<u8>( new u8( "variable number", 0, VAR_NUM_MAX) ) )
        ;


    //-----------------------------------------------------------------------------
    //
    parser.mCommandTable[ "tieon" ]
        .AddCode( MmlCommand::MML_TIE )
        .AddCode( 1 )
        ;

    //-----------------------------------------------------------------------------
    //
    parser.mCommandTable[ "tieoff" ]
        .AddCode( MmlCommand::MML_TIE )
        .AddCode( 0 )
        ;

    //-----------------------------------------------------------------------------
    //
    parser.mCommandTable[ "monophonic_on" ]
        .AddCode( MmlCommand::MML_MONOPHONIC )
        .AddCode( 127 )
        ;

    //-----------------------------------------------------------------------------
    //
    parser.mCommandTable[ "monophonic_off" ]
        .AddCode( MmlCommand::MML_MONOPHONIC )
        .AddCode( 0 )
        ;

    //-----------------------------------------------------------------------------
    //
    parser.mCommandTable[ "damper_on" ]
        .AddCode( MmlCommand::MML_DAMPER )
        .AddCode( 127 )
        ;

    //-----------------------------------------------------------------------------
    //
    parser.mCommandTable[ "damper_off" ]
        .AddCode( MmlCommand::MML_DAMPER )
        .AddCode( 0 )
        ;


//
//
// モジュレーション 1 {{
//
//

    //-----------------------------------------------------------------------------
    //
    parser.mCommandTable[ "mod_depth" ]
        .AddCode( MmlCommand::MML_MOD_DEPTH )
        .AddArg( SmartPtr<u8>( new u8( "modulation depth", 0, 127) ) )
        ;

    parser.mCommandTable[ "mod_depth_r" ]
        .AddCode( MmlCommand::MML_RANDOM )
        .AddCode( MmlCommand::MML_MOD_DEPTH )
        .AddArg( SmartPtr<s16>( new s16( "modulation depth min", 0, 127) ) )
        .AddArg( SmartPtr<s16>( new s16( "modulation depth max", 0, 127) ) )
        ;
    parser.mCommandTable[ "mod_depth_v" ]
        .AddCode( MmlCommand::MML_VARIABLE )
        .AddCode( MmlCommand::MML_MOD_DEPTH )
        .AddArg( SmartPtr<u8>( new u8( "variable number", 0, VAR_NUM_MAX) ) )
        ;


    //-----------------------------------------------------------------------------
    //
    parser.mCommandTable[ "mod_speed" ]
        .AddCode( MmlCommand::MML_MOD_SPEED )
        .AddArg( SmartPtr<u8>( new u8( "modulation speed", 0, 127) ) )
        ;

    parser.mCommandTable[ "mod_speed_r" ]
        .AddCode( MmlCommand::MML_RANDOM )
        .AddCode( MmlCommand::MML_MOD_SPEED )
        .AddArg( SmartPtr<s16>( new s16( "modulation speed min", 0, 127) ) )
        .AddArg( SmartPtr<s16>( new s16( "modulation speed max", 0, 127) ) )
        ;
    parser.mCommandTable[ "mod_speed_v" ]
        .AddCode( MmlCommand::MML_VARIABLE )
        .AddCode( MmlCommand::MML_MOD_SPEED )
        .AddArg( SmartPtr<u8>( new u8( "variable number", 0, VAR_NUM_MAX) ) )
        ;


    //-----------------------------------------------------------------------------
    //
    parser.mCommandTable[ "mod_period" ]
        .AddCode( MmlCommand::MML_MOD_PERIOD )
        .AddArg( SmartPtr<s16>( new s16( "modulation period", 0, 32767) ) )
        ;

    parser.mCommandTable[ "mod_period_r" ]
        .AddCode( MmlCommand::MML_RANDOM )
        .AddCode( MmlCommand::MML_MOD_PERIOD )
        .AddArg( SmartPtr<s16>( new s16( "modulation period min", 0, 32767) ) )
        .AddArg( SmartPtr<s16>( new s16( "modulation period max", 0, 32767) ) )
        ;
    parser.mCommandTable[ "mod_period_v" ]
        .AddCode( MmlCommand::MML_VARIABLE )
        .AddCode( MmlCommand::MML_MOD_PERIOD )
        .AddArg( SmartPtr<u8>( new u8( "variable number", 0, VAR_NUM_MAX) ) )
        ;


    //-----------------------------------------------------------------------------
    //
    parser.mCommandTable[ "mod_type" ]
        .AddCode( MmlCommand::MML_MOD_TYPE )
        .AddArg( SmartPtr<u8>( new u8( "modulation type", 0, 2) ) )
        ;


    //-----------------------------------------------------------------------------
    //
    parser.mCommandTable[ "mod_phase" ]
        .AddCode( MmlCommand::MML_MOD_PHASE )
        .AddArg( SmartPtr<u8>( new u8( "modulation phase", 0, 127) ) )
        ;
    parser.mCommandTable[ "mod_phase_r" ]
        .AddCode( MmlCommand::MML_RANDOM )
        .AddCode( MmlCommand::MML_MOD_PHASE )
        .AddArg( SmartPtr<s16>( new s16( "modulation phase min", 0, 127) ) )
        .AddArg( SmartPtr<s16>( new s16( "modulation phase max", 0, 127) ) )
        ;
    parser.mCommandTable[ "mod_phase_v" ]
        .AddCode( MmlCommand::MML_VARIABLE )
        .AddCode( MmlCommand::MML_MOD_PHASE )
        .AddArg( SmartPtr<u8>( new u8( "variable number", 0, VAR_NUM_MAX) ) )
        ;


    //-----------------------------------------------------------------------------
    //
    parser.mCommandTable[ "mod_curve" ]
        .AddCode( MmlCommand::MML_MOD_CURVE )
        .AddArg( SmartPtr<u8>( new u8( "modulation curve type", 0, 127) ) )
        ;
    parser.mCommandTable[ "mod_curve_r" ]
        .AddCode( MmlCommand::MML_RANDOM )
        .AddCode( MmlCommand::MML_MOD_CURVE )
        .AddArg( SmartPtr<s16>( new s16( "modulation curve min", 0, 127) ) )
        .AddArg( SmartPtr<s16>( new s16( "modulation curve max", 0, 127) ) )
        ;
    parser.mCommandTable[ "mod_curve_v" ]
        .AddCode( MmlCommand::MML_VARIABLE )
        .AddCode( MmlCommand::MML_MOD_CURVE )
        .AddArg( SmartPtr<u8>( new u8( "variable number", 0, VAR_NUM_MAX) ) )
        ;

    //-----------------------------------------------------------------------------
    //
    parser.mCommandTable[ "mod_range" ]
        .AddCode( MmlCommand::MML_MOD_RANGE )
        .AddArg( SmartPtr<u8>( new u8( "modulation range", 0, 127) ) )
        ;

    //-----------------------------------------------------------------------------
    //
    parser.mCommandTable[ "mod_delay" ]
        .AddCode( MmlCommand::MML_MOD_DELAY )
        .AddArg( SmartPtr<s16>( new s16( "modulation delay", 0, 32767) ) )
        ;

    parser.mCommandTable[ "mod_delay_r" ]
        .AddCode( MmlCommand::MML_RANDOM )
        .AddCode( MmlCommand::MML_MOD_DELAY )
        .AddArg( SmartPtr<s16>( new s16( "modulation delay min", 0, 32767) ) )
        .AddArg( SmartPtr<s16>( new s16( "modulation delay max", 0, 32767) ) )
        ;
    parser.mCommandTable[ "mod_delay_v" ]
        .AddCode( MmlCommand::MML_VARIABLE )
        .AddCode( MmlCommand::MML_MOD_DELAY )
        .AddArg( SmartPtr<u8>( new u8( "variable number", 0, VAR_NUM_MAX) ) )
        ;
// }} モジュレーション 1
//
//
// モジュレーション 2 {{
//
//

    //-----------------------------------------------------------------------------
    //
    parser.mCommandTable[ "mod2_depth" ]
        .AddCode( MmlCommand::MML_EX_COMMAND )
        .AddCode( MmlCommand::MML_MOD_2_DEPTH )
        .AddArg( SmartPtr<u8>( new u8( "modulation depth", 0, 127) ) )
        ;

    parser.mCommandTable[ "mod2_depth_r" ]
        .AddCode( MmlCommand::MML_RANDOM )
        .AddCode( MmlCommand::MML_EX_COMMAND )
        .AddCode( MmlCommand::MML_MOD_2_DEPTH )
        .AddArg( SmartPtr<s16>( new s16( "modulation depth min", 0, 127) ) )
        .AddArg( SmartPtr<s16>( new s16( "modulation depth max", 0, 127) ) )
        ;
    parser.mCommandTable[ "mod2_depth_v" ]
        .AddCode( MmlCommand::MML_VARIABLE )
        .AddCode( MmlCommand::MML_EX_COMMAND )
        .AddCode( MmlCommand::MML_MOD_2_DEPTH )
        .AddArg( SmartPtr<u8>( new u8( "variable number", 0, VAR_NUM_MAX) ) )
        ;


    //-----------------------------------------------------------------------------
    //
    parser.mCommandTable[ "mod2_speed" ]
        .AddCode( MmlCommand::MML_EX_COMMAND )
        .AddCode( MmlCommand::MML_MOD_2_SPEED )
        .AddArg( SmartPtr<u8>( new u8( "modulation speed", 0, 127) ) )
        ;

    parser.mCommandTable[ "mod2_speed_r" ]
        .AddCode( MmlCommand::MML_RANDOM )
        .AddCode( MmlCommand::MML_EX_COMMAND )
        .AddCode( MmlCommand::MML_MOD_2_SPEED )
        .AddArg( SmartPtr<s16>( new s16( "modulation speed min", 0, 127) ) )
        .AddArg( SmartPtr<s16>( new s16( "modulation speed max", 0, 127) ) )
        ;
    parser.mCommandTable[ "mod2_speed_v" ]
        .AddCode( MmlCommand::MML_VARIABLE )
        .AddCode( MmlCommand::MML_EX_COMMAND )
        .AddCode( MmlCommand::MML_MOD_2_SPEED )
        .AddArg( SmartPtr<u8>( new u8( "variable number", 0, VAR_NUM_MAX) ) )
        ;


    //-----------------------------------------------------------------------------
    //
    parser.mCommandTable[ "mod2_period" ]
        .AddCode( MmlCommand::MML_EX_COMMAND )
        .AddCode( MmlCommand::MML_MOD_2_PERIOD )
        .AddArg( SmartPtr<s16>( new s16( "modulation period", 0, 32767) ) )
        ;

    parser.mCommandTable[ "mod2_period_r" ]
        .AddCode( MmlCommand::MML_RANDOM )
        .AddCode( MmlCommand::MML_EX_COMMAND )
        .AddCode( MmlCommand::MML_MOD_2_PERIOD )
        .AddArg( SmartPtr<s16>( new s16( "modulation period min", 0, 32767) ) )
        .AddArg( SmartPtr<s16>( new s16( "modulation period max", 0, 32767) ) )
        ;
    parser.mCommandTable[ "mod2_period_v" ]
        .AddCode( MmlCommand::MML_VARIABLE )
        .AddCode( MmlCommand::MML_EX_COMMAND )
        .AddCode( MmlCommand::MML_MOD_2_PERIOD )
        .AddArg( SmartPtr<u8>( new u8( "variable number", 0, VAR_NUM_MAX) ) )
        ;


    //-----------------------------------------------------------------------------
    //
    parser.mCommandTable[ "mod2_type" ]
        .AddCode( MmlCommand::MML_EX_COMMAND )
        .AddCode( MmlCommand::MML_MOD_2_TYPE )
        .AddArg( SmartPtr<u8>( new u8( "modulation type", 0, 2) ) )
        ;


    //-----------------------------------------------------------------------------
    //
    parser.mCommandTable[ "mod2_phase" ]
        .AddCode( MmlCommand::MML_EX_COMMAND )
        .AddCode( MmlCommand::MML_MOD_2_PHASE )
        .AddArg( SmartPtr<u8>( new u8( "modulation phase", 0, 127) ) )
        ;
    parser.mCommandTable[ "mod2_phase_r" ]
        .AddCode( MmlCommand::MML_RANDOM )
        .AddCode( MmlCommand::MML_EX_COMMAND )
        .AddCode( MmlCommand::MML_MOD_2_PHASE )
        .AddArg( SmartPtr<s16>( new s16( "modulation phase min", 0, 127) ) )
        .AddArg( SmartPtr<s16>( new s16( "modulation phase max", 0, 127) ) )
        ;
    parser.mCommandTable[ "mod2_phase_v" ]
        .AddCode( MmlCommand::MML_VARIABLE )
        .AddCode( MmlCommand::MML_EX_COMMAND )
        .AddCode( MmlCommand::MML_MOD_2_PHASE )
        .AddArg( SmartPtr<u8>( new u8( "variable number", 0, VAR_NUM_MAX) ) )
        ;


    //-----------------------------------------------------------------------------
    //
    parser.mCommandTable[ "mod2_curve" ]
        .AddCode( MmlCommand::MML_EX_COMMAND )
        .AddCode( MmlCommand::MML_MOD_2_CURVE )
        .AddArg( SmartPtr<u8>( new u8( "modulation curve type", 0, 127) ) )
        ;
    parser.mCommandTable[ "mod2_curve_r" ]
        .AddCode( MmlCommand::MML_RANDOM )
        .AddCode( MmlCommand::MML_EX_COMMAND )
        .AddCode( MmlCommand::MML_MOD_2_CURVE )
        .AddArg( SmartPtr<s16>( new s16( "modulation curve min", 0, 127) ) )
        .AddArg( SmartPtr<s16>( new s16( "modulation curve max", 0, 127) ) )
        ;
    parser.mCommandTable[ "mod2_curve_v" ]
        .AddCode( MmlCommand::MML_VARIABLE )
        .AddCode( MmlCommand::MML_EX_COMMAND )
        .AddCode( MmlCommand::MML_MOD_2_CURVE )
        .AddArg( SmartPtr<u8>( new u8( "variable number", 0, VAR_NUM_MAX) ) )
        ;

    //-----------------------------------------------------------------------------
    //
    parser.mCommandTable[ "mod2_range" ]
        .AddCode( MmlCommand::MML_EX_COMMAND )
        .AddCode( MmlCommand::MML_MOD_2_RANGE )
        .AddArg( SmartPtr<u8>( new u8( "modulation range", 0, 127) ) )
        ;

    //-----------------------------------------------------------------------------
    //
    parser.mCommandTable[ "mod2_delay" ]
        .AddCode( MmlCommand::MML_EX_COMMAND )
        .AddCode( MmlCommand::MML_MOD_2_DELAY )
        .AddArg( SmartPtr<s16>( new s16( "modulation delay", 0, 32767) ) )
        ;

    parser.mCommandTable[ "mod2_delay_r" ]
        .AddCode( MmlCommand::MML_RANDOM )
        .AddCode( MmlCommand::MML_EX_COMMAND )
        .AddCode( MmlCommand::MML_MOD_2_DELAY )
        .AddArg( SmartPtr<s16>( new s16( "modulation delay min", 0, 32767) ) )
        .AddArg( SmartPtr<s16>( new s16( "modulation delay max", 0, 32767) ) )
        ;
    parser.mCommandTable[ "mod2_delay_v" ]
        .AddCode( MmlCommand::MML_VARIABLE )
        .AddCode( MmlCommand::MML_EX_COMMAND )
        .AddCode( MmlCommand::MML_MOD_2_DELAY )
        .AddArg( SmartPtr<u8>( new u8( "variable number", 0, VAR_NUM_MAX) ) )
        ;
// }} モジュレーション 2
//
//
// モジュレーション 3 {{
//
//

    //-----------------------------------------------------------------------------
    //
    parser.mCommandTable[ "mod3_depth" ]
        .AddCode( MmlCommand::MML_EX_COMMAND )
        .AddCode( MmlCommand::MML_MOD_3_DEPTH )
        .AddArg( SmartPtr<u8>( new u8( "modulation depth", 0, 127) ) )
        ;

    parser.mCommandTable[ "mod3_depth_r" ]
        .AddCode( MmlCommand::MML_RANDOM )
        .AddCode( MmlCommand::MML_EX_COMMAND )
        .AddCode( MmlCommand::MML_MOD_3_DEPTH )
        .AddArg( SmartPtr<s16>( new s16( "modulation depth min", 0, 127) ) )
        .AddArg( SmartPtr<s16>( new s16( "modulation depth max", 0, 127) ) )
        ;
    parser.mCommandTable[ "mod3_depth_v" ]
        .AddCode( MmlCommand::MML_VARIABLE )
        .AddCode( MmlCommand::MML_EX_COMMAND )
        .AddCode( MmlCommand::MML_MOD_3_DEPTH )
        .AddArg( SmartPtr<u8>( new u8( "variable number", 0, VAR_NUM_MAX) ) )
        ;


    //-----------------------------------------------------------------------------
    //
    parser.mCommandTable[ "mod3_speed" ]
        .AddCode( MmlCommand::MML_EX_COMMAND )
        .AddCode( MmlCommand::MML_MOD_3_SPEED )
        .AddArg( SmartPtr<u8>( new u8( "modulation speed", 0, 127) ) )
        ;

    parser.mCommandTable[ "mod3_speed_r" ]
        .AddCode( MmlCommand::MML_RANDOM )
        .AddCode( MmlCommand::MML_EX_COMMAND )
        .AddCode( MmlCommand::MML_MOD_3_SPEED )
        .AddArg( SmartPtr<s16>( new s16( "modulation speed min", 0, 127) ) )
        .AddArg( SmartPtr<s16>( new s16( "modulation speed max", 0, 127) ) )
        ;
    parser.mCommandTable[ "mod3_speed_v" ]
        .AddCode( MmlCommand::MML_VARIABLE )
        .AddCode( MmlCommand::MML_EX_COMMAND )
        .AddCode( MmlCommand::MML_MOD_3_SPEED )
        .AddArg( SmartPtr<u8>( new u8( "variable number", 0, VAR_NUM_MAX) ) )
        ;


    //-----------------------------------------------------------------------------
    //
    parser.mCommandTable[ "mod3_period" ]
        .AddCode( MmlCommand::MML_EX_COMMAND )
        .AddCode( MmlCommand::MML_MOD_3_PERIOD )
        .AddArg( SmartPtr<s16>( new s16( "modulation period", 0, 32767) ) )
        ;

    parser.mCommandTable[ "mod3_period_r" ]
        .AddCode( MmlCommand::MML_RANDOM )
        .AddCode( MmlCommand::MML_EX_COMMAND )
        .AddCode( MmlCommand::MML_MOD_3_PERIOD )
        .AddArg( SmartPtr<s16>( new s16( "modulation period min", 0, 32767) ) )
        .AddArg( SmartPtr<s16>( new s16( "modulation period max", 0, 32767) ) )
        ;
    parser.mCommandTable[ "mod3_period_v" ]
        .AddCode( MmlCommand::MML_VARIABLE )
        .AddCode( MmlCommand::MML_EX_COMMAND )
        .AddCode( MmlCommand::MML_MOD_3_PERIOD )
        .AddArg( SmartPtr<u8>( new u8( "variable number", 0, VAR_NUM_MAX) ) )
        ;


    //-----------------------------------------------------------------------------
    //
    parser.mCommandTable[ "mod3_type" ]
        .AddCode( MmlCommand::MML_EX_COMMAND )
        .AddCode( MmlCommand::MML_MOD_3_TYPE )
        .AddArg( SmartPtr<u8>( new u8( "modulation type", 0, 2) ) )
        ;


    //-----------------------------------------------------------------------------
    //
    parser.mCommandTable[ "mod3_phase" ]
        .AddCode( MmlCommand::MML_EX_COMMAND )
        .AddCode( MmlCommand::MML_MOD_3_PHASE )
        .AddArg( SmartPtr<u8>( new u8( "modulation phase", 0, 127) ) )
        ;
    parser.mCommandTable[ "mod3_phase_r" ]
        .AddCode( MmlCommand::MML_RANDOM )
        .AddCode( MmlCommand::MML_EX_COMMAND )
        .AddCode( MmlCommand::MML_MOD_3_PHASE )
        .AddArg( SmartPtr<s16>( new s16( "modulation phase min", 0, 127) ) )
        .AddArg( SmartPtr<s16>( new s16( "modulation phase max", 0, 127) ) )
        ;
    parser.mCommandTable[ "mod3_phase_v" ]
        .AddCode( MmlCommand::MML_VARIABLE )
        .AddCode( MmlCommand::MML_EX_COMMAND )
        .AddCode( MmlCommand::MML_MOD_3_PHASE )
        .AddArg( SmartPtr<u8>( new u8( "variable number", 0, VAR_NUM_MAX) ) )
        ;


    //-----------------------------------------------------------------------------
    //
    parser.mCommandTable[ "mod3_curve" ]
        .AddCode( MmlCommand::MML_EX_COMMAND )
        .AddCode( MmlCommand::MML_MOD_3_CURVE )
        .AddArg( SmartPtr<u8>( new u8( "modulation curve type", 0, 127) ) )
        ;
    parser.mCommandTable[ "mod3_curve_r" ]
        .AddCode( MmlCommand::MML_RANDOM )
        .AddCode( MmlCommand::MML_EX_COMMAND )
        .AddCode( MmlCommand::MML_MOD_3_CURVE )
        .AddArg( SmartPtr<s16>( new s16( "modulation curve min", 0, 127) ) )
        .AddArg( SmartPtr<s16>( new s16( "modulation curve max", 0, 127) ) )
        ;
    parser.mCommandTable[ "mod3_curve_v" ]
        .AddCode( MmlCommand::MML_VARIABLE )
        .AddCode( MmlCommand::MML_EX_COMMAND )
        .AddCode( MmlCommand::MML_MOD_3_CURVE )
        .AddArg( SmartPtr<u8>( new u8( "variable number", 0, VAR_NUM_MAX) ) )
        ;

    //-----------------------------------------------------------------------------
    //
    parser.mCommandTable[ "mod3_range" ]
        .AddCode( MmlCommand::MML_EX_COMMAND )
        .AddCode( MmlCommand::MML_MOD_3_RANGE )
        .AddArg( SmartPtr<u8>( new u8( "modulation range", 0, 127) ) )
        ;

    //-----------------------------------------------------------------------------
    //
    parser.mCommandTable[ "mod3_delay" ]
        .AddCode( MmlCommand::MML_EX_COMMAND )
        .AddCode( MmlCommand::MML_MOD_3_DELAY )
        .AddArg( SmartPtr<s16>( new s16( "modulation delay", 0, 32767) ) )
        ;

    parser.mCommandTable[ "mod3_delay_r" ]
        .AddCode( MmlCommand::MML_RANDOM )
        .AddCode( MmlCommand::MML_EX_COMMAND )
        .AddCode( MmlCommand::MML_MOD_3_DELAY )
        .AddArg( SmartPtr<s16>( new s16( "modulation delay min", 0, 32767) ) )
        .AddArg( SmartPtr<s16>( new s16( "modulation delay max", 0, 32767) ) )
        ;
    parser.mCommandTable[ "mod3_delay_v" ]
        .AddCode( MmlCommand::MML_VARIABLE )
        .AddCode( MmlCommand::MML_EX_COMMAND )
        .AddCode( MmlCommand::MML_MOD_3_DELAY )
        .AddArg( SmartPtr<u8>( new u8( "variable number", 0, VAR_NUM_MAX) ) )
        ;
// }} モジュレーション 3
//
//
// モジュレーション 4 {{
//
//

    //-----------------------------------------------------------------------------
    //
    parser.mCommandTable[ "mod4_depth" ]
        .AddCode( MmlCommand::MML_EX_COMMAND )
        .AddCode( MmlCommand::MML_MOD_4_DEPTH )
        .AddArg( SmartPtr<u8>( new u8( "modulation depth", 0, 127) ) )
        ;

    parser.mCommandTable[ "mod4_depth_r" ]
        .AddCode( MmlCommand::MML_RANDOM )
        .AddCode( MmlCommand::MML_EX_COMMAND )
        .AddCode( MmlCommand::MML_MOD_4_DEPTH )
        .AddArg( SmartPtr<s16>( new s16( "modulation depth min", 0, 127) ) )
        .AddArg( SmartPtr<s16>( new s16( "modulation depth max", 0, 127) ) )
        ;
    parser.mCommandTable[ "mod4_depth_v" ]
        .AddCode( MmlCommand::MML_VARIABLE )
        .AddCode( MmlCommand::MML_EX_COMMAND )
        .AddCode( MmlCommand::MML_MOD_4_DEPTH )
        .AddArg( SmartPtr<u8>( new u8( "variable number", 0, VAR_NUM_MAX) ) )
        ;


    //-----------------------------------------------------------------------------
    //
    parser.mCommandTable[ "mod4_speed" ]
        .AddCode( MmlCommand::MML_EX_COMMAND )
        .AddCode( MmlCommand::MML_MOD_4_SPEED )
        .AddArg( SmartPtr<u8>( new u8( "modulation speed", 0, 127) ) )
        ;

    parser.mCommandTable[ "mod4_speed_r" ]
        .AddCode( MmlCommand::MML_RANDOM )
        .AddCode( MmlCommand::MML_EX_COMMAND )
        .AddCode( MmlCommand::MML_MOD_4_SPEED )
        .AddArg( SmartPtr<s16>( new s16( "modulation speed min", 0, 127) ) )
        .AddArg( SmartPtr<s16>( new s16( "modulation speed max", 0, 127) ) )
        ;
    parser.mCommandTable[ "mod4_speed_v" ]
        .AddCode( MmlCommand::MML_VARIABLE )
        .AddCode( MmlCommand::MML_EX_COMMAND )
        .AddCode( MmlCommand::MML_MOD_4_SPEED )
        .AddArg( SmartPtr<u8>( new u8( "variable number", 0, VAR_NUM_MAX) ) )
        ;


    //-----------------------------------------------------------------------------
    //
    parser.mCommandTable[ "mod4_period" ]
        .AddCode( MmlCommand::MML_EX_COMMAND )
        .AddCode( MmlCommand::MML_MOD_4_PERIOD )
        .AddArg( SmartPtr<s16>( new s16( "modulation period", 0, 32767) ) )
        ;

    parser.mCommandTable[ "mod4_period_r" ]
        .AddCode( MmlCommand::MML_RANDOM )
        .AddCode( MmlCommand::MML_EX_COMMAND )
        .AddCode( MmlCommand::MML_MOD_4_PERIOD )
        .AddArg( SmartPtr<s16>( new s16( "modulation period min", 0, 32767) ) )
        .AddArg( SmartPtr<s16>( new s16( "modulation period max", 0, 32767) ) )
        ;
    parser.mCommandTable[ "mod4_period_v" ]
        .AddCode( MmlCommand::MML_VARIABLE )
        .AddCode( MmlCommand::MML_EX_COMMAND )
        .AddCode( MmlCommand::MML_MOD_4_PERIOD )
        .AddArg( SmartPtr<u8>( new u8( "variable number", 0, VAR_NUM_MAX) ) )
        ;


    //-----------------------------------------------------------------------------
    //
    parser.mCommandTable[ "mod4_type" ]
        .AddCode( MmlCommand::MML_EX_COMMAND )
        .AddCode( MmlCommand::MML_MOD_4_TYPE )
        .AddArg( SmartPtr<u8>( new u8( "modulation type", 0, 2) ) )
        ;


    //-----------------------------------------------------------------------------
    //
    parser.mCommandTable[ "mod4_phase" ]
        .AddCode( MmlCommand::MML_EX_COMMAND )
        .AddCode( MmlCommand::MML_MOD_4_PHASE )
        .AddArg( SmartPtr<u8>( new u8( "modulation phase", 0, 127) ) )
        ;
    parser.mCommandTable[ "mod4_phase_r" ]
        .AddCode( MmlCommand::MML_RANDOM )
        .AddCode( MmlCommand::MML_EX_COMMAND )
        .AddCode( MmlCommand::MML_MOD_4_PHASE )
        .AddArg( SmartPtr<s16>( new s16( "modulation phase min", 0, 127) ) )
        .AddArg( SmartPtr<s16>( new s16( "modulation phase max", 0, 127) ) )
        ;
    parser.mCommandTable[ "mod4_phase_v" ]
        .AddCode( MmlCommand::MML_VARIABLE )
        .AddCode( MmlCommand::MML_EX_COMMAND )
        .AddCode( MmlCommand::MML_MOD_4_PHASE )
        .AddArg( SmartPtr<u8>( new u8( "variable number", 0, VAR_NUM_MAX) ) )
        ;


    //-----------------------------------------------------------------------------
    //
    parser.mCommandTable[ "mod4_curve" ]
        .AddCode( MmlCommand::MML_EX_COMMAND )
        .AddCode( MmlCommand::MML_MOD_4_CURVE )
        .AddArg( SmartPtr<u8>( new u8( "modulation curve type", 0, 127) ) )
        ;
    parser.mCommandTable[ "mod4_curve_r" ]
        .AddCode( MmlCommand::MML_RANDOM )
        .AddCode( MmlCommand::MML_EX_COMMAND )
        .AddCode( MmlCommand::MML_MOD_4_CURVE )
        .AddArg( SmartPtr<s16>( new s16( "modulation curve min", 0, 127) ) )
        .AddArg( SmartPtr<s16>( new s16( "modulation curve max", 0, 127) ) )
        ;
    parser.mCommandTable[ "mod4_curve_v" ]
        .AddCode( MmlCommand::MML_VARIABLE )
        .AddCode( MmlCommand::MML_EX_COMMAND )
        .AddCode( MmlCommand::MML_MOD_4_CURVE )
        .AddArg( SmartPtr<u8>( new u8( "variable number", 0, VAR_NUM_MAX) ) )
        ;

    //-----------------------------------------------------------------------------
    //
    parser.mCommandTable[ "mod4_range" ]
        .AddCode( MmlCommand::MML_EX_COMMAND )
        .AddCode( MmlCommand::MML_MOD_4_RANGE )
        .AddArg( SmartPtr<u8>( new u8( "modulation range", 0, 127) ) )
        ;

    //-----------------------------------------------------------------------------
    //
    parser.mCommandTable[ "mod4_delay" ]
        .AddCode( MmlCommand::MML_EX_COMMAND )
        .AddCode( MmlCommand::MML_MOD_4_DELAY )
        .AddArg( SmartPtr<s16>( new s16( "modulation delay", 0, 32767) ) )
        ;

    parser.mCommandTable[ "mod4_delay_r" ]
        .AddCode( MmlCommand::MML_RANDOM )
        .AddCode( MmlCommand::MML_EX_COMMAND )
        .AddCode( MmlCommand::MML_MOD_4_DELAY )
        .AddArg( SmartPtr<s16>( new s16( "modulation delay min", 0, 32767) ) )
        .AddArg( SmartPtr<s16>( new s16( "modulation delay max", 0, 32767) ) )
        ;
    parser.mCommandTable[ "mod4_delay_v" ]
        .AddCode( MmlCommand::MML_VARIABLE )
        .AddCode( MmlCommand::MML_EX_COMMAND )
        .AddCode( MmlCommand::MML_MOD_4_DELAY )
        .AddArg( SmartPtr<u8>( new u8( "variable number", 0, VAR_NUM_MAX) ) )
        ;
// }} モジュレーション 4

    //-----------------------------------------------------------------------------
    //
    parser.mCommandTable[ "attack" ]
        .AddCode( MmlCommand::MML_ATTACK )
        .AddArg( SmartPtr<s8>( new s8( "attack", -1, 127) ) )
        ;
    parser.mCommandTable[ "attack_r" ]
        .AddCode( MmlCommand::MML_RANDOM )
        .AddCode( MmlCommand::MML_ATTACK )
        .AddArg( SmartPtr<s16>( new s16( "attack min", -1, 127) ) )
        .AddArg( SmartPtr<s16>( new s16( "attack max", -1, 127) ) )
        ;
    parser.mCommandTable[ "attack_v" ]
        .AddCode( MmlCommand::MML_VARIABLE )
        .AddCode( MmlCommand::MML_ATTACK )
        .AddArg( SmartPtr<s8>( new s8( "variable number", 0, VAR_NUM_MAX) ) )
        ;

    //-----------------------------------------------------------------------------
    //
    parser.mCommandTable[ "decay" ]
        .AddCode( MmlCommand::MML_DECAY )
        .AddArg( SmartPtr<s8>( new s8( "decay", -1, 127) ) )
        ;
    parser.mCommandTable[ "decay_r" ]
        .AddCode( MmlCommand::MML_RANDOM )
        .AddCode( MmlCommand::MML_DECAY )
        .AddArg( SmartPtr<s16>( new s16( "decay min", -1, 127) ) )
        .AddArg( SmartPtr<s16>( new s16( "decay max", -1, 127) ) )
        ;
    parser.mCommandTable[ "decay_v" ]
        .AddCode( MmlCommand::MML_VARIABLE )
        .AddCode( MmlCommand::MML_DECAY )
        .AddArg( SmartPtr<s8>( new s8( "variable number", 0, VAR_NUM_MAX) ) )
        ;


    //-----------------------------------------------------------------------------
    //
    parser.mCommandTable[ "sustain" ]
        .AddCode( MmlCommand::MML_SUSTAIN )
        .AddArg( SmartPtr<s8>( new s8( "sustain", -1, 127) ) )
        ;
    parser.mCommandTable[ "sustain_r" ]
        .AddCode( MmlCommand::MML_RANDOM )
        .AddCode( MmlCommand::MML_SUSTAIN )
        .AddArg( SmartPtr<s16>( new s16( "sustain min", -1, 127) ) )
        .AddArg( SmartPtr<s16>( new s16( "sustain max", -1, 127) ) )
        ;
    parser.mCommandTable[ "sustain_v" ]
        .AddCode( MmlCommand::MML_VARIABLE )
        .AddCode( MmlCommand::MML_SUSTAIN )
        .AddArg( SmartPtr<s8>( new s8( "variable number", 0, VAR_NUM_MAX) ) )
        ;

    //-----------------------------------------------------------------------------
    //
    parser.mCommandTable[ "release" ]
        .AddCode( MmlCommand::MML_RELEASE )
        .AddArg( SmartPtr<s8>( new s8( "release", -1, 127) ) )
        ;
    parser.mCommandTable[ "release_r" ]
        .AddCode( MmlCommand::MML_RANDOM )
        .AddCode( MmlCommand::MML_RELEASE )
        .AddArg( SmartPtr<s16>( new s16( "release min", -1, 127) ) )
        .AddArg( SmartPtr<s16>( new s16( "release max", -1, 127) ) )
        ;
    parser.mCommandTable[ "release_v" ]
        .AddCode( MmlCommand::MML_VARIABLE )
        .AddCode( MmlCommand::MML_RELEASE )
        .AddArg( SmartPtr<s8>( new s8( "variable number", 0, VAR_NUM_MAX) ) )
        ;

    //-----------------------------------------------------------------------------
    //
    parser.mCommandTable[ "env_hold" ]
        .AddCode( MmlCommand::MML_ENV_HOLD )
        .AddArg( SmartPtr<s8>( new s8( "env hold", -1, 127) ) )
        ;
    parser.mCommandTable[ "env_hold_r" ]
        .AddCode( MmlCommand::MML_RANDOM )
        .AddCode( MmlCommand::MML_ENV_HOLD )
        .AddArg( SmartPtr<s16>( new s16( "env hold min", -1, 127) ) )
        .AddArg( SmartPtr<s16>( new s16( "env hold max", -1, 127) ) )
        ;
    parser.mCommandTable[ "env_hold_v" ]
        .AddCode( MmlCommand::MML_VARIABLE )
        .AddCode( MmlCommand::MML_ENV_HOLD )
        .AddArg( SmartPtr<s8>( new s8( "variable number", 0, VAR_NUM_MAX) ) )
        ;

    //-----------------------------------------------------------------------------
    //
    parser.mCommandTable[ "env_adsr" ]
        .AddCode( MmlCommand::MML_ATTACK )
        .AddArg( SmartPtr<s8>( new s8( "attack", -1, 127) ) )
        .AddCode( MmlCommand::MML_DECAY )
        .AddArg( SmartPtr<s8>( new s8( "decay", -1, 127) ) )
        .AddCode( MmlCommand::MML_SUSTAIN )
        .AddArg( SmartPtr<s8>( new s8( "sustain", -1, 127) ) )
        .AddCode( MmlCommand::MML_RELEASE )
        .AddArg( SmartPtr<s8>( new s8( "release", -1, 127) ) )
        ;

    parser.mCommandTable[ "env_adsr_if" ]
        .AddCode( MmlCommand::MML_IF )
        .AddCode( MmlCommand::MML_ATTACK )
        .AddArg( SmartPtr<s8>( new s8( "attack", -1, 127) ) )
        .AddCode( MmlCommand::MML_IF )
        .AddCode( MmlCommand::MML_DECAY )
        .AddArg( SmartPtr<s8>( new s8( "decay", -1, 127) ) )
        .AddCode( MmlCommand::MML_IF )
        .AddCode( MmlCommand::MML_SUSTAIN )
        .AddArg( SmartPtr<s8>( new s8( "sustain", -1, 127) ) )
        .AddCode( MmlCommand::MML_IF )
        .AddCode( MmlCommand::MML_RELEASE )
        .AddArg( SmartPtr<s8>( new s8( "release", -1, 127) ) )
        ;

    //-----------------------------------------------------------------------------
    //
    parser.mCommandTable[ "env_ahdsr" ]
        .AddCode( MmlCommand::MML_ATTACK )
        .AddArg( SmartPtr<s8>( new s8( "attack", -1, 127) ) )
        .AddCode( MmlCommand::MML_ENV_HOLD )
        .AddArg( SmartPtr<s8>( new s8( "env hold", -1, 127) ) )
        .AddCode( MmlCommand::MML_DECAY )
        .AddArg( SmartPtr<s8>( new s8( "decay", -1, 127) ) )
        .AddCode( MmlCommand::MML_SUSTAIN )
        .AddArg( SmartPtr<s8>( new s8( "sustain", -1, 127) ) )
        .AddCode( MmlCommand::MML_RELEASE )
        .AddArg( SmartPtr<s8>( new s8( "release", -1, 127) ) )
        ;

    parser.mCommandTable[ "env_ahdsr_if" ]
        .AddCode( MmlCommand::MML_IF )
        .AddCode( MmlCommand::MML_ATTACK )
        .AddArg( SmartPtr<s8>( new s8( "attack", -1, 127) ) )
        .AddCode( MmlCommand::MML_IF )
        .AddCode( MmlCommand::MML_ENV_HOLD )
        .AddArg( SmartPtr<s8>( new s8( "env hold", -1, 127) ) )
        .AddCode( MmlCommand::MML_IF )
        .AddCode( MmlCommand::MML_DECAY )
        .AddArg( SmartPtr<s8>( new s8( "decay", -1, 127) ) )
        .AddCode( MmlCommand::MML_IF )
        .AddCode( MmlCommand::MML_SUSTAIN )
        .AddArg( SmartPtr<s8>( new s8( "sustain", -1, 127) ) )
        .AddCode( MmlCommand::MML_IF )
        .AddCode( MmlCommand::MML_RELEASE )
        .AddArg( SmartPtr<s8>( new s8( "release", -1, 127) ) )
        ;

    //-----------------------------------------------------------------------------
    //
    parser.mCommandTable[ "envelope" ]
        .AddCode( MmlCommand::MML_ATTACK )
        .AddArg( SmartPtr<s8>( new s8( "attack", -1, 127) ) )
        .AddCode( MmlCommand::MML_DECAY )
        .AddArg( SmartPtr<s8>( new s8( "decay", -1, 127) ) )
        .AddCode( MmlCommand::MML_SUSTAIN )
        .AddArg( SmartPtr<s8>( new s8( "sustain", -1, 127) ) )
        .AddCode( MmlCommand::MML_RELEASE )
        .AddArg( SmartPtr<s8>( new s8( "release", -1, 127) ) )
        ;

    parser.mCommandTable[ "envelope_if" ]
        .AddCode( MmlCommand::MML_IF )
        .AddCode( MmlCommand::MML_ATTACK )
        .AddArg( SmartPtr<s8>( new s8( "attack", -1, 127) ) )
        .AddCode( MmlCommand::MML_IF )
        .AddCode( MmlCommand::MML_DECAY )
        .AddArg( SmartPtr<s8>( new s8( "decay", -1, 127) ) )
        .AddCode( MmlCommand::MML_IF )
        .AddCode( MmlCommand::MML_SUSTAIN )
        .AddArg( SmartPtr<s8>( new s8( "sustain", -1, 127) ) )
        .AddCode( MmlCommand::MML_IF )
        .AddCode( MmlCommand::MML_RELEASE )
        .AddArg( SmartPtr<s8>( new s8( "release", -1, 127) ) )
        ;

    //-----------------------------------------------------------------------------
    //
    parser.mCommandTable[ "env_reset" ]
        .AddCode( MmlCommand::MML_ENV_RESET )
        ;

    //-----------------------------------------------------------------------------
    //
    parser.mCommandTable[ "lpf_cutoff" ]
        .AddCode( MmlCommand::MML_LPF_CUTOFF )
        .AddArg( SmartPtr<u8>( new u8( "lpf cutoff", 0, 127) ) )
        ;
    parser.mCommandTable[ "lpf_cutoff_r" ]
        .AddCode( MmlCommand::MML_RANDOM )
        .AddCode( MmlCommand::MML_LPF_CUTOFF )
        .AddArg( SmartPtr<s16>( new s16( "lpf cutoff min", 0, 127) ) )
        .AddArg( SmartPtr<s16>( new s16( "lpf cutoff max", 0, 127) ) )
        ;
    parser.mCommandTable[ "lpf_cutoff_v" ]
        .AddCode( MmlCommand::MML_VARIABLE )
        .AddCode( MmlCommand::MML_LPF_CUTOFF )
        .AddArg( SmartPtr<u8>( new u8( "variable number", 0, VAR_NUM_MAX) ) )
        ;

    //-----------------------------------------------------------------------------
    //
    parser.mCommandTable[ "biquad_type" ]
        .AddCode( MmlCommand::MML_BIQUAD_TYPE )
        .AddArg( SmartPtr<u8>( new u8( "biquad type", 0, 127) ) )
        ;
    parser.mCommandTable[ "biquad_type_r" ]
        .AddCode( MmlCommand::MML_RANDOM )
        .AddCode( MmlCommand::MML_BIQUAD_TYPE )
        .AddArg( SmartPtr<s16>( new s16( "biquad type min", 0, 127) ) )
        .AddArg( SmartPtr<s16>( new s16( "biquad type max", 0, 127) ) )
        ;
    parser.mCommandTable[ "biquad_type_v" ]
        .AddCode( MmlCommand::MML_VARIABLE )
        .AddCode( MmlCommand::MML_BIQUAD_TYPE )
        .AddArg( SmartPtr<u8>( new u8( "variable number", 0, VAR_NUM_MAX) ) )
        ;

    //-----------------------------------------------------------------------------
    //
    parser.mCommandTable[ "biquad_value" ]
        .AddCode( MmlCommand::MML_BIQUAD_VALUE )
        .AddArg( SmartPtr<u8>( new u8( "biquad value", 0, 127) ) )
        ;
    parser.mCommandTable[ "biquad_value_r" ]
        .AddCode( MmlCommand::MML_RANDOM )
        .AddCode( MmlCommand::MML_BIQUAD_VALUE )
        .AddArg( SmartPtr<s16>( new s16( "biquad value min", 0, 127) ) )
        .AddArg( SmartPtr<s16>( new s16( "biquad value max", 0, 127) ) )
        ;
    parser.mCommandTable[ "biquad_value_v" ]
        .AddCode( MmlCommand::MML_VARIABLE )
        .AddCode( MmlCommand::MML_BIQUAD_VALUE )
        .AddArg( SmartPtr<u8>( new u8( "variable number", 0, VAR_NUM_MAX) ) )
        ;

    //-----------------------------------------------------------------------------
    //
    parser.mCommandTable[ "bank_select" ]
        .AddCode( MmlCommand::MML_BANK_SELECT )
        .AddArg( SmartPtr<u8>( new u8( "bank select", 0, 3) ) )
        ;
    parser.mCommandTable[ "bank_select_r" ]
        .AddCode( MmlCommand::MML_RANDOM )
        .AddCode( MmlCommand::MML_BANK_SELECT )
        .AddArg( SmartPtr<s16>( new s16( "bank min", 0, 3) ) )
        .AddArg( SmartPtr<s16>( new s16( "bank max", 0, 3) ) )
        ;
    parser.mCommandTable[ "bank_select_v" ]
        .AddCode( MmlCommand::MML_VARIABLE )
        .AddCode( MmlCommand::MML_BANK_SELECT )
        .AddArg( SmartPtr<u8>( new u8( "variable number", 0, VAR_NUM_MAX) ) )
        ;

    //-----------------------------------------------------------------------------
    //
    parser.mCommandTable[ "fxsend_a" ]
        .AddCode( MmlCommand::MML_FXSEND_A )
        .AddArg( SmartPtr<u8>( new u8( "fxsend", 0, 127) ) )
        ;
    parser.mCommandTable[ "fxsend_a_r" ]
        .AddCode( MmlCommand::MML_RANDOM )
        .AddCode( MmlCommand::MML_FXSEND_A )
        .AddArg( SmartPtr<s16>( new s16( "fxsend min", 0, 127) ) )
        .AddArg( SmartPtr<s16>( new s16( "fxsend max", 0, 127) ) )
        ;
    parser.mCommandTable[ "fxsend_a_v" ]
        .AddCode( MmlCommand::MML_VARIABLE )
        .AddCode( MmlCommand::MML_FXSEND_A )
        .AddArg( SmartPtr<u8>( new u8( "variable number", 0, VAR_NUM_MAX) ) )
        ;

    //-----------------------------------------------------------------------------
    //
    parser.mCommandTable[ "fxsend_b" ]
        .AddCode( MmlCommand::MML_FXSEND_B )
        .AddArg( SmartPtr<u8>( new u8( "fxsend", 0, 127) ) )
        ;
    parser.mCommandTable[ "fxsend_b_r" ]
        .AddCode( MmlCommand::MML_RANDOM )
        .AddCode( MmlCommand::MML_FXSEND_B )
        .AddArg( SmartPtr<s16>( new s16( "fxsend min", 0, 127) ) )
        .AddArg( SmartPtr<s16>( new s16( "fxsend max", 0, 127) ) )
        ;
    parser.mCommandTable[ "fxsend_b_v" ]
        .AddCode( MmlCommand::MML_VARIABLE )
        .AddCode( MmlCommand::MML_FXSEND_B )
        .AddArg( SmartPtr<u8>( new u8( "variable number", 0, VAR_NUM_MAX) ) )
        ;

    //-----------------------------------------------------------------------------
    //
    parser.mCommandTable[ "fxsend_c" ]
        .AddCode( MmlCommand::MML_FXSEND_C )
        .AddArg( SmartPtr<u8>( new u8( "fxsend", 0, 127) ) )
        ;
    parser.mCommandTable[ "fxsend_c_r" ]
        .AddCode( MmlCommand::MML_RANDOM )
        .AddCode( MmlCommand::MML_FXSEND_C )
        .AddArg( SmartPtr<s16>( new s16( "fxsend min", 0, 127) ) )
        .AddArg( SmartPtr<s16>( new s16( "fxsend max", 0, 127) ) )
        ;
    parser.mCommandTable[ "fxsend_c_v" ]
        .AddCode( MmlCommand::MML_VARIABLE )
        .AddCode( MmlCommand::MML_FXSEND_C )
        .AddArg( SmartPtr<u8>( new u8( "variable number", 0, VAR_NUM_MAX) ) )
        ;

    //-----------------------------------------------------------------------------
    //
    parser.mCommandTable[ "mainsend" ]
        .AddCode( MmlCommand::MML_MAINSEND )
        .AddArg( SmartPtr<u8>( new u8( "mainbus send", 0, 127) ) )
        ;
    parser.mCommandTable[ "mainsend_r" ]
        .AddCode( MmlCommand::MML_RANDOM )
        .AddCode( MmlCommand::MML_MAINSEND )
        .AddArg( SmartPtr<s16>( new s16( "mainbus send min", 0, 127) ) )
        .AddArg( SmartPtr<s16>( new s16( "mainbus send max", 0, 127) ) )
        ;
    parser.mCommandTable[ "mainsend_v" ]
        .AddCode( MmlCommand::MML_VARIABLE )
        .AddCode( MmlCommand::MML_MAINSEND )
        .AddArg( SmartPtr<u8>( new u8( "variable number", 0, VAR_NUM_MAX) ) )
        ;

    //-----------------------------------------------------------------------------
    //
    parser.mCommandTable[ "printvar" ]
        .AddCode( MmlCommand::MML_PRINTVAR )
        .AddArg( SmartPtr<u8>( new u8( "variable number", 0, VAR_NUM_MAX) ) )
        ;

    //-----------------------------------------------------------------------------
    //
    parser.mCommandTable[ "loop_start" ]
        .AddCode( MmlCommand::MML_LOOP_START )
        .AddArg( SmartPtr<u8>( new u8( "loop count", 0, 255) ) )
        ;

    parser.mCommandTable[ "loop_start_r" ]
        .AddCode( MmlCommand::MML_RANDOM )
        .AddCode( MmlCommand::MML_LOOP_START )
        .AddArg( SmartPtr<s16>( new s16( "loop count min", 0, 255) ) )
        .AddArg( SmartPtr<s16>( new s16( "loop count max", 0, 255) ) )
        ;
    parser.mCommandTable[ "loop_start_v" ]
        .AddCode( MmlCommand::MML_VARIABLE )
        .AddCode( MmlCommand::MML_LOOP_START )
        .AddArg( SmartPtr<u8>( new u8( "variable number", 0, VAR_NUM_MAX) ) )
        ;


    //-----------------------------------------------------------------------------
    //
    parser.mCommandTable[ "jump" ]
        .AddCode( MmlCommand::MML_JUMP )
        .AddArg( SmartPtr<u24>( new u24( "jump label", 0, 0xffffff) ) )
        ;

    //-----------------------------------------------------------------------------
    //
    parser.mCommandTable[ "call" ]
        .AddCode( MmlCommand::MML_CALL )
        .AddArg( SmartPtr<u24>( new u24( "call label", 0, 0xffffff) ) )
        ;

    //-----------------------------------------------------------------------------
    //
    parser.mCommandTable[ "tempo" ]
        .AddCode( MmlCommand::MML_TEMPO )
        .AddArg( SmartPtr<s16>( new s16( "tempo", 0, 1023) ) )
        ;

    parser.mCommandTable[ "tempo_r" ]
        .AddCode( MmlCommand::MML_RANDOM )
        .AddCode( MmlCommand::MML_TEMPO )
        .AddArg( SmartPtr<s16>( new s16( "tempo min", 0, 1023) ) )
        .AddArg( SmartPtr<s16>( new s16( "tempo max", 0, 1023) ) )
        ;
    parser.mCommandTable[ "tempo_v" ]
        .AddCode( MmlCommand::MML_VARIABLE )
        .AddCode( MmlCommand::MML_TEMPO )
        .AddArg( SmartPtr<u8>( new u8( "variable number", 0, VAR_NUM_MAX) ) )
        ;


    //-----------------------------------------------------------------------------
    //
    parser.mCommandTable[ "timebase" ]
        .AddCode( MmlCommand::MML_TIMEBASE )
        .AddArg( SmartPtr<u8>( new u8( "timebase", 1, 255) ) )
        ;


    //-----------------------------------------------------------------------------
    //
    parser.mCommandTable[ "opentrack" ]
        .AddCode( MmlCommand::MML_OPEN_TRACK )
        .AddArg( SmartPtr<u8>( new u8( "track number", 0, 15) ) )
        .AddArg( SmartPtr<u24>( new u24( "track sequence label", 0, 0xffffff) ) )
        ;

    //-----------------------------------------------------------------------------
    //
    parser.mCommandTable[ "porta_on" ]
        .AddCode( MmlCommand::MML_PORTA_SW )
        .AddCode( 1 )
        ;

    //-----------------------------------------------------------------------------
    //
    parser.mCommandTable[ "porta_off" ]
        .AddCode( MmlCommand::MML_PORTA_SW )
        .AddCode( 0 )
        ;

    //-----------------------------------------------------------------------------
    //
    parser.mCommandTable[ "loop_end" ]
        .AddCode( MmlCommand::MML_LOOP_END )
        ;

    //-----------------------------------------------------------------------------
    //
    parser.mCommandTable[ "ret" ]
        .AddCode( MmlCommand::MML_RET )
        ;

    //-----------------------------------------------------------------------------
    //
    parser.mCommandTable[ "fin" ]
        .AddCode( MmlCommand::MML_FIN )
        ;

    //-----------------------------------------------------------------------------
    //
    parser.mCommandTable[ "alloctrack" ]
        .AddCode( MmlCommand::MML_ALLOC_TRACK )
        .AddArg( SmartPtr<u16>( new u16( "track mask", 0, 0xffff) ) )
        ;

    //-----------------------------------------------------------------------------
    //
    parser.mCommandTable[ "userproc" ]
        .AddCode( MmlCommand::MML_EX_COMMAND )
        .AddCode( MmlCommand::MML_USERPROC )
        .AddArg( SmartPtr<u16>( new u16( "proc id", 0, 65535) ) )
        ;

    parser.mCommandTable[ "userproc_r" ]
        .AddCode( MmlCommand::MML_RANDOM )
        .AddCode( MmlCommand::MML_EX_COMMAND )
        .AddCode( MmlCommand::MML_USERPROC )
        .AddArg( SmartPtr<u16>( new u16( "proc id min", 0, 65535) ) )
        .AddArg( SmartPtr<u16>( new u16( "proc id max", 0, 65535) ) )
        ;

    parser.mCommandTable[ "userproc_v" ]
        .AddCode( MmlCommand::MML_VARIABLE )
        .AddCode( MmlCommand::MML_EX_COMMAND )
        .AddCode( MmlCommand::MML_USERPROC )
        .AddArg( SmartPtr<u8>( new u8( "variable number", 0, VAR_NUM_MAX) ) )
        ;

    //-----------------------------------------------------------------------------
    //
    parser.mCommandTable[ "setvar" ]
        .AddCode( MmlCommand::MML_EX_COMMAND )
        .AddCode( MmlCommand::MML_SETVAR )
        .AddArg( SmartPtr<u8>( new u8( "variable number", 0, VAR_NUM_MAX) ) )
        .AddArg( SmartPtr<s16>( new s16( "variable", -32768, 32767) ) )
        ;

    parser.mCommandTable[ "setvar_v" ]
        .AddCode( MmlCommand::MML_VARIABLE )
        .AddCode( MmlCommand::MML_EX_COMMAND )
        .AddCode( MmlCommand::MML_SETVAR )
        .AddArg( SmartPtr<u8>( new u8( "variable number", 0, VAR_NUM_MAX) ) )
        .AddArg( SmartPtr<u8>( new u8( "variable number", 0, VAR_NUM_MAX) ) )
        ;

    parser.mCommandTable[ "setvar_r" ]
        .AddCode( MmlCommand::MML_RANDOM )
        .AddCode( MmlCommand::MML_EX_COMMAND )
        .AddCode( MmlCommand::MML_SETVAR )
        .AddArg( SmartPtr<u8>( new u8( "variable number", 0, VAR_NUM_MAX) ) )
        .AddArg( SmartPtr<s16>( new s16( "variable min", -32768, 32767) ) )
        .AddArg( SmartPtr<s16>( new s16( "variable max", -32768, 32767) ) )
        ;

    //-----------------------------------------------------------------------------
    //
    parser.mCommandTable[ "addvar" ]
        .AddCode( MmlCommand::MML_EX_COMMAND )
        .AddCode( MmlCommand::MML_ADDVAR )
        .AddArg( SmartPtr<u8>( new u8( "variable number", 0, VAR_NUM_MAX) ) )
        .AddArg( SmartPtr<s16>( new s16( "variable", -32768, 32767) ) )
        ;

    parser.mCommandTable[ "addvar_v" ]
        .AddCode( MmlCommand::MML_VARIABLE )
        .AddCode( MmlCommand::MML_EX_COMMAND )
        .AddCode( MmlCommand::MML_ADDVAR )
        .AddArg( SmartPtr<u8>( new u8( "variable number", 0, VAR_NUM_MAX) ) )
        .AddArg( SmartPtr<u8>( new u8( "variable number", 0, VAR_NUM_MAX) ) )
        ;

    parser.mCommandTable[ "addvar_r" ]
        .AddCode( MmlCommand::MML_RANDOM )
        .AddCode( MmlCommand::MML_EX_COMMAND )
        .AddCode( MmlCommand::MML_ADDVAR )
        .AddArg( SmartPtr<u8>( new u8( "variable number", 0, VAR_NUM_MAX) ) )
        .AddArg( SmartPtr<s16>( new s16( "variable min", -32768, 32767) ) )
        .AddArg( SmartPtr<s16>( new s16( "variable max", -32768, 32767) ) )
        ;

    //-----------------------------------------------------------------------------
    //
    parser.mCommandTable[ "subvar" ]
        .AddCode( MmlCommand::MML_EX_COMMAND )
        .AddCode( MmlCommand::MML_SUBVAR )
        .AddArg( SmartPtr<u8>( new u8( "variable number", 0, VAR_NUM_MAX) ) )
        .AddArg( SmartPtr<s16>( new s16( "variable", -32768, 32767) ) )
        ;

    parser.mCommandTable[ "subvar_v" ]
        .AddCode( MmlCommand::MML_VARIABLE )
        .AddCode( MmlCommand::MML_EX_COMMAND )
        .AddCode( MmlCommand::MML_SUBVAR )
        .AddArg( SmartPtr<u8>( new u8( "variable number", 0, VAR_NUM_MAX) ) )
        .AddArg( SmartPtr<u8>( new u8( "variable number", 0, VAR_NUM_MAX) ) )
        ;

    parser.mCommandTable[ "subvar_r" ]
        .AddCode( MmlCommand::MML_RANDOM )
        .AddCode( MmlCommand::MML_EX_COMMAND )
        .AddCode( MmlCommand::MML_SUBVAR )
        .AddArg( SmartPtr<u8>( new u8( "variable number", 0, VAR_NUM_MAX) ) )
        .AddArg( SmartPtr<s16>( new s16( "variable min", -32768, 32767) ) )
        .AddArg( SmartPtr<s16>( new s16( "variable max", -32768, 32767) ) )
        ;

    //-----------------------------------------------------------------------------
    //
    parser.mCommandTable[ "mulvar" ]
        .AddCode( MmlCommand::MML_EX_COMMAND )
        .AddCode( MmlCommand::MML_MULVAR )
        .AddArg( SmartPtr<u8>( new u8( "variable number", 0, VAR_NUM_MAX) ) )
        .AddArg( SmartPtr<s16>( new s16( "variable", -32768, 32767) ) )
        ;

    parser.mCommandTable[ "mulvar_v" ]
        .AddCode( MmlCommand::MML_VARIABLE )
        .AddCode( MmlCommand::MML_EX_COMMAND )
        .AddCode( MmlCommand::MML_MULVAR )
        .AddArg( SmartPtr<u8>( new u8( "variable number", 0, VAR_NUM_MAX) ) )
        .AddArg( SmartPtr<u8>( new u8( "variable number", 0, VAR_NUM_MAX) ) )
        ;

    parser.mCommandTable[ "mulvar_r" ]
        .AddCode( MmlCommand::MML_RANDOM )
        .AddCode( MmlCommand::MML_EX_COMMAND )
        .AddCode( MmlCommand::MML_MULVAR )
        .AddArg( SmartPtr<u8>( new u8( "variable number", 0, VAR_NUM_MAX) ) )
        .AddArg( SmartPtr<s16>( new s16( "variable min", -32768, 32767) ) )
        .AddArg( SmartPtr<s16>( new s16( "variable max", -32768, 32767) ) )
        ;

    //-----------------------------------------------------------------------------
    //
    parser.mCommandTable[ "divvar" ]
        .AddCode( MmlCommand::MML_EX_COMMAND )
        .AddCode( MmlCommand::MML_DIVVAR )
        .AddArg( SmartPtr<u8>( new u8( "variable number", 0, VAR_NUM_MAX) ) )
        .AddArg( SmartPtr<s16>( new s16( "variable", -32768, 32767) ) )
        ;

    parser.mCommandTable[ "divvar_v" ]
        .AddCode( MmlCommand::MML_VARIABLE )
        .AddCode( MmlCommand::MML_EX_COMMAND )
        .AddCode( MmlCommand::MML_DIVVAR )
        .AddArg( SmartPtr<u8>( new u8( "variable number", 0, VAR_NUM_MAX) ) )
        .AddArg( SmartPtr<u8>( new u8( "variable number", 0, VAR_NUM_MAX) ) )
        ;

    parser.mCommandTable[ "divvar_r" ]
        .AddCode( MmlCommand::MML_RANDOM )
        .AddCode( MmlCommand::MML_EX_COMMAND )
        .AddCode( MmlCommand::MML_DIVVAR )
        .AddArg( SmartPtr<u8>( new u8( "variable number", 0, VAR_NUM_MAX) ) )
        .AddArg( SmartPtr<s16>( new s16( "variable min", -32768, 32767) ) )
        .AddArg( SmartPtr<s16>( new s16( "variable max", -32768, 32767) ) )
        ;

    //-----------------------------------------------------------------------------
    //
    parser.mCommandTable[ "shiftvar" ]
        .AddCode( MmlCommand::MML_EX_COMMAND )
        .AddCode( MmlCommand::MML_SHIFTVAR )
        .AddArg( SmartPtr<u8>( new u8( "variable number", 0, VAR_NUM_MAX) ) )
        .AddArg( SmartPtr<s16>( new s16( "variable", -32768, 32767) ) )
        ;

    parser.mCommandTable[ "shiftvar_v" ]
        .AddCode( MmlCommand::MML_VARIABLE )
        .AddCode( MmlCommand::MML_EX_COMMAND )
        .AddCode( MmlCommand::MML_SHIFTVAR )
        .AddArg( SmartPtr<u8>( new u8( "variable number", 0, VAR_NUM_MAX) ) )
        .AddArg( SmartPtr<u8>( new u8( "variable number", 0, VAR_NUM_MAX) ) )
        ;

    parser.mCommandTable[ "shiftvar_r" ]
        .AddCode( MmlCommand::MML_RANDOM )
        .AddCode( MmlCommand::MML_EX_COMMAND )
        .AddCode( MmlCommand::MML_SHIFTVAR )
        .AddArg( SmartPtr<u8>( new u8( "variable number", 0, VAR_NUM_MAX) ) )
        .AddArg( SmartPtr<s16>( new s16( "variable min", -32768, 32767) ) )
        .AddArg( SmartPtr<s16>( new s16( "variable max", -32768, 32767) ) )
        ;

    //-----------------------------------------------------------------------------
    //
    parser.mCommandTable[ "randvar" ]
        .AddCode( MmlCommand::MML_EX_COMMAND )
        .AddCode( MmlCommand::MML_RANDVAR )
        .AddArg( SmartPtr<u8>( new u8( "variable number", 0, VAR_NUM_MAX) ) )
        .AddArg( SmartPtr<s16>( new s16( "variable", -32768, 32767) ) )
        ;

    parser.mCommandTable[ "randvar_v" ]
        .AddCode( MmlCommand::MML_VARIABLE )
        .AddCode( MmlCommand::MML_EX_COMMAND )
        .AddCode( MmlCommand::MML_RANDVAR )
        .AddArg( SmartPtr<u8>( new u8( "variable number", 0, VAR_NUM_MAX) ) )
        .AddArg( SmartPtr<u8>( new u8( "variable number", 0, VAR_NUM_MAX) ) )
        ;

    parser.mCommandTable[ "randvar_r" ]
        .AddCode( MmlCommand::MML_RANDOM )
        .AddCode( MmlCommand::MML_EX_COMMAND )
        .AddCode( MmlCommand::MML_RANDVAR )
        .AddArg( SmartPtr<u8>( new u8( "variable number", 0, VAR_NUM_MAX) ) )
        .AddArg( SmartPtr<s16>( new s16( "variable min", -32768, 32767) ) )
        .AddArg( SmartPtr<s16>( new s16( "variable max", -32768, 32767) ) )
        ;

    //-----------------------------------------------------------------------------
    //
    parser.mCommandTable[ "andvar" ]
        .AddCode( MmlCommand::MML_EX_COMMAND )
        .AddCode( MmlCommand::MML_ANDVAR )
        .AddArg( SmartPtr<u8>( new u8( "variable number", 0, VAR_NUM_MAX) ) )
        .AddArg( SmartPtr<s16>( new s16( "variable", -32768, 32767) ) )
        ;

    parser.mCommandTable[ "andvar_v" ]
        .AddCode( MmlCommand::MML_VARIABLE )
        .AddCode( MmlCommand::MML_EX_COMMAND )
        .AddCode( MmlCommand::MML_ANDVAR )
        .AddArg( SmartPtr<u8>( new u8( "variable number", 0, VAR_NUM_MAX) ) )
        .AddArg( SmartPtr<u8>( new u8( "variable number", 0, VAR_NUM_MAX) ) )
        ;

    parser.mCommandTable[ "andvar_r" ]
        .AddCode( MmlCommand::MML_RANDOM )
        .AddCode( MmlCommand::MML_EX_COMMAND )
        .AddCode( MmlCommand::MML_ANDVAR )
        .AddArg( SmartPtr<u8>( new u8( "variable number", 0, VAR_NUM_MAX) ) )
        .AddArg( SmartPtr<s16>( new s16( "variable min", -32768, 32767) ) )
        .AddArg( SmartPtr<s16>( new s16( "variable max", -32768, 32767) ) )
        ;

    //-----------------------------------------------------------------------------
    //
    parser.mCommandTable[ "orvar" ]
        .AddCode( MmlCommand::MML_EX_COMMAND )
        .AddCode( MmlCommand::MML_ORVAR )
        .AddArg( SmartPtr<u8>( new u8( "variable number", 0, VAR_NUM_MAX) ) )
        .AddArg( SmartPtr<s16>( new s16( "variable", -32768, 32767) ) )
        ;

    parser.mCommandTable[ "orvar_v" ]
        .AddCode( MmlCommand::MML_VARIABLE )
        .AddCode( MmlCommand::MML_EX_COMMAND )
        .AddCode( MmlCommand::MML_ORVAR )
        .AddArg( SmartPtr<u8>( new u8( "variable number", 0, VAR_NUM_MAX) ) )
        .AddArg( SmartPtr<u8>( new u8( "variable number", 0, VAR_NUM_MAX) ) )
        ;

    parser.mCommandTable[ "orvar_r" ]
        .AddCode( MmlCommand::MML_RANDOM )
        .AddCode( MmlCommand::MML_EX_COMMAND )
        .AddCode( MmlCommand::MML_ORVAR )
        .AddArg( SmartPtr<u8>( new u8( "variable number", 0, VAR_NUM_MAX) ) )
        .AddArg( SmartPtr<s16>( new s16( "variable min", -32768, 32767) ) )
        .AddArg( SmartPtr<s16>( new s16( "variable max", -32768, 32767) ) )
        ;

    //-----------------------------------------------------------------------------
    //
    parser.mCommandTable[ "xorvar" ]
        .AddCode( MmlCommand::MML_EX_COMMAND )
        .AddCode( MmlCommand::MML_XORVAR )
        .AddArg( SmartPtr<u8>( new u8( "variable number", 0, VAR_NUM_MAX) ) )
        .AddArg( SmartPtr<s16>( new s16( "variable", -32768, 32767) ) )
        ;

    parser.mCommandTable[ "xorvar_v" ]
        .AddCode( MmlCommand::MML_VARIABLE )
        .AddCode( MmlCommand::MML_EX_COMMAND )
        .AddCode( MmlCommand::MML_XORVAR )
        .AddArg( SmartPtr<u8>( new u8( "variable number", 0, VAR_NUM_MAX) ) )
        .AddArg( SmartPtr<u8>( new u8( "variable number", 0, VAR_NUM_MAX) ) )
        ;

    parser.mCommandTable[ "xorvar_r" ]
        .AddCode( MmlCommand::MML_RANDOM )
        .AddCode( MmlCommand::MML_EX_COMMAND )
        .AddCode( MmlCommand::MML_XORVAR )
        .AddArg( SmartPtr<u8>( new u8( "variable number", 0, VAR_NUM_MAX) ) )
        .AddArg( SmartPtr<s16>( new s16( "variable min", -32768, 32767) ) )
        .AddArg( SmartPtr<s16>( new s16( "variable max", -32768, 32767) ) )
        ;

    //-----------------------------------------------------------------------------
    //
    parser.mCommandTable[ "notvar" ]
        .AddCode( MmlCommand::MML_EX_COMMAND )
        .AddCode( MmlCommand::MML_NOTVAR )
        .AddArg( SmartPtr<u8>( new u8( "variable number", 0, VAR_NUM_MAX) ) )
        .AddArg( SmartPtr<s16>( new s16( "variable", -32768, 32767) ) )
        ;

    parser.mCommandTable[ "notvar_v" ]
        .AddCode( MmlCommand::MML_VARIABLE )
        .AddCode( MmlCommand::MML_EX_COMMAND )
        .AddCode( MmlCommand::MML_NOTVAR )
        .AddArg( SmartPtr<u8>( new u8( "variable number", 0, VAR_NUM_MAX) ) )
        .AddArg( SmartPtr<u8>( new u8( "variable number", 0, VAR_NUM_MAX) ) )
        ;

    parser.mCommandTable[ "notvar_r" ]
        .AddCode( MmlCommand::MML_RANDOM )
        .AddCode( MmlCommand::MML_EX_COMMAND )
        .AddCode( MmlCommand::MML_NOTVAR )
        .AddArg( SmartPtr<u8>( new u8( "variable number", 0, VAR_NUM_MAX) ) )
        .AddArg( SmartPtr<s16>( new s16( "variable min", -32768, 32767) ) )
        .AddArg( SmartPtr<s16>( new s16( "variable max", -32768, 32767) ) )
        ;

    //-----------------------------------------------------------------------------
    //
    parser.mCommandTable[ "modvar" ]
        .AddCode( MmlCommand::MML_EX_COMMAND )
        .AddCode( MmlCommand::MML_MODVAR )
        .AddArg( SmartPtr<u8>( new u8( "variable number", 0, VAR_NUM_MAX) ) )
        .AddArg( SmartPtr<s16>( new s16( "variable", -32768, 32767) ) )
        ;

    parser.mCommandTable[ "modvar_v" ]
        .AddCode( MmlCommand::MML_VARIABLE )
        .AddCode( MmlCommand::MML_EX_COMMAND )
        .AddCode( MmlCommand::MML_MODVAR )
        .AddArg( SmartPtr<u8>( new u8( "variable number", 0, VAR_NUM_MAX) ) )
        .AddArg( SmartPtr<u8>( new u8( "variable number", 0, VAR_NUM_MAX) ) )
        ;

    parser.mCommandTable[ "modvar_r" ]
        .AddCode( MmlCommand::MML_RANDOM )
        .AddCode( MmlCommand::MML_EX_COMMAND )
        .AddCode( MmlCommand::MML_MODVAR )
        .AddArg( SmartPtr<u8>( new u8( "variable number", 0, VAR_NUM_MAX) ) )
        .AddArg( SmartPtr<s16>( new s16( "variable min", -32768, 32767) ) )
        .AddArg( SmartPtr<s16>( new s16( "variable max", -32768, 32767) ) )
        ;

    //-----------------------------------------------------------------------------
    //
    parser.mCommandTable[ "cmp_eq" ]
        .AddCode( MmlCommand::MML_EX_COMMAND )
        .AddCode( MmlCommand::MML_CMP_EQ )
        .AddArg( SmartPtr<u8>( new u8( "variable number", 0, VAR_NUM_MAX) ) )
        .AddArg( SmartPtr<s16>( new s16( "variable", -32768, 32767) ) )
        ;

    parser.mCommandTable[ "cmp_eq_v" ]
        .AddCode( MmlCommand::MML_VARIABLE )
        .AddCode( MmlCommand::MML_EX_COMMAND )
        .AddCode( MmlCommand::MML_CMP_EQ )
        .AddArg( SmartPtr<u8>( new u8( "variable number", 0, VAR_NUM_MAX) ) )
        .AddArg( SmartPtr<u8>( new u8( "variable number", 0, VAR_NUM_MAX) ) )
        ;

    parser.mCommandTable[ "cmp_eq_r" ]
        .AddCode( MmlCommand::MML_RANDOM )
        .AddCode( MmlCommand::MML_EX_COMMAND )
        .AddCode( MmlCommand::MML_CMP_EQ )
        .AddArg( SmartPtr<u8>( new u8( "variable number", 0, VAR_NUM_MAX) ) )
        .AddArg( SmartPtr<s16>( new s16( "variable min", -32768, 32767) ) )
        .AddArg( SmartPtr<s16>( new s16( "variable max", -32768, 32767) ) )
        ;


    //-----------------------------------------------------------------------------
    //
    parser.mCommandTable[ "cmp_ge" ]
        .AddCode( MmlCommand::MML_EX_COMMAND )
        .AddCode( MmlCommand::MML_CMP_GE )
        .AddArg( SmartPtr<u8>( new u8( "variable number", 0, VAR_NUM_MAX) ) )
        .AddArg( SmartPtr<s16>( new s16( "variable", -32768, 32767) ) )
        ;

    parser.mCommandTable[ "cmp_ge_v" ]
        .AddCode( MmlCommand::MML_VARIABLE )
        .AddCode( MmlCommand::MML_EX_COMMAND )
        .AddCode( MmlCommand::MML_CMP_GE )
        .AddArg( SmartPtr<u8>( new u8( "variable number", 0, VAR_NUM_MAX) ) )
        .AddArg( SmartPtr<u8>( new u8( "variable number", 0, VAR_NUM_MAX) ) )
        ;

    parser.mCommandTable[ "cmp_ge_r" ]
        .AddCode( MmlCommand::MML_RANDOM )
        .AddCode( MmlCommand::MML_EX_COMMAND )
        .AddCode( MmlCommand::MML_CMP_GE )
        .AddArg( SmartPtr<u8>( new u8( "variable number", 0, VAR_NUM_MAX) ) )
        .AddArg( SmartPtr<s16>( new s16( "variable min", -32768, 32767) ) )
        .AddArg( SmartPtr<s16>( new s16( "variable max", -32768, 32767) ) )
        ;


    //-----------------------------------------------------------------------------
    //
    parser.mCommandTable[ "cmp_gt" ]
        .AddCode( MmlCommand::MML_EX_COMMAND )
        .AddCode( MmlCommand::MML_CMP_GT )
        .AddArg( SmartPtr<u8>( new u8( "variable number", 0, VAR_NUM_MAX) ) )
        .AddArg( SmartPtr<s16>( new s16( "variable", -32768, 32767) ) )
        ;

    parser.mCommandTable[ "cmp_gt_v" ]
        .AddCode( MmlCommand::MML_VARIABLE )
        .AddCode( MmlCommand::MML_EX_COMMAND )
        .AddCode( MmlCommand::MML_CMP_GT )
        .AddArg( SmartPtr<u8>( new u8( "variable number", 0, VAR_NUM_MAX) ) )
        .AddArg( SmartPtr<u8>( new u8( "variable number", 0, VAR_NUM_MAX) ) )
        ;

    parser.mCommandTable[ "cmp_gt_r" ]
        .AddCode( MmlCommand::MML_RANDOM )
        .AddCode( MmlCommand::MML_EX_COMMAND )
        .AddCode( MmlCommand::MML_CMP_GT )
        .AddArg( SmartPtr<u8>( new u8( "variable number", 0, VAR_NUM_MAX) ) )
        .AddArg( SmartPtr<s16>( new s16( "variable min", -32768, 32767) ) )
        .AddArg( SmartPtr<s16>( new s16( "variable max", -32768, 32767) ) )
        ;


    //-----------------------------------------------------------------------------
    //
    parser.mCommandTable[ "cmp_le" ]
        .AddCode( MmlCommand::MML_EX_COMMAND )
        .AddCode( MmlCommand::MML_CMP_LE )
        .AddArg( SmartPtr<u8>( new u8( "variable number", 0, VAR_NUM_MAX) ) )
        .AddArg( SmartPtr<s16>( new s16( "variable", -32768, 32767) ) )
        ;

    parser.mCommandTable[ "cmp_le_v" ]
        .AddCode( MmlCommand::MML_VARIABLE )
        .AddCode( MmlCommand::MML_EX_COMMAND )
        .AddCode( MmlCommand::MML_CMP_LE )
        .AddArg( SmartPtr<u8>( new u8( "variable number", 0, VAR_NUM_MAX) ) )
        .AddArg( SmartPtr<u8>( new u8( "variable number", 0, VAR_NUM_MAX) ) )
        ;

    parser.mCommandTable[ "cmp_le_r" ]
        .AddCode( MmlCommand::MML_RANDOM )
        .AddCode( MmlCommand::MML_EX_COMMAND )
        .AddCode( MmlCommand::MML_CMP_LE )
        .AddArg( SmartPtr<u8>( new u8( "variable number", 0, VAR_NUM_MAX) ) )
        .AddArg( SmartPtr<s16>( new s16( "variable min", -32768, 32767) ) )
        .AddArg( SmartPtr<s16>( new s16( "variable max", -32768, 32767) ) )
        ;


    //-----------------------------------------------------------------------------
    //
    parser.mCommandTable[ "cmp_lt" ]
        .AddCode( MmlCommand::MML_EX_COMMAND )
        .AddCode( MmlCommand::MML_CMP_LT )
        .AddArg( SmartPtr<u8>( new u8( "variable number", 0, VAR_NUM_MAX) ) )
        .AddArg( SmartPtr<s16>( new s16( "variable", -32768, 32767) ) )
        ;

    parser.mCommandTable[ "cmp_lt_v" ]
        .AddCode( MmlCommand::MML_VARIABLE )
        .AddCode( MmlCommand::MML_EX_COMMAND )
        .AddCode( MmlCommand::MML_CMP_LT )
        .AddArg( SmartPtr<u8>( new u8( "variable number", 0, VAR_NUM_MAX) ) )
        .AddArg( SmartPtr<u8>( new u8( "variable number", 0, VAR_NUM_MAX) ) )
        ;

    parser.mCommandTable[ "cmp_lt_r" ]
        .AddCode( MmlCommand::MML_RANDOM )
        .AddCode( MmlCommand::MML_EX_COMMAND )
        .AddCode( MmlCommand::MML_CMP_LT )
        .AddArg( SmartPtr<u8>( new u8( "variable number", 0, VAR_NUM_MAX) ) )
        .AddArg( SmartPtr<s16>( new s16( "variable min", -32768, 32767) ) )
        .AddArg( SmartPtr<s16>( new s16( "variable max", -32768, 32767) ) )
        ;


    //-----------------------------------------------------------------------------
    //
    parser.mCommandTable[ "cmp_ne" ]
        .AddCode( MmlCommand::MML_EX_COMMAND )
        .AddCode( MmlCommand::MML_CMP_NE )
        .AddArg( SmartPtr<u8>( new u8( "variable number", 0, VAR_NUM_MAX) ) )
        .AddArg( SmartPtr<s16>( new s16( "variable", -32768, 32767) ) )
        ;

    parser.mCommandTable[ "cmp_ne_v" ]
        .AddCode( MmlCommand::MML_VARIABLE )
        .AddCode( MmlCommand::MML_EX_COMMAND )
        .AddCode( MmlCommand::MML_CMP_NE )
        .AddArg( SmartPtr<u8>( new u8( "variable number", 0, VAR_NUM_MAX) ) )
        .AddArg( SmartPtr<u8>( new u8( "variable number", 0, VAR_NUM_MAX) ) )
        ;

    parser.mCommandTable[ "cmp_ne_r" ]
        .AddCode( MmlCommand::MML_RANDOM )
        .AddCode( MmlCommand::MML_EX_COMMAND )
        .AddCode( MmlCommand::MML_CMP_NE )
        .AddArg( SmartPtr<u8>( new u8( "variable number", 0, VAR_NUM_MAX) ) )
        .AddArg( SmartPtr<s16>( new s16( "variable min", -32768, 32767) ) )
        .AddArg( SmartPtr<s16>( new s16( "variable max", -32768, 32767) ) )
        ;



    static const char keyChar[]   = "cdefgab";
    static char keyString[10];
    static char octString[10];

    for( int oct = -1 ; oct < 10 ; oct++ )
    {
        if ( oct < 0 ) {
            octString[0] = 'm';
            octString[1] = '1';
            octString[2] = '\0';
        }
        else {
            sprintf(octString, "%d", oct);
        }

        while( 1 )
        {
            int k;
            for( int key = 0 ; key < 7 ; key++ )
            {
                sprintf( keyString, "%cf%s", keyChar[key], octString );
                if ( lexer::ParseKeyString( keyString, k ) && ( 0 <= k && k <= 127 ) ) {
                    parser.mSymbolTable[ keyString ] = k;

                    keyString[0] = toupper( keyString[0] ) ;
                    parser.mSymbolTable[ keyString ] = k;

                    keyString[1] = toupper( keyString[1] ) ;
                    parser.mSymbolTable[ keyString ] = k;

                    keyString[0] = tolower( keyString[0] ) ;
                    parser.mSymbolTable[ keyString ] = k;
                }

                sprintf( keyString, "%cb%s", keyChar[key], octString );
                if ( lexer::ParseKeyString( keyString, k ) && ( 0 <= k && k <= 127 ) ) {
                    parser.mSymbolTable[ keyString ] = k;

                    keyString[0] = toupper( keyString[0] ) ;
                    parser.mSymbolTable[ keyString ] = k;

                    keyString[1] = toupper( keyString[1] ) ;
                    parser.mSymbolTable[ keyString ] = k;

                    keyString[0] = tolower( keyString[0] ) ;
                    parser.mSymbolTable[ keyString ] = k;
                }

                sprintf( keyString, "%c%s", keyChar[key], octString );
                if ( lexer::ParseKeyString( keyString, k ) && ( 0 <= k && k <= 127 ) ) {
                    parser.mSymbolTable[ keyString ] = k;

                    keyString[0] = toupper( keyString[0] ) ;
                    parser.mSymbolTable[ keyString ] = k;
                }

                sprintf( keyString, "%cn%s", keyChar[key], octString );
                if ( lexer::ParseKeyString( keyString, k ) && ( 0 <= k && k <= 127 ) ) {
                    parser.mSymbolTable[ keyString ] = k;

                    keyString[0] = toupper( keyString[0] ) ;
                    parser.mSymbolTable[ keyString ] = k;

                    keyString[1] = toupper( keyString[1] ) ;
                    parser.mSymbolTable[ keyString ] = k;

                    keyString[0] = tolower( keyString[0] ) ;
                    parser.mSymbolTable[ keyString ] = k;
                }

                sprintf( keyString, "%cs%s", keyChar[key], octString );
                if ( lexer::ParseKeyString( keyString, k ) && ( 0 <= k && k <= 127 ) ) {
                    parser.mSymbolTable[ keyString ] = k;

                    keyString[0] = toupper( keyString[0] ) ;
                    parser.mSymbolTable[ keyString ] = k;

                    keyString[1] = toupper( keyString[1] ) ;
                    parser.mSymbolTable[ keyString ] = k;

                    keyString[0] = tolower( keyString[0] ) ;
                    parser.mSymbolTable[ keyString ] = k;
                }
            }

            if ( octString[0] == 'm' ) {
                octString[0] = 'M';
            }
            else {
                break;
            }
        }
    }

    parser.mSymbolTable[ "MOD_TYPE_PITCH" ] = 0;
    parser.mSymbolTable[ "MOD_TYPE_VOLUME" ] = 1;
    parser.mSymbolTable[ "MOD_TYPE_PAN" ] = 2;

    parser.mSymbolTable[ "VAR_0" ]   = 0;
    parser.mSymbolTable[ "VAR_1" ]   = 1;
    parser.mSymbolTable[ "VAR_2" ]   = 2;
    parser.mSymbolTable[ "VAR_3" ]   = 3;
    parser.mSymbolTable[ "VAR_4" ]   = 4;
    parser.mSymbolTable[ "VAR_5" ]   = 5;
    parser.mSymbolTable[ "VAR_6" ]   = 6;
    parser.mSymbolTable[ "VAR_7" ]   = 7;
    parser.mSymbolTable[ "VAR_8" ]   = 8;
    parser.mSymbolTable[ "VAR_9" ]   = 9;
    parser.mSymbolTable[ "VAR_10" ]  = 10;
    parser.mSymbolTable[ "VAR_11" ]  = 11;
    parser.mSymbolTable[ "VAR_12" ]  = 12;
    parser.mSymbolTable[ "VAR_13" ]  = 13;
    parser.mSymbolTable[ "VAR_14" ]  = 14;
    parser.mSymbolTable[ "VAR_15" ]  = 15;
    parser.mSymbolTable[ "GVAR_0" ]  = 16;
    parser.mSymbolTable[ "GVAR_1" ]  = 17;
    parser.mSymbolTable[ "GVAR_2" ]  = 18;
    parser.mSymbolTable[ "GVAR_3" ]  = 19;
    parser.mSymbolTable[ "GVAR_4" ]  = 20;
    parser.mSymbolTable[ "GVAR_5" ]  = 21;
    parser.mSymbolTable[ "GVAR_6" ]  = 22;
    parser.mSymbolTable[ "GVAR_7" ]  = 23;
    parser.mSymbolTable[ "GVAR_8" ]  = 24;
    parser.mSymbolTable[ "GVAR_9" ]  = 25;
    parser.mSymbolTable[ "GVAR_10" ] = 26;
    parser.mSymbolTable[ "GVAR_11" ] = 27;
    parser.mSymbolTable[ "GVAR_12" ] = 28;
    parser.mSymbolTable[ "GVAR_13" ] = 29;
    parser.mSymbolTable[ "GVAR_14" ] = 30;
    parser.mSymbolTable[ "GVAR_15" ] = 31;
    parser.mSymbolTable[ "TVAR_0" ]  = 32;
    parser.mSymbolTable[ "TVAR_1" ]  = 33;
    parser.mSymbolTable[ "TVAR_2" ]  = 34;
    parser.mSymbolTable[ "TVAR_3" ]  = 35;
    parser.mSymbolTable[ "TVAR_4" ]  = 36;
    parser.mSymbolTable[ "TVAR_5" ]  = 37;
    parser.mSymbolTable[ "TVAR_6" ]  = 38;
    parser.mSymbolTable[ "TVAR_7" ]  = 39;
    parser.mSymbolTable[ "TVAR_8" ]  = 40;
    parser.mSymbolTable[ "TVAR_9" ]  = 41;
    parser.mSymbolTable[ "TVAR_10" ] = 42;
    parser.mSymbolTable[ "TVAR_11" ] = 43;
    parser.mSymbolTable[ "TVAR_12" ] = 44;
    parser.mSymbolTable[ "TVAR_13" ] = 45;
    parser.mSymbolTable[ "TVAR_14" ] = 46;
    parser.mSymbolTable[ "TVAR_15" ] = 47;

    static char trackString[ 256 ];
    for( int i = 1 ; i < 16 ; i++) {
        sprintf( trackString, "TRACK_%d", i );
        parser.mSymbolTable[ trackString ] = (1LL << i);
    }
}

