﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#pragma once

#include <map>

namespace sndlib
{

class Lexer;

class ExprParser
{
public:
    typedef std::map< std::string, __int64 > SymbolTable;

    explicit ExprParser( bool undefinedSymbolIsZero=false );
    ~ExprParser( );

    struct Failure {};

    // 数式をパースする
    // ただし、返った後、lexerが１つ進んでいることに注意
    __int64 Parse( Lexer& lexer,
                   const SymbolTable* symTable1 = NULL,
                   const SymbolTable* symTable2 = NULL,
                   const SymbolTable* symTable3 = NULL
                   );

private:
    static const int SYMBOL_TABLE_NUM = 3;

    template< int T >
    __int64 ParseTerm( Lexer& lexer );
    __int64 ParseSymbol( const std::string& symbol, Lexer& lexer );

    const SymbolTable* mSymbolTable[ SYMBOL_TABLE_NUM ];
    bool mUndefinedSymbolIsZero;
};

} // namespace sndlib

