﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#pragma once

#include <nw/types.h>
#include <sndlib/stream.h>

class Parser;

class Command
{
  public:
    typedef ::u8 u8;
    typedef ::s8 s8;
    typedef ::u16 u16;
    typedef ::s16 s16;
    typedef ::u32 u32;
    typedef ::s32 s32;
    struct vmidi {};
    struct u24 {};

    class Arg {
      public:
        virtual ~Arg() {} ;
        virtual void Parse( sndlib::Lexer& lexer, sndlib::strm::fstream& out, bool testFlag, Parser& parser ) = 0;
        virtual bool IsNeedArg() const { return true; }
    };

    template< typename T >
    class ArgNumber : public Arg {
      public:
        ArgNumber( const std::string& name, __int64 min, __int64 max )
        : mName( name ), mMin(min), mMax(max) {}
        virtual void Parse( sndlib::Lexer& lexer, sndlib::strm::fstream& out, bool testFlag, Parser& parser );
      private:
        std::string mName;
        __int64 mMin;
        __int64 mMax;
    };

    typedef unsigned char code_t;

    class Code : public Arg {
      public:
        Code( code_t code ) : mCode( code ) {}
        virtual void Parse( sndlib::Lexer& lexer, sndlib::strm::fstream& out, bool testFlag, Parser& parser );
        virtual bool IsNeedArg() const { return false; }
      private:
        code_t mCode;
    };

    Command() {}
    Command& AddCode( code_t code ) {
        mArgs.push_back( sndlib::SmartPtr<Arg>( new Code( code ) ) );
        return *this;
    }
    Command& AddArg( sndlib::SmartPtr<Arg> arg ) {
        mArgs.push_back( arg );
        return *this;
    }
    void Parse( sndlib::Lexer& lexer, sndlib::strm::fstream& out, bool testFlag, Parser& parser ) const;

  private:
    typedef std::vector< sndlib::SmartPtr<Arg> > ArgList;

    ArgList mArgs;
};

