﻿// --------------------------------------------------------------------------------
// <copyright>
// Copyright (C)Nintendo. All rights reserved.
//
// These coded instructions, statements, and computer programs contain proprietary
// information of Nintendo and/or its licensed developers and are protected by
// national and international copyright laws. They may not be disclosed to third
// parties or copied or duplicated in any form, in whole or in part, without the
// prior written consent of Nintendo.
//
// The content herein is highly confidential and should be handled accordingly.
// </copyright>
// --------------------------------------------------------------------------------
using System;
using System.IO;
using System.Xml;
using System.Text;
using System.Collections;

namespace NintendoWare.SoundFoundation.Legacies.FileFormat.Nw4rFileFormat
{

    public class Nw4rSoundArchivePlayerSettings
    {
        public int StrmBufferSize = 8;
        public int SeqSoundCount = 64;
        public int SeqTrackCount = 96;
        public int StrmSoundCount = 4;
        public int StrmChannelCount = 8;
        public int WaveSoundCount = 64;

        internal static Nw4rSoundArchivePlayerSettings Parse(XmlDocument doc, XmlElement rootElem)
        {
            Nw4rSoundArchivePlayerSettings param = new Nw4rSoundArchivePlayerSettings();

            XmlElement seqSoundCountElem = (XmlElement)rootElem.SelectSingleNode("seq_sound_count");
            if (seqSoundCountElem != null)
            {
                param.SeqSoundCount = Int32.Parse(seqSoundCountElem.InnerText);
            }

            XmlElement seqTrackCountElem = (XmlElement)rootElem.SelectSingleNode("seq_track_count");
            if (seqTrackCountElem != null)
            {
                param.SeqTrackCount = Int32.Parse(seqTrackCountElem.InnerText);
            }

            XmlElement strmSoundCountElem = (XmlElement)rootElem.SelectSingleNode("strm_sound_count");
            if (strmSoundCountElem != null)
            {
                param.StrmSoundCount = Int32.Parse(strmSoundCountElem.InnerText);
            }

            XmlElement strmChannelCountElem = (XmlElement)rootElem.SelectSingleNode("strm_channel_count");
            if (strmChannelCountElem != null)
            {
                param.StrmChannelCount = Int32.Parse(strmChannelCountElem.InnerText);
            }

            XmlElement waveSoundCountElem = (XmlElement)rootElem.SelectSingleNode("wave_sound_count");
            if (waveSoundCountElem != null)
            {
                param.WaveSoundCount = Int32.Parse(waveSoundCountElem.InnerText);
            }

            return param;
        }
        internal XmlElement ToXmlElement(XmlDocument doc)
        {
            XmlElement rootElem = doc.CreateElement("sound_archive_player_settings");

            XmlElement seqSoundCountElem = doc.CreateElement("seq_sound_count");
            seqSoundCountElem.InnerText = SeqSoundCount.ToString();
            rootElem.AppendChild(seqSoundCountElem);

            XmlElement seqTrackCountElem = doc.CreateElement("seq_track_count");
            seqTrackCountElem.InnerText = SeqTrackCount.ToString();
            rootElem.AppendChild(seqTrackCountElem);

            XmlElement strmSoundCountElem = doc.CreateElement("strm_sound_count");
            strmSoundCountElem.InnerText = StrmSoundCount.ToString();
            rootElem.AppendChild(strmSoundCountElem);

            XmlElement strmChannelCountElem = doc.CreateElement("strm_channel_count");
            strmChannelCountElem.InnerText = StrmChannelCount.ToString();
            rootElem.AppendChild(strmChannelCountElem);

            XmlElement waveSoundCountElem = doc.CreateElement("wave_sound_count");
            waveSoundCountElem.InnerText = WaveSoundCount.ToString();
            rootElem.AppendChild(waveSoundCountElem);

            return rootElem;
        }
    }

}
