﻿// --------------------------------------------------------------------------------
// <copyright>
// Copyright (C)Nintendo. All rights reserved.
//
// These coded instructions, statements, and computer programs contain proprietary
// information of Nintendo and/or its licensed developers and are protected by
// national and international copyright laws. They may not be disclosed to third
// parties or copied or duplicated in any form, in whole or in part, without the
// prior written consent of Nintendo.
//
// The content herein is highly confidential and should be handled accordingly.
// </copyright>
// --------------------------------------------------------------------------------
using System;
using System.IO;
using System.Text;

namespace NintendoWare.SoundFoundation.Legacies.FileFormat
{

    public class BinaryWriterBigEndian
    {
        public static BinaryWriter CreateInstance(Stream s)
        {
            if (BitConverter.IsLittleEndian) return new BinaryWriterReverseEndian(s);
            return new BinaryWriter(s);
        }
        public static BinaryWriter CreateInstance(Stream s, Encoding e)
        {
            if (BitConverter.IsLittleEndian) return new BinaryWriterReverseEndian(s, e);
            return new BinaryWriter(s, e);
        }

        // インスタンスの生成を禁止する
        private BinaryWriterBigEndian() { }
    }
    public class BinaryWriterLittleEndian
    {
        public static BinaryWriter CreateInstance(Stream s)
        {
            if (BitConverter.IsLittleEndian) return new BinaryWriter(s);
            return new BinaryWriterReverseEndian(s);
        }
        public static BinaryWriter CreateInstance(Stream s, Encoding e)
        {
            if (BitConverter.IsLittleEndian) return new BinaryWriter(s, e);
            return new BinaryWriterReverseEndian(s, e);
        }

        // インスタンスの生成を禁止する
        private BinaryWriterLittleEndian() { }
    }

    class BinaryWriterReverseEndian : BinaryWriter
    {
        public BinaryWriterReverseEndian(Stream s) : base(s) { }
        public BinaryWriterReverseEndian(Stream s, Encoding e) : base(s, e) { }

        public override void Write(short x)
        {
            byte[] bytes = BitConverter.GetBytes(x);
            Array.Reverse(bytes);
            base.Write(bytes);
        }
        public override void Write(int x)
        {
            byte[] bytes = BitConverter.GetBytes(x);
            Array.Reverse(bytes);
            base.Write(bytes);
        }
        public override void Write(long x)
        {
            byte[] bytes = BitConverter.GetBytes(x);
            Array.Reverse(bytes);
            base.Write(bytes);
        }
        public override void Write(ushort x)
        {
            byte[] bytes = BitConverter.GetBytes(x);
            Array.Reverse(bytes);
            base.Write(bytes);
        }
        public override void Write(uint x)
        {
            byte[] bytes = BitConverter.GetBytes(x);
            Array.Reverse(bytes);
            base.Write(bytes);
        }
        public override void Write(ulong x)
        {
            byte[] bytes = BitConverter.GetBytes(x);
            Array.Reverse(bytes);
            base.Write(bytes);
        }
        public override void Write(float x)
        {
            byte[] bytes = BitConverter.GetBytes(x);
            Array.Reverse(bytes);
            base.Write(bytes);
        }
    }

}

