﻿// --------------------------------------------------------------------------------
// <copyright>
// Copyright (C)Nintendo. All rights reserved.
//
// These coded instructions, statements, and computer programs contain proprietary
// information of Nintendo and/or its licensed developers and are protected by
// national and international copyright laws. They may not be disclosed to third
// parties or copied or duplicated in any form, in whole or in part, without the
// prior written consent of Nintendo.
//
// The content herein is highly confidential and should be handled accordingly.
// </copyright>
// --------------------------------------------------------------------------------


namespace NintendoWare.SoundFoundation.Projects
{
    using System.ComponentModel;
    using NintendoWare.SoundFoundation.Core.Parameters;
    using NintendoWare.ToolDevelopmentKit;

    public class CTRParameter : INotifyPropertyChanged
    {
        public const string PropertyNameFrontBypass = "FrontBypass";

        private bool frontBypass = false;

        /// <summary>
        /// プロパティ値が変更されたときに発生します。
        /// </summary>
        public event PropertyChangedEventHandler PropertyChanged;

        public bool FrontBypass
        {
            get { return this.frontBypass; }
            set
            {
                if (this.frontBypass == value)
                {
                    return;
                }

                this.frontBypass = value;
                this.OnNotifyPropertyChanged(new PropertyChangedEventArgs(PropertyNameFrontBypass));
            }
        }

        /// <summary>
        /// プロパティ値が変更されたときに発生します。
        /// </summary>
        /// <param name="e">イベントパラメータを指定します。</param>
        private void OnNotifyPropertyChanged(PropertyChangedEventArgs e)
        {
            Assertion.Argument.NotNull(e);

            if (this.PropertyChanged != null)
            {
                this.PropertyChanged(this, e);
            }
        }
    }
}
