﻿// --------------------------------------------------------------------------------
// <copyright>
// Copyright (C)Nintendo. All rights reserved.
//
// These coded instructions, statements, and computer programs contain proprietary
// information of Nintendo and/or its licensed developers and are protected by
// national and international copyright laws. They may not be disclosed to third
// parties or copied or duplicated in any form, in whole or in part, without the
// prior written consent of Nintendo.
//
// The content herein is highly confidential and should be handled accordingly.
// </copyright>
// --------------------------------------------------------------------------------

namespace NintendoWare.SoundFoundation.FileFormats.NintendoWareIntermediate
{
    using System;
    using NintendoWare.SoundFoundation.Core;
    using NintendoWare.SoundFoundation.Projects;
    using ToolDevelopmentKit;
    using ToolDevelopmentKit.Conversion;

    public class SoundSetXml2ModelTranslatorCtr : SoundSetXml2ModelTranslator
    {
        public SoundSetXml2ModelTranslatorCtr(IObjectFactory<Type, Component> componentFactory)
            : base(componentFactory, new SoundSetItemParamTranslatorCtr())
        {
            this.AddConverter<XmlSoundSetCtr, SoundSet>();
            this.AddConverter<XmlSoundSetItemFolderCtr, SoundSetItemPack>(XmlSoundSetItemFolderToSoundSetItemPack);
            this.AddConverter<XmlStreamSoundCtr, StreamSoundBase>();
            this.AddConverter<XmlStreamSoundTrack, StreamSoundTrackBase>();
            this.AddConverter<XmlWaveSoundSetCtr, WaveSoundSetBase>();
            this.AddConverter<XmlWaveSoundCtr, WaveSoundBase>();
            this.AddConverter<XmlSequenceSoundSetCtr, SequenceSoundSetBase>();
            this.AddConverter<XmlSequenceSoundCtr, SequenceSoundBase>();
            this.AddConverter<XmlSoundSetBank, SoundSetBankBase>();
            this.AddConverter<XmlPlayer, PlayerBase>();
            this.AddConverter<XmlWaveArchive, WaveArchiveBase>();
            this.AddConverter<XmlGroup, GroupBase>();
            this.AddConverter<XmlGroupItem, GroupItemBase>();
        }

        public SoundSet Run(XmlSoundSetCtr xmlSoundSetCtr)
        {
            return this.Run<SoundSet>(xmlSoundSetCtr) as SoundSet;
        }

        /// <summary>
        /// XmlSoundSetItemFolder から SoundSetItemPack に変換します。
        /// </summary>
        /// <param name="src">変換元のオブジェクトを指定します。</param>
        /// <param name="dstType">変換後の型を指定します。</param>
        /// <param name="converter">変換の状態です。Converterから渡されます。</param>
        /// <returns>変換後のオブジェクトを返します。</returns>
        private object XmlSoundSetItemFolderToSoundSetItemPack(object src, Type dstType, Converter converter)
        {
            Assertion.Argument.True(src is XmlSoundSetItemFolderCtr);
            Assertion.Argument.True(dstType == typeof(SoundSetItemPack));

            XmlSoundSetItemFolderCtr xmlSrc = src as XmlSoundSetItemFolderCtr;
            SoundSetItemPack dest = null;
            Type destType = null;

            switch (xmlSrc.Name)
            {
            case StreamSoundPack.ComponentName:
                dest = new StreamSoundPack();
                destType = typeof(StreamSoundBase);
                break;

            case WaveSoundSetPack.ComponentName:
                dest = new WaveSoundSetPack();
                destType = typeof(WaveSoundSetBase);
                break;

            case SequenceSoundSetPack.ComponentName:
                dest = new SequenceSoundSetPack();
                destType = typeof(SequenceSoundSetBase);
                break;

            case SequenceSoundPack.ComponentName:
                dest = new SequenceSoundPack();
                destType = typeof(SequenceSoundBase);
                break;

            case SoundSetBankPack.ComponentName:
                dest = new SoundSetBankPack();
                destType = typeof(SoundSetBankBase);
                break;

            case WaveArchivePack.ComponentName:
                dest = new WaveArchivePack();
                destType = typeof(WaveArchiveBase);
                break;

            case PlayerPack.ComponentName:
                dest = new PlayerPack();
                destType = typeof(PlayerBase);
                break;

            case GroupPack.ComponentName:
                dest = new GroupPack();
                destType = typeof(GroupBase);
                break;

            default:
                dest = new SoundSetItemPack(xmlSrc.Name);
                break;
            }

            TranslateParameters(xmlSrc, dest, converter);
            TranslateChildren(xmlSrc, dest, destType, converter);

            return dest;
        }
    }
}
