﻿// --------------------------------------------------------------------------------
// <copyright>
// Copyright (C)Nintendo. All rights reserved.
//
// These coded instructions, statements, and computer programs contain proprietary
// information of Nintendo and/or its licensed developers and are protected by
// national and international copyright laws. They may not be disclosed to third
// parties or copied or duplicated in any form, in whole or in part, without the
// prior written consent of Nintendo.
//
// The content herein is highly confidential and should be handled accordingly.
// </copyright>
// --------------------------------------------------------------------------------
using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;

namespace NintendoWare.SoundMaker.Preview.Communications
{
    public class CommunicationInfo
    {
        Dictionary<string, ConnectionInfo> connectionInfoDictionary = new Dictionary<string, ConnectionInfo>();

        public CommunicationInfo(string platform)
        {
            this.Platform = platform;
        }

        public string Platform { get; private set; }

        public void SetConnectionInfo(string key, ConnectionInfo connectionInfo)
        {
            if (this.connectionInfoDictionary.ContainsKey(key) == false)
            {
                this.connectionInfoDictionary[key] = connectionInfo;
            }
        }

        public IEnumerable<ConnectionInfo> ConnectionInfos
        {
            get
            {
                return this.connectionInfoDictionary.Values;
            }
        }
    }
}
