﻿// --------------------------------------------------------------------------------
// <copyright>
// Copyright (C)Nintendo. All rights reserved.
//
// These coded instructions, statements, and computer programs contain proprietary
// information of Nintendo and/or its licensed developers and are protected by
// national and international copyright laws. They may not be disclosed to third
// parties or copied or duplicated in any form, in whole or in part, without the
// prior written consent of Nintendo.
//
// The content herein is highly confidential and should be handled accordingly.
// </copyright>
// --------------------------------------------------------------------------------

using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;

namespace NintendoWare.SoundMaker.Framework.Windows.Forms
{
    using NintendoWare.SoundFoundation.Projects;

    /// <summary>
    /// シーケンスサウンド拡張
    /// </summary>
    public static class SequenceSoundEx
    {
        /// <summary>
        ///
        /// </summary>
        public static void InitializeBankReferences(this SequenceSoundBase sequenceSound, string targetName)
        {
            sequenceSound.SoundSetBankReferences.Clear();
            sequenceSound.SoundSetBankReferences.Add
                (new ComponentReference() { TargetName = targetName });

            for (int count = 0; count < SequenceSoundBase.BankReferenceCount - 1; count++)
            {
                sequenceSound.SoundSetBankReferences.Add
                    (new ComponentReference() { TargetName = String.Empty });
            }
        }
    }
}
