﻿// --------------------------------------------------------------------------------
// <copyright>
// Copyright (C)Nintendo. All rights reserved.
//
// These coded instructions, statements, and computer programs contain proprietary
// information of Nintendo and/or its licensed developers and are protected by
// national and international copyright laws. They may not be disclosed to third
// parties or copied or duplicated in any form, in whole or in part, without the
// prior written consent of Nintendo.
//
// The content herein is highly confidential and should be handled accordingly.
// </copyright>
// --------------------------------------------------------------------------------
using System;
using System.Collections.Generic;
using System.ComponentModel;
using System.Data;
using System.Drawing;
using System.Text;
using System.Windows.Forms;

namespace NintendoWare.SoundMaker.Framework.Windows.Forms
{
    public partial class UserDataEditDialog : Form
    {
        public UserDataEditDialog()
        {
            InitializeComponent();
        }

        ///--------------------------------
        /// <summary>
        /// 値の取得
        /// </summary>
        public ulong Value
        {
            get { return GetValueFromControl(); }
            set { SetValueToControl(value); }
        }

        ///--------------------------------
        /// <summary>
        ///
        /// </summary>
        private ulong GetValueFromControl()
        {
            ulong value = 0;

            value += checkBoxBit0.Checked ? 0x00000001UL : 0;
            value += checkBoxBit1.Checked ? 0x00000002UL : 0;
            value += checkBoxBit2.Checked ? 0x00000004UL : 0;
            value += checkBoxBit3.Checked ? 0x00000008UL : 0;
            value += checkBoxBit4.Checked ? 0x00000010UL : 0;
            value += checkBoxBit5.Checked ? 0x00000020UL : 0;
            value += checkBoxBit6.Checked ? 0x00000040UL : 0;
            value += checkBoxBit7.Checked ? 0x00000080UL : 0;
            value += checkBoxBit8.Checked ? 0x00000100UL : 0;
            value += checkBoxBit9.Checked ? 0x00000200UL : 0;
            value += checkBoxBit10.Checked ? 0x00000400UL : 0;
            value += checkBoxBit11.Checked ? 0x00000800UL : 0;
            value += checkBoxBit12.Checked ? 0x00001000UL : 0;
            value += checkBoxBit13.Checked ? 0x00002000UL : 0;
            value += checkBoxBit14.Checked ? 0x00004000UL : 0;
            value += checkBoxBit15.Checked ? 0x00008000UL : 0;
            value += checkBoxBit16.Checked ? 0x00010000UL : 0;
            value += checkBoxBit17.Checked ? 0x00020000UL : 0;
            value += checkBoxBit18.Checked ? 0x00040000UL : 0;
            value += checkBoxBit19.Checked ? 0x00080000UL : 0;
            value += checkBoxBit20.Checked ? 0x00100000UL : 0;
            value += checkBoxBit21.Checked ? 0x00200000UL : 0;
            value += checkBoxBit22.Checked ? 0x00400000UL : 0;
            value += checkBoxBit23.Checked ? 0x00800000UL : 0;
            value += checkBoxBit24.Checked ? 0x01000000UL : 0;
            value += checkBoxBit25.Checked ? 0x02000000UL : 0;
            value += checkBoxBit26.Checked ? 0x04000000UL : 0;
            value += checkBoxBit27.Checked ? 0x08000000UL : 0;
            value += checkBoxBit28.Checked ? 0x10000000UL : 0;
            value += checkBoxBit29.Checked ? 0x20000000UL : 0;
            value += checkBoxBit30.Checked ? 0x40000000UL : 0;
            value += checkBoxBit31.Checked ? 0x80000000UL : 0;

            return value;
        }

        ///--------------------------------
        /// <summary>
        ///
        /// </summary>
        private void SetValueToControl(ulong value)
        {
            ulong dw = (value & 0xFFFFFFFF) >> 0;
            ulong lw = (value & 0x0000FFFF) >> 0;
            ulong hw = (value & 0xFFFF0000) >> 16;
            ulong llw = (value & 0x000000FF) >> 0;
            ulong lhw = (value & 0x0000FF00) >> 8;
            ulong hlw = (value & 0x00FF0000) >> 16;
            ulong hhw = (value & 0xFF000000) >> 24;

            //
            textBoxDW.Text = dw.ToString();

            textBoxLW.Text = lw.ToString();
            textBoxHW.Text = hw.ToString();

            textBoxLLW.Text = llw.ToString();
            textBoxLHW.Text = lhw.ToString();
            textBoxHLW.Text = hlw.ToString();
            textBoxHHW.Text = hhw.ToString();

            //
            checkBoxBit0.Checked = (value & 0x00000001) != 0;
            checkBoxBit1.Checked = (value & 0x00000002) != 0;
            checkBoxBit2.Checked = (value & 0x00000004) != 0;
            checkBoxBit3.Checked = (value & 0x00000008) != 0;
            checkBoxBit4.Checked = (value & 0x00000010) != 0;
            checkBoxBit5.Checked = (value & 0x00000020) != 0;
            checkBoxBit6.Checked = (value & 0x00000040) != 0;
            checkBoxBit7.Checked = (value & 0x00000080) != 0;
            checkBoxBit8.Checked = (value & 0x00000100) != 0;
            checkBoxBit9.Checked = (value & 0x00000200) != 0;
            checkBoxBit10.Checked = (value & 0x00000400) != 0;
            checkBoxBit11.Checked = (value & 0x00000800) != 0;
            checkBoxBit12.Checked = (value & 0x00001000) != 0;
            checkBoxBit13.Checked = (value & 0x00002000) != 0;
            checkBoxBit14.Checked = (value & 0x00004000) != 0;
            checkBoxBit15.Checked = (value & 0x00008000) != 0;
            checkBoxBit16.Checked = (value & 0x00010000) != 0;
            checkBoxBit17.Checked = (value & 0x00020000) != 0;
            checkBoxBit18.Checked = (value & 0x00040000) != 0;
            checkBoxBit19.Checked = (value & 0x00080000) != 0;
            checkBoxBit20.Checked = (value & 0x00100000) != 0;
            checkBoxBit21.Checked = (value & 0x00200000) != 0;
            checkBoxBit22.Checked = (value & 0x00400000) != 0;
            checkBoxBit23.Checked = (value & 0x00800000) != 0;
            checkBoxBit24.Checked = (value & 0x01000000) != 0;
            checkBoxBit25.Checked = (value & 0x02000000) != 0;
            checkBoxBit26.Checked = (value & 0x04000000) != 0;
            checkBoxBit27.Checked = (value & 0x08000000) != 0;
            checkBoxBit28.Checked = (value & 0x10000000) != 0;
            checkBoxBit29.Checked = (value & 0x20000000) != 0;
            checkBoxBit30.Checked = (value & 0x40000000) != 0;
            checkBoxBit31.Checked = (value & 0x80000000) != 0;
        }


        private void UserDataEditDialog_Load(object sender, EventArgs e)
        {

        }

        ///--------------------------------
        /// <summary>
        ///
        /// </summary>
        private ulong ParseValue(string text)
        {
            ulong value = 0;

            try
            {
                value = ulong.Parse(text);
            }

            catch { }
            return value;
        }

        ///--------------------------------
        /// <summary>
        ///
        /// </summary>
        private void OnValidatedDW(object sender, EventArgs e)
        {
            SetValueToControl(ParseValue(textBoxDW.Text));
        }

        ///--------------------------------
        /// <summary>
        ///
        /// </summary>
        private void OnValidatedLW(object sender, EventArgs e)
        {
            ulong lw = ParseValue(textBoxLW.Text);
            ulong hw = ParseValue(textBoxHW.Text);
            ulong value = (hw << 16) | lw;

            SetValueToControl(value);
        }

        ///--------------------------------
        /// <summary>
        ///
        /// </summary>
        private void OnValidatedHW(object sender, EventArgs e)
        {
            OnValidatedLW(sender, e);
        }

        ///--------------------------------
        /// <summary>
        ///
        /// </summary>
        private void OnValidatedLLW(object sender, EventArgs e)
        {
            ulong llw = ParseValue(textBoxLLW.Text);
            ulong lhw = ParseValue(textBoxLHW.Text);
            ulong hlw = ParseValue(textBoxHLW.Text);
            ulong hhw = ParseValue(textBoxHHW.Text);
            ulong value = 0;

            value = ((hhw << 24) |
                     (hlw << 16) |
                     (lhw << 8) |
                     (llw << 0));

            SetValueToControl(value);
        }

        ///--------------------------------
        /// <summary>
        ///
        /// </summary>
        private void OnValidatedLHW(object sender, EventArgs e)
        {
            OnValidatedLLW(sender, e);
        }

        ///--------------------------------
        /// <summary>
        ///
        /// </summary>
        private void OnValidatedHLW(object sender, EventArgs e)
        {
            OnValidatedLLW(sender, e);
        }

        ///--------------------------------
        /// <summary>
        ///
        /// </summary>
        private void OnValidatedHHW(object sender, EventArgs e)
        {
            OnValidatedLLW(sender, e);
        }

        ///--------------------------------
        /// <summary>
        ///
        /// </summary>
        private void OnCheckedChanged(object sender, EventArgs e)
        {
            ulong value = GetValueFromControl();

            SetValueToControl(value);
        }
    }
}
