﻿// --------------------------------------------------------------------------------
// <copyright>
// Copyright (C)Nintendo. All rights reserved.
//
// These coded instructions, statements, and computer programs contain proprietary
// information of Nintendo and/or its licensed developers and are protected by
// national and international copyright laws. They may not be disclosed to third
// parties or copied or duplicated in any form, in whole or in part, without the
// prior written consent of Nintendo.
//
// The content herein is highly confidential and should be handled accordingly.
// </copyright>
// --------------------------------------------------------------------------------

using System;
using System.Collections.Generic;
using System.ComponentModel;
using System.Data;
using System.Diagnostics;
using System.Drawing;
using System.Linq;
using System.Text;
using System.Windows.Forms;

namespace NintendoWare.SoundMaker.Framework.Windows.Forms
{
    using NintendoWare.SoundMaker.Framework.Resources;

    public partial class UserDataCheckBoxPanel : UserControl, IPartialValueManipulator
    {
        /// <summary>
        ///
        /// </summary>
        public UserDataCheckBoxPanel()
        {
            InitializeComponent();

            this.checkBox.CheckedChanged += OnCheckedChanged;

            UpdateControls();
        }

        /// <summary>
        ///
        /// </summary>
        public string Label
        {
            get { return this.checkBox.Text; }
            set { this.checkBox.Text = value; }
        }

        /// <summary>
        ///
        /// </summary>
        public int BitLocation
        {
            get;
            set;
        }

        /// <summary>
        ///
        /// </summary>
        public virtual int BitSize
        {
            get
            {
                return 1;
            }
            set
            {
            }
        }

        /// <summary>
        ///
        /// </summary>
        public virtual object Value
        {
            get
            {
                return checkBox.Checked;
            }
            set
            {
                Debug.Assert(value is bool, "Value is not boolean");
                this.checkBox.Checked = (bool)value;
                UpdateControls();
            }
        }

        /// <summary>
        ///
        /// </summary>
        ulong IPartialValueManipulator.GetPartialValue()
        {
            return GetPartialValueCore();
        }

        /// <summary>
        ///
        /// </summary>
        protected ulong GetMask(int size)
        {
            return (1UL << size) - 1;
        }

        /// <summary>
        ///
        /// </summary>
        protected virtual ulong GetPartialValueCore()
        {
            bool parsedValue = this.checkBox.Checked;
            ulong value = 0;

            if (parsedValue != false)
            {
                value = 1UL << BitLocation;
            }

            return value;
        }

        ///
        protected class ValidateResult
        {
            public enum Types
            {
                Done,
                BadFormat,
                OutsideValueRange,
            }

            private Types type = Types.Done;
            private string message = null;

            public ValidateResult()
            {
            }

            public ValidateResult(Types type, string message)
            {
                this.type = type;
                this.message = message;
            }

            public Types Type
            {
                get
                {
                    return this.type;
                }
            }

            public string Message
            {
                get
                {
                    return this.message;
                }
            }
        }

#if false
        /// <summary>
        ///
        /// </summary>
        protected virtual ValidateResult Validate( string text)
        {
            bool value = false;

            if( bool.TryParse( text, out value) != false )
            {
                return new ValidateResult();
            }
            else
            {
                return new ValidateResult
                    ( ValidateResult.Types.BadFormat,
                      MessageResource.Message_ErrorProvider_BadFormat);
            }
        }
#endif

        /// <summary>
        ///
        /// </summary>
        protected void UpdateControls()
        {
#if false
            ValidateResult result = Validate( this.checkBox.Text);
            switch( result.Type )
            {
            case ValidateResult.Types.Done:
                SetErrorMessage( null);
                break;

            case ValidateResult.Types.BadFormat:
            case ValidateResult.Types.OutsideValueRange:
                SetErrorMessage( result.Message);
                break;
            }
#endif
        }

        /// <summary>
        ///
        /// </summary>
        private void SetErrorMessage(string message)
        {
            if (message != null)
            {
                errorProvider.SetError(this.checkBox, message);
            }
            else
            {
                errorProvider.Clear();
            }
        }

        /// <summary>
        ///
        /// </summary>
        private void OnCheckedChanged(object sender, EventArgs e)
        {
            UpdateControls();
        }
    }

    /// <summary>
    ///
    /// </summary>
    public partial class UserDataBooleanPanel : UserDataCheckBoxPanel
    {
    }
}
