﻿// --------------------------------------------------------------------------------
// <copyright>
// Copyright (C)Nintendo. All rights reserved.
//
// These coded instructions, statements, and computer programs contain proprietary
// information of Nintendo and/or its licensed developers and are protected by
// national and international copyright laws. They may not be disclosed to third
// parties or copied or duplicated in any form, in whole or in part, without the
// prior written consent of Nintendo.
//
// The content herein is highly confidential and should be handled accordingly.
// </copyright>
// --------------------------------------------------------------------------------
using System;
using System.Drawing;
using System.Collections;
using System.ComponentModel;
using System.Windows.Forms;
using System.Resources;
using System.Reflection;
using NintendoWare.SoundFoundation.Core;
using NintendoWare.SoundFoundation.Projects;
using NintendoWare.SoundMaker.Framework.Resources;

namespace NintendoWare.SoundMaker.Framework.Windows.Forms
{
    ///--------------------------------------------------------------------------
    /// <summary>
    /// CreateSequenceSoundSetDialog の概要の説明です。
    /// </summary>
    public partial class CreateSequenceSoundSetDialog : CreateSoundSetItemDialog
    {

        private readonly SequenceSoundSetBase _soundSetItem = ApplicationBase.Instance.CreateComponentService.Create<SequenceSoundSetBase>();

        ///--------------------------------
        /// <summary>
        /// コンストラクタ
        /// </summary>
        public CreateSequenceSoundSetDialog(SoundProjectService projectService) : base(projectService)
        {
            InitializeComponent();

            //
            SetUniqueNameToTextBox(textBox_Label, projectService.Project,
                                    ProjectService.ComponentDictionary,
                                    ProjectService.Project.SequenceSoundSetNamePrefix);
        }

        ///--------------------------------
        /// <summary>
        ///
        /// </summary>
        private string Label
        {
            get { return textBox_Label.Text; }
        }

        public SequenceSoundSetBase SoundSetItem
        {
            get
            {
                _soundSetItem.Name = textBox_Label.Text;

                return _soundSetItem;
            }
        }

        ///--------------------------------
        /// <summary>
        ///
        /// </summary>
        protected override bool CanCreate
        {
            get
            {
                if (InspectLabel())
                {
                    return true;
                }
                return false;
            }
        }

        ///--------------------------------
        /// <summary>
        /// ラベルの検査
        /// </summary>
        private bool InspectLabel()
        {
            return ValidateName(textBox_Label.Text, textBox_Label);
        }

        ///--------------------------------
        /// <summary>
        /// 確定に使用するボタンの取得
        /// </summary>
        protected override Control GetAcceptButton()
        {
            return button_OK;
        }

        ///--------------------------------
        /// <summary>
        ///
        /// </summary>
        private void OnTextChanged(object sender, System.EventArgs e)
        {
            UpdateControls();
        }

        ///--------------------------------
        /// <summary>
        ///
        /// </summary>
        private void OnValidatedLabel(object sender, System.EventArgs e)
        {
            InspectLabel();
            UpdateControls();
        }
    }
}
