﻿// --------------------------------------------------------------------------------
// <copyright>
// Copyright (C)Nintendo. All rights reserved.
//
// These coded instructions, statements, and computer programs contain proprietary
// information of Nintendo and/or its licensed developers and are protected by
// national and international copyright laws. They may not be disclosed to third
// parties or copied or duplicated in any form, in whole or in part, without the
// prior written consent of Nintendo.
//
// The content herein is highly confidential and should be handled accordingly.
// </copyright>
// --------------------------------------------------------------------------------

namespace NintendoWare.SoundMaker.Windows.Forms
{
    using System;
    using System.Collections.Generic;
    using System.ComponentModel;
    using System.Data;
    using System.Drawing;
    using System.IO;
    using System.Linq;
    using System.Text;
    using System.Windows.Forms;
    using NintendoWare.SoundFoundation.Core;
    using NintendoWare.SoundFoundation.Projects;
    using NintendoWare.SoundMaker.Framework.Windows;
    using NintendoWare.SoundMaker.Framework.Windows.Forms;
    using FrameworkResources = NintendoWare.SoundMaker.Framework.Resources;

    public partial class ConvertSmfFileDialog : Form
    {
        private string _initDestFolderPath = string.Empty;

        public ConvertSmfFileDialog(string initDestinationFolderPath)
            : this()
        {
            _initDestFolderPath =
                (null != initDestinationFolderPath) ? initDestinationFolderPath : string.Empty;
            this.textBoxDestination.Text = _initDestFolderPath;
            this.labelDistination.Text =
                FrameworkResources.MessageResource.Label_ConvertSmfFileDialog_DestinationFolder;
        }

        private ConvertSmfFileDialog()
        {
            InitializeComponent();
        }

        public string DestinationFolderPath
        {
            get
            {
                return this.textBoxDestination.Text;
            }
        }

        public bool IsOpenDestinationFolder
        {
            get { return checkBoxDestination.Checked; }
            set { checkBoxDestination.Checked = value; }
        }

        private bool IsValid
        {
            get
            {
                if (0 < errorProvider.GetError(this.textBoxDestination).Length) { return false; }
                return true;
            }
        }

        private void UpdateButton()
        {
            buttonOK.Enabled = IsValid;
        }

        private void SetError(Control control, string message)
        {
            if (null == control) { throw new ArgumentNullException("control"); }
            if (null == message) { throw new ArgumentNullException("message"); }

            errorProvider.SetError(control, message);
            UpdateButton();
        }

        private bool ValidateDestinationFolder()
        {
            if (Directory.Exists(DestinationFolderPath)) { return true; }

            if (FormsApplication.Instance.UIService.ShowMessageBox(
                    FrameworkResources.MessageResource.Message_ConfirmCreateFolder,
                    null, AppMessageBoxButton.OKCancel, AppMessageBoxImage.Question,
                    AppMessageBoxResult.OK) != AppMessageBoxResult.OK) { return false; }

            return true;
        }

        private void ValidateDestination()
        {
            if (0 == this.textBoxDestination.Text.Length)
            {
                SetError(this.textBoxDestination, FrameworkResources.MessageResource.Message_InputPath);
                return;
            }

            ValidationResult result = FilePathValidator.ValidateFilePath(this.textBoxDestination.Text);

            if (!result.IsValid)
            {
                SetError(this.textBoxDestination, result.ToString());
                return;
            }

            SetError(this.textBoxDestination, string.Empty);
        }

        private void OnReferClick(object sender, EventArgs e)
        {
            string initPath = ((0 < this.textBoxDestination.Text.Length) ?
                               this.textBoxDestination.Text : _initDestFolderPath);

            FolderBrowserDialog dialog =
                new FolderBrowserDialog()
                {
                    SelectedPath = initPath,
                };

            if (dialog.ShowDialog() != DialogResult.OK)
            {
                return;
            }
            this.textBoxDestination.Text = dialog.SelectedPath;

            ValidateChildren();
        }

        private void OnOKClick(object sender, EventArgs e)
        {
            DialogResult = DialogResult.Cancel;

            if (!ValidateDestinationFolder())
            {
                return;
            }

            DialogResult = DialogResult.OK;
        }

        private void OnDestinationValidating(object sender, CancelEventArgs e)
        {
            ValidateDestination();
        }

        private void OnDestinationTextChanged(object sender, EventArgs e)
        {
            ValidateDestination();
        }
    }
}
